/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.helpers.featuresources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import nl.tailormap.viewer.config.services.ArcGISFeatureSource;
import nl.tailormap.viewer.config.services.FeatureSource;
import nl.tailormap.viewer.config.services.FeatureSourceUpdateResult;
import nl.tailormap.viewer.config.services.JDBCFeatureSource;
import nl.tailormap.viewer.config.services.SimpleFeatureType;
import nl.tailormap.viewer.config.services.UpdateResult;
import nl.tailormap.viewer.config.services.WFSFeatureSource;
import nl.tailormap.viewer.helpers.featuresources.ArcGISFeatureSourceHelper;
import nl.tailormap.viewer.helpers.featuresources.FeatureSourceHelper;
import nl.tailormap.viewer.helpers.featuresources.JDBCFeatureSourceHelper;
import nl.tailormap.viewer.helpers.featuresources.WFSFeatureSourceHelper;
import nl.tailormap.web.WaitPageStatus;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Not;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.stripesstuff.stripersist.Stripersist;

public class FeatureSourceFactoryHelper {
    public static final int MAX_FEATURES_DEFAULT = 250;
    private static final Log log = LogFactory.getLog(FeatureSourceFactoryHelper.class);
    private static final int updatebatchsize = 50;

    public static Boolean isUpdatable(FeatureSource fs) {
        return fs instanceof WFSFeatureSource || fs instanceof JDBCFeatureSource;
    }

    public static org.geotools.data.FeatureSource openGeoToolsFeatureSource(SimpleFeatureType sft, int timeout) throws Exception {
        return FeatureSourceFactoryHelper.openGeoToolsFeatureSource(sft.getFeatureSource(), sft, timeout);
    }

    public static org.geotools.data.FeatureSource openGeoToolsFeatureSource(SimpleFeatureType sft) throws Exception {
        return FeatureSourceFactoryHelper.openGeoToolsFeatureSource(sft.getFeatureSource(), sft, 30);
    }

    public static org.geotools.data.FeatureSource openGeoToolsFeatureSource(FeatureSource fs, SimpleFeatureType sft) throws Exception {
        return FeatureSourceFactoryHelper.openGeoToolsFeatureSource(fs, sft, 30);
    }

    public static org.geotools.data.FeatureSource openGeoToolsFeatureSource(FeatureSource fs, SimpleFeatureType sft, int timeout) throws Exception {
        FeatureSourceHelper sh = FeatureSourceFactoryHelper.getHelper(fs);
        return sh.openGeoToolsFeatureSource(fs, sft, timeout);
    }

    public static List<SimpleFeatureType> createFeatureTypes(FeatureSource fs, WaitPageStatus status) throws Exception {
        FeatureSourceHelper sh = FeatureSourceFactoryHelper.getHelper(fs);
        return sh.createFeatureTypes(fs, status);
    }

    public static FeatureSourceHelper getHelper(FeatureSource fs) {
        if (fs instanceof JDBCFeatureSource) {
            return new JDBCFeatureSourceHelper();
        }
        if (fs instanceof WFSFeatureSource) {
            return new WFSFeatureSourceHelper();
        }
        if (fs instanceof ArcGISFeatureSource) {
            return new ArcGISFeatureSourceHelper();
        }
        return null;
    }

    public static FeatureSourceUpdateResult update(EntityManager em, FeatureSource fs) throws Exception {
        FeatureSourceUpdateResult result = new FeatureSourceUpdateResult(fs);
        try {
            List<SimpleFeatureType> newFeatureTypes = FeatureSourceFactoryHelper.createFeatureTypes(fs, result.getWaitPageStatus().subtask("", 80.0f));
            int processed = 0;
            for (SimpleFeatureType newFt : newFeatureTypes) {
                MutableBoolean updated = new MutableBoolean();
                fs.addOrUpdateFeatureType(newFt.getTypeName(), newFt, updated);
                MutablePair ftResult = (MutablePair)result.getFeatureTypeStatus().get(newFt.getTypeName());
                if (ftResult == null) {
                    result.getFeatureTypeStatus().put(newFt.getTypeName(), (MutablePair<SimpleFeatureType, UpdateResult.Status>)new MutablePair((Object)newFt, (Object)UpdateResult.Status.NEW));
                } else if (updated.isTrue()) {
                    log.info((Object)("Feature type: " + newFt.getTypeName() + " updated"));
                    ftResult.setRight((Object)UpdateResult.Status.UPDATED);
                } else {
                    ftResult.setRight((Object)UpdateResult.Status.UNMODIFIED);
                }
                if (++processed != 50) continue;
                processed = 0;
                if (!em.getTransaction().isActive()) {
                    em.getTransaction().begin();
                }
                em.persist((Object)fs);
                em.getTransaction().commit();
                em.getTransaction().begin();
            }
            if (!em.getTransaction().isActive()) {
                em.getTransaction().begin();
            }
            em.persist((Object)fs);
            em.getTransaction().commit();
            em.getTransaction().begin();
            processed = 0;
            Iterator it = fs.getFeatureTypes().iterator();
            while (it.hasNext()) {
                SimpleFeatureType oldFt = (SimpleFeatureType)it.next();
                boolean stillExists = false;
                for (SimpleFeatureType newFt : newFeatureTypes) {
                    if (!newFt.getTypeName().equals(oldFt.getTypeName())) continue;
                    stillExists = true;
                    break;
                }
                if (!stillExists) {
                    it.remove();
                    em.remove((Object)oldFt);
                }
                if (processed != 50) continue;
                processed = 0;
                if (!em.getTransaction().isActive()) {
                    em.getTransaction().begin();
                }
                em.persist((Object)fs);
                em.getTransaction().commit();
                em.getTransaction().begin();
            }
            result.setStatus(UpdateResult.Status.UPDATED);
        }
        catch (Exception e) {
            result.failedWithException(e);
        }
        return result;
    }

    public static void removeFeatureType(FeatureSource fs, SimpleFeatureType featureType) {
        Stripersist.getEntityManager().remove((Object)featureType);
        fs.getFeatureTypes().remove(featureType);
    }

    public static List<String> calculateUniqueValues(SimpleFeatureType sft, String attributeName, Filter filter) throws Exception {
        return FeatureSourceFactoryHelper.calculateUniqueValues(sft, attributeName, 250, filter);
    }

    public static List<String> calculateUniqueValues(SimpleFeatureType sft, String attributeName, int maxFeatures, Filter filter) throws Exception {
        org.geotools.data.FeatureSource fs = null;
        try {
            FeatureCollection fc;
            Object o;
            HashSet uniqueValues;
            Not notNull;
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
            Function unique = ff.function("Collection_Unique", new Expression[]{ff.property(attributeName)});
            Not f = notNull = ff.not((Filter)ff.isNull((Expression)ff.property(attributeName)));
            if (filter != null) {
                f = ff.and((Filter)notNull, filter);
            }
            Query q = new Query(sft.getTypeName(), (Filter)f);
            if (maxFeatures != -1) {
                q.setMaxFeatures(maxFeatures);
            }
            if ((uniqueValues = (HashSet)(o = unique.evaluate((Object)(fc = (fs = FeatureSourceFactoryHelper.openGeoToolsFeatureSource(sft)).getFeatures(q))))) == null) {
                uniqueValues = new HashSet();
            }
            ArrayList<String> l = new ArrayList<String>(uniqueValues);
            Collections.sort(l);
            ArrayList<String> arrayList = l;
            return arrayList;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (fs != null && fs.getDataStore() != null) {
                fs.getDataStore().dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getKeyValuePairs(SimpleFeatureType sft, String key, String label, int maxFeatures) throws Exception {
        TreeMap<String, String> output = new TreeMap<String, String>();
        SimpleFeatureSource fs = null;
        try {
            fs = (SimpleFeatureSource)FeatureSourceFactoryHelper.openGeoToolsFeatureSource(sft);
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
            Not notNull = ff.not((Filter)ff.isNull((Expression)ff.property(key)));
            Query q = new Query(sft.getTypeName(), (Filter)notNull);
            q.setMaxFeatures(maxFeatures);
            q.setPropertyNames(new String[]{key, label});
            try (SimpleFeatureIterator iterator = fs.getFeatures(q).features();){
                while (iterator.hasNext()) {
                    SimpleFeature f = (SimpleFeature)iterator.next();
                    output.put(f.getAttribute(key).toString(), f.getAttribute(label).toString());
                }
            }
            TreeMap<String, String> treeMap = output;
            return treeMap;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (fs != null && fs.getDataStore() != null) {
                fs.getDataStore().dispose();
            }
        }
    }

    public static Object getMaxValue(SimpleFeatureType sft, String attributeName, int maxFeatures, Filter f) throws Exception {
        org.geotools.data.FeatureSource fs = null;
        try {
            Object value;
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
            Function max = ff.function("Collection_Max", new Expression[]{ff.property(attributeName)});
            fs = FeatureSourceFactoryHelper.openGeoToolsFeatureSource(sft);
            FeatureCollection fc = f != null ? fs.getFeatures(f) : fs.getFeatures();
            Object object = value = max.evaluate((Object)fc);
            return object;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (fs != null && fs.getDataStore() != null) {
                fs.getDataStore().dispose();
            }
        }
    }

    public static Object getMinValue(SimpleFeatureType sft, String attributeName, int maxFeatures, Filter filter) throws Exception {
        org.geotools.data.FeatureSource fs = null;
        try {
            Object o;
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
            Function minFunction = ff.function("Collection_Min", new Expression[]{ff.property(attributeName)});
            fs = FeatureSourceFactoryHelper.openGeoToolsFeatureSource(sft);
            FeatureCollection f = filter != null ? fs.getFeatures(filter) : fs.getFeatures();
            Object object = o = minFunction.evaluate((Object)f);
            return object;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (fs != null && fs.getDataStore() != null) {
                fs.getDataStore().dispose();
            }
        }
    }
}

