/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.helpers.featuresources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.tailormap.viewer.config.services.FeatureSource;
import nl.tailormap.viewer.config.services.WFSFeatureSource;
import nl.tailormap.viewer.helpers.featuresources.FeatureSourceHelper;
import nl.tailormap.web.WaitPageStatus;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.Filter;

public class WFSFeatureSourceHelper
implements FeatureSourceHelper {
    private static final Log log = LogFactory.getLog(WFSFeatureSourceHelper.class);
    public static final Integer TIMEOUT = 60000;

    @Override
    public List<nl.tailormap.viewer.config.services.SimpleFeatureType> createFeatureTypes(FeatureSource fs, WaitPageStatus status) throws Exception {
        return WFSFeatureSourceHelper.createFSFeatureTypes((WFSFeatureSource)fs, status);
    }

    @Override
    public org.geotools.data.FeatureSource openGeoToolsFeatureSource(FeatureSource fs, nl.tailormap.viewer.config.services.SimpleFeatureType sft) throws Exception {
        return this.openGeoToolsFeatureSource(fs, sft, TIMEOUT);
    }

    @Override
    public org.geotools.data.FeatureSource openGeoToolsFeatureSource(FeatureSource fs, nl.tailormap.viewer.config.services.SimpleFeatureType sft, int timeout) throws Exception {
        return WFSFeatureSourceHelper.openGeoToolsFSFeatureSource(sft, timeout, (WFSFeatureSource)fs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<nl.tailormap.viewer.config.services.SimpleFeatureType> createFSFeatureTypes(WFSFeatureSource fs, WaitPageStatus status) throws Exception {
        status.setCurrentAction("Ophalen informatie...");
        ArrayList<nl.tailormap.viewer.config.services.SimpleFeatureType> createdFeatureTypes = new ArrayList<nl.tailormap.viewer.config.services.SimpleFeatureType>();
        DataStore store = null;
        try {
            store = WFSFeatureSourceHelper.createDataStore(fs);
            fs.setName(store.getInfo().getTitle());
            status.setProgress(10);
            status.setCurrentAction("Lijst van type-namen ophalen...");
            String[] typeNames = store.getTypeNames();
            status.setProgress(20);
            if (typeNames.length != 0) {
                double progress = 20.0;
                double progressPerTypeName = 80.0 / (double)typeNames.length;
                for (String typeName : typeNames) {
                    status.setCurrentAction("Inladen schema van type \"" + typeName + "\"...");
                    log.debug((Object)("Loading feature source " + typeName + " for WFS url " + fs.getUrl()));
                    SimpleFeatureSource gtFs = store.getFeatureSource(typeName);
                    nl.tailormap.viewer.config.services.SimpleFeatureType sft = new nl.tailormap.viewer.config.services.SimpleFeatureType();
                    sft.setTypeName(typeName);
                    sft.setFeatureSource((FeatureSource)fs);
                    sft.setWriteable(false);
                    if (gtFs.getInfo() != null) {
                        String title = gtFs.getInfo().getTitle();
                        sft.setDescription(StringUtils.isBlank((CharSequence)title) ? null : title);
                    }
                    SimpleFeatureType gtFt = (SimpleFeatureType)gtFs.getSchema();
                    for (AttributeDescriptor gtAtt : gtFt.getAttributeDescriptors()) {
                        nl.tailormap.viewer.config.services.AttributeDescriptor att = new nl.tailormap.viewer.config.services.AttributeDescriptor();
                        sft.getAttributes().add(att);
                        att.setName(gtAtt.getLocalName());
                        AttributeType gtType = gtAtt.getType();
                        String binding = gtType.getBinding().getName();
                        String type = "";
                        if (binding.equals("org.locationtech.jts.geom.MultiPolygon")) {
                            type = "multipolygon";
                        } else if (binding.equals("org.locationtech.jts.geom.Polygon")) {
                            type = "polygon";
                        } else if (binding.equals("org.locationtech.jts.geom.Geometry")) {
                            type = "geometry";
                        } else if (binding.equals("org.locationtech.jts.geom.LineString")) {
                            type = "linestring";
                        } else if (binding.equals("org.locationtech.jts.geom.Point")) {
                            type = "point";
                        } else if (binding.equals("org.locationtech.jts.geom.MultiLineString")) {
                            type = "multilinestring";
                        } else if (binding.equals("org.locationtech.jts.geom.MultiPoint")) {
                            type = "multipoint";
                        } else if (binding.equals("java.lang.Boolean")) {
                            type = "boolean";
                        } else if (binding.equals("java.lang.Long")) {
                            type = "integer";
                        } else if (binding.equals("java.lang.String")) {
                            type = "string";
                        } else if (binding.equals("java.lang.Integer")) {
                            type = "integer";
                        } else if (binding.equals("java.lang.Short")) {
                            type = "integer";
                        } else if (binding.equals("java.lang.Double")) {
                            type = "double";
                        } else if (binding.equals("java.lang.Float")) {
                            type = "double";
                        } else if (binding.equals("java.sql.Timestamp")) {
                            type = "timestamp";
                        } else if (binding.equals("java.sql.Date")) {
                            type = "date";
                        } else if (binding.equals("java.math.BigDecimal")) {
                            type = "double";
                        }
                        if (sft.getGeometryAttribute() == null && gtType instanceof GeometryType) {
                            sft.setGeometryAttribute(att.getName());
                        }
                        att.setType(type);
                    }
                    createdFeatureTypes.add(sft);
                    status.setProgress((int)(progress += progressPerTypeName));
                }
            }
        }
        finally {
            status.setProgress(100);
            status.setCurrentAction("Service ingeladen");
            status.setFinished(true);
            if (store != null) {
                store.dispose();
            }
        }
        return createdFeatureTypes;
    }

    public static DataStore createDataStore(WFSFeatureSource fs) throws Exception {
        return WFSFeatureSourceHelper.createDataStore(null, fs);
    }

    public static DataStore createDataStore(Map extraDataStoreParams, WFSFeatureSource fs) throws Exception {
        Object wfsUrl;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(WFSDataStoreFactory.TIMEOUT.key, TIMEOUT);
        if (extraDataStoreParams != null) {
            params.putAll(extraDataStoreParams);
        }
        if (!((String)(wfsUrl = fs.getUrl())).endsWith("&") && !((String)wfsUrl).endsWith("?")) {
            wfsUrl = (String)wfsUrl + (((String)wfsUrl).indexOf("?") >= 0 ? "&" : "?");
        }
        if (!((String)(wfsUrl = (String)wfsUrl + "REQUEST=GetCapabilities&SERVICE=WFS")).toUpperCase().contains("VERSION")) {
            wfsUrl = (String)wfsUrl + "&VERSION=1.1.0";
        }
        params.put(WFSDataStoreFactory.URL.key, wfsUrl);
        params.put(WFSDataStoreFactory.USERNAME.key, fs.getUsername());
        params.put(WFSDataStoreFactory.PASSWORD.key, fs.getPassword());
        HashMap<String, String> logParams = new HashMap<String, String>(params);
        if (fs.getPassword() != null) {
            logParams.put(WFSDataStoreFactory.PASSWORD.key, String.valueOf(new char[fs.getPassword().length()]).replace("\u0000", "*"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Opening datastore using parameters: " + logParams));
        }
        try {
            DataStore ds = DataStoreFinder.getDataStore(params);
            if (ds == null) {
                throw new Exception("Cannot open datastore using parameters " + logParams);
            }
            return ds;
        }
        catch (Exception e) {
            throw new Exception("Cannot open datastore using parameters " + logParams, e);
        }
    }

    public static org.geotools.data.FeatureSource openGeoToolsFSFeatureSource(nl.tailormap.viewer.config.services.SimpleFeatureType sft, WFSFeatureSource fs) throws Exception {
        return WFSFeatureSourceHelper.openGeoToolsFSFeatureSource(sft, null, fs);
    }

    public static org.geotools.data.FeatureSource openGeoToolsFSFeatureSource(nl.tailormap.viewer.config.services.SimpleFeatureType sft, int timeout, WFSFeatureSource fs) throws Exception {
        HashMap<String, Integer> extraParams = new HashMap<String, Integer>();
        extraParams.put(WFSDataStoreFactory.TIMEOUT.key, timeout);
        DataStore ds = WFSFeatureSourceHelper.createDataStore(extraParams, fs);
        return ds.getFeatureSource(sft.getTypeName());
    }

    public static org.geotools.data.FeatureSource openGeoToolsFSFeatureSource(nl.tailormap.viewer.config.services.SimpleFeatureType sft, Map extraDataStoreParams, WFSFeatureSource fs) throws Exception {
        DataStore ds = WFSFeatureSourceHelper.createDataStore(extraDataStoreParams, fs);
        return ds.getFeatureSource(sft.getTypeName());
    }

    public static FeatureCollection getFeatures(nl.tailormap.viewer.config.services.SimpleFeatureType sft, Filter f, int maxFeatures) throws Exception {
        Query q = null;
        q = f != null ? new Query(sft.getTypeName(), f) : new Query(sft.getTypeName());
        q.setMaxFeatures(maxFeatures);
        FeatureCollection fc = WFSFeatureSourceHelper.openGeoToolsFSFeatureSource(sft, (WFSFeatureSource)sft.getFeatureSource()).getFeatures(q);
        return fc;
    }

    public static void loadFeatureTypes(WFSFeatureSource fs) throws Exception {
        WFSFeatureSourceHelper.loadFeatureTypes(fs, new WaitPageStatus());
    }

    public static void loadFeatureTypes(WFSFeatureSource fs, WaitPageStatus status) throws Exception {
        fs.getFeatureTypes().addAll(WFSFeatureSourceHelper.createFSFeatureTypes(fs, status));
    }
}

