/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.helpers.services;

import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import nl.tailormap.viewer.config.ClobElement;
import nl.tailormap.viewer.config.RemoveEmptyMapValuesUtil;
import nl.tailormap.viewer.config.services.ArcGISFeatureSource;
import nl.tailormap.viewer.config.services.ArcGISService;
import nl.tailormap.viewer.config.services.AttributeDescriptor;
import nl.tailormap.viewer.config.services.BoundingBox;
import nl.tailormap.viewer.config.services.CoordinateReferenceSystem;
import nl.tailormap.viewer.config.services.FeatureSource;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.config.services.SimpleFeatureType;
import nl.tailormap.viewer.config.services.UpdateResult;
import nl.tailormap.viewer.helpers.featuresources.FeatureSourceFactoryHelper;
import nl.tailormap.viewer.helpers.services.GeoServiceHelper;
import nl.tailormap.viewer.helpers.services.LayerHelper;
import nl.tailormap.web.WaitPageStatus;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.http.HTTPClient;
import org.geotools.http.SimpleHttpClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

public class ArcGISServiceHelper
implements GeoServiceHelper {
    private static final Log log = LogFactory.getLog(ArcGISServiceHelper.class);
    public static Set<String> additionalUpdatableDetails = new HashSet<String>(Arrays.asList("arcgis_type", "arcgis_description", "arcgis_geometryType", "arcgis_capabilities", "arcgis_defaultVisibility", "arcgis_definitionExpression", "arcgis_currentVersion"));

    @Override
    public GeoService loadServiceFromURL(String url, Map params, WaitPageStatus status, EntityManager em) throws Exception {
        return ArcGISServiceHelper.loadFromUrl(url, params, status, em);
    }

    @Override
    public UpdateResult updateService(EntityManager em, GeoService service) {
        return ArcGISServiceHelper.update(em, (ArcGISService)service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArcGISService loadFromUrl(String url, Map params, WaitPageStatus status, EntityManager em) throws Exception {
        try {
            status.setCurrentAction("Ophalen informatie...");
            if (!url.endsWith("/MapServer")) {
                throw new IllegalArgumentException("URL moet eindigen in \"/MapServer\"");
            }
            if (url.indexOf("/rest/services") == -1) {
                throw new IllegalArgumentException("URL moet \"/rest/\" bevatten");
            }
            SimpleHttpClient client = new SimpleHttpClient();
            client.setUser((String)params.get("username"));
            client.setPassword((String)params.get("password"));
            ArcGISService s = new ArcGISService();
            s.setUrl(url);
            ArcGISServiceHelper.loadServiceInfo((HTTPClient)client, (String)params.get("assumeVersion"), s);
            if (Boolean.TRUE.equals(params.get("onlineCheckOnly"))) {
                ArcGISService arcGISService = null;
                return arcGISService;
            }
            int i = url.lastIndexOf("/MapServer");
            String temp = url.substring(0, i);
            i = temp.lastIndexOf("/");
            String name = temp.substring(i + 1);
            s.setName(name);
            ArcGISServiceHelper.load((HTTPClient)client, status, em, s);
            ArcGISService arcGISService = s;
            return arcGISService;
        }
        finally {
            status.setProgress(90);
            status.setCurrentAction("Service ingeladen");
        }
    }

    private static void loadServiceInfo(HTTPClient client, String assumeVersion, ArcGISService s) throws Exception {
        if ("9.x".equals(assumeVersion)) {
            s.currentVersion = "9.x";
            s.currentVersionMajor = 9;
            s.getDetails().put("arcgis_assumeVersion", new ClobElement("9.x"));
        } else if ("10.x".equals(assumeVersion)) {
            s.currentVersion = "10.x";
            s.currentVersionMajor = 10;
            s.getDetails().put("arcgis_assumeVersion", new ClobElement("10.x"));
        } else {
            int i = s.getUrl().indexOf("/rest/services");
            String servicesUrl = s.getUrl().substring(0, i) + "/rest/services";
            s.serviceInfo = ArcGISServiceHelper.issueRequest(servicesUrl + "?f=json", client);
            s.currentVersion = s.serviceInfo.get("currentVersion").toString();
            s.currentVersionMajor = Integer.parseInt(s.currentVersion.split("\\.")[0]);
        }
        s.serviceInfo = s.currentVersionMajor >= 10 ? ArcGISServiceHelper.issueRequest(s.getUrl() + "/layers?f=json", client) : ArcGISServiceHelper.issueRequest(s.getUrl() + "?f=json", client);
        s.getDetails().put("arcgis_currentVersion", new ClobElement(s.currentVersion));
    }

    private static void load(HTTPClient client, WaitPageStatus status, EntityManager em, ArcGISService s) throws Exception {
        int layerCount = s.serviceInfo.getJSONArray("layers").length();
        status.setProgress((int)Math.round(100.0 / (double)(layerCount + 1)));
        status.setCurrentAction("Inladen layers...");
        ArcGISFeatureSource fs = new ArcGISFeatureSource();
        fs.setLinkedService((GeoService)s);
        fs.setUrl(s.getUrl());
        fs.setUsername(client.getUser());
        fs.setPassword(client.getPassword());
        Layer top = new Layer();
        top.setVirtual(true);
        top.setName("-1");
        top.setTitle(s.getName());
        top.setService((GeoService)s);
        s.setTopLayer(top);
        s.layersById = new TreeMap();
        s.childrenByLayerId = new HashMap();
        s.layersById.put(top.getName(), top);
        if (s.currentVersionMajor >= 10) {
            JSONArray layers = s.serviceInfo.getJSONArray("layers");
            for (int i = 0; i < layers.length(); ++i) {
                JSONObject layer = layers.getJSONObject(i);
                Layer l = ArcGISServiceHelper.parseArcGISLayer(layer, s, fs, s.childrenByLayerId);
                s.layersById.put(l.getName(), l);
            }
        } else {
            JSONArray layers = s.serviceInfo.getJSONArray("layers");
            for (int i = 0; i < layers.length(); ++i) {
                JSONObject layer = layers.getJSONObject(i);
                String id = layer.getString("id");
                status.setCurrentAction("Inladen laag \"" + layer.optString("name", id) + "\"");
                layer = ArcGISServiceHelper.issueRequest(s.getUrl() + "/" + id + "?f=json", client);
                Layer l = ArcGISServiceHelper.parseArcGISLayer(layer, s, fs, s.childrenByLayerId);
                s.layersById.put(l.getName(), l);
                status.setProgress((int)Math.round(100.0 / (double)(layerCount + 1) * (double)i + 2.0));
            }
        }
        ArcGISServiceHelper.setLayerTree(s.getTopLayer(), s.layersById, s.childrenByLayerId, em);
        LayerHelper.setAllChildrenDetail(s.getTopLayer(), em);
        if (!fs.getFeatureTypes().isEmpty()) {
            fs.setName(s.getName());
        }
    }

    private static void setLayerTree(Layer topLayer, Map<String, Layer> layersById, Map<String, List<String>> childrenByLayerId, EntityManager em) {
        topLayer.getChildren().clear();
        em.flush();
        for (Layer l : layersById.values()) {
            List<String> childrenIds = childrenByLayerId.get(l.getName());
            if (childrenIds == null) continue;
            for (String childId : childrenIds) {
                Layer child = layersById.get(childId);
                if (child == null) continue;
                l.getChildren().add(child);
                child.setParent(l);
            }
        }
        for (Layer l : layersById.values()) {
            if (l.getParent() != null || "-1".equals(l.getName())) continue;
            topLayer.getChildren().add(l);
            l.setParent(topLayer);
        }
        Collections.sort(topLayer.getChildren(), new Comparator<Layer>(){

            @Override
            public int compare(Layer lhs, Layer rhs) {
                return lhs.getName().compareTo(rhs.getName());
            }
        });
    }

    private static Layer parseArcGISLayer(JSONObject agsl, ArcGISService service, ArcGISFeatureSource fs, Map<String, List<String>> childrenByLayerId) throws JSONException {
        JSONArray fields;
        Layer l = new Layer();
        l.setService((GeoService)service);
        l.setName(agsl.get("id").toString());
        l.setTitle(agsl.getString("name"));
        JSONArray subLayerIds = agsl.optJSONArray("subLayers");
        if (subLayerIds != null) {
            ArrayList<CallSite> childrenIds = new ArrayList<CallSite>();
            for (int i = 0; i < subLayerIds.length(); ++i) {
                JSONObject subLayer = subLayerIds.getJSONObject(i);
                String subLayerId = "" + subLayer.getInt("id");
                childrenIds.add((CallSite)((Object)subLayerId));
            }
            childrenByLayerId.put(l.getName(), childrenIds);
        }
        l.getDetails().put("arcgis_type", new ClobElement(agsl.getString("type")));
        l.getDetails().put("arcgis_currentVersion", new ClobElement(agsl.optString("currentVersion", service.currentVersion)));
        l.getDetails().put("arcgis_description", new ClobElement((String)StringUtils.defaultIfBlank((CharSequence)agsl.getString("description"), null)));
        l.getDetails().put("arcgis_geometryType", new ClobElement((String)StringUtils.defaultIfBlank((CharSequence)agsl.optString("geometryType"), null)));
        l.getDetails().put("arcgis_capabilities", new ClobElement(agsl.optString("capabilities")));
        l.getDetails().put("arcgis_defaultVisibility", new ClobElement(agsl.optBoolean("defaultVisibility", false) ? "true" : "false"));
        l.getDetails().put("arcgis_definitionExpression", new ClobElement((String)StringUtils.defaultIfBlank((CharSequence)agsl.optString("definitionExpression"), null)));
        RemoveEmptyMapValuesUtil.removeEmptyMapValues((Map)l.getDetails());
        try {
            l.setMinScale(Double.valueOf(agsl.getDouble("minScale")));
            l.setMaxScale(Double.valueOf(agsl.getDouble("maxScale")));
        }
        catch (JSONException childrenIds) {
            // empty catch block
        }
        try {
            JSONObject extent = agsl.getJSONObject("extent");
            BoundingBox bbox = new BoundingBox();
            bbox.setMinx(Double.valueOf(extent.getDouble("xmin")));
            bbox.setMaxx(Double.valueOf(extent.getDouble("xmax")));
            bbox.setMiny(Double.valueOf(extent.getDouble("ymin")));
            bbox.setMaxy(Double.valueOf(extent.getDouble("ymax")));
            bbox.setCrs(new CoordinateReferenceSystem("EPSG:" + extent.getJSONObject("spatialReference").getInt("wkid")));
            l.getBoundingBoxes().put(bbox.getCrs(), bbox);
        }
        catch (JSONException extent) {
            // empty catch block
        }
        boolean hasFields = false;
        if (!agsl.isNull("fields") && (fields = agsl.getJSONArray("fields")).length() > 0) {
            SimpleFeatureType sft = new SimpleFeatureType();
            sft.setFeatureSource((FeatureSource)fs);
            sft.setTypeName(l.getName());
            sft.setDescription(l.getTitle());
            sft.setWriteable(false);
            for (int i = 0; i < fields.length(); ++i) {
                JSONObject field = fields.getJSONObject(i);
                AttributeDescriptor att = new AttributeDescriptor();
                sft.getAttributes().add(att);
                att.setName(field.getString("name"));
                att.setAlias(field.getString("alias"));
                String et = field.getString("type");
                String type = "string";
                if ("esriFieldTypeOID".equals(et)) {
                    type = "integer";
                } else if ("esriFieldTypeGeometry".equals(et)) {
                    String gtype;
                    if (sft.getGeometryAttribute() == null) {
                        sft.setGeometryAttribute(att.getName());
                    }
                    type = "esriGeometryPoint".equals(gtype = agsl.getString("geometryType")) ? "point" : ("esriGeometryMultipoint".equals(gtype) ? "multipoint" : ("esriGeometryLine".equals(gtype) || "esriGeometryPolyline".equals(gtype) ? "linestring" : ("esriGeometryPolygon".equals(gtype) ? "polygon" : "geometry")));
                } else if ("esriFieldTypeDouble".equals(et)) {
                    type = "double";
                } else if ("esriFieldTypeInteger".equals(et) || "esriFieldTypeSmallInteger".equals(et)) {
                    type = "integer";
                } else if ("esriFieldTypeDate".equals(et)) {
                    type = "date";
                }
                att.setType(type);
            }
            fs.getFeatureTypes().add(sft);
            l.setFeatureType(sft);
            hasFields = true;
        }
        l.setQueryable(hasFields);
        l.setFilterable(hasFields);
        l.setVirtual(!ArcGISService.NON_VIRTUAL_LAYER_TYPES.contains(((ClobElement)l.getDetails().get("arcgis_type")).getValue()));
        return l;
    }

    public static UpdateResult update(EntityManager em, ArcGISService s) {
        LayerHelper.initLayerCollectionsForUpdate((GeoService)s);
        UpdateResult result = new UpdateResult((GeoService)s, em);
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("username", s.getUsername());
            params.put("password", s.getPassword());
            ArcGISService update = ArcGISServiceHelper.loadFromUrl(s.getUrl(), params, result.getWaitPageStatus().subtask("", 80.0f), em);
            s.getDetails().put("arcgis_currentVersion", (ClobElement)update.getDetails().get("arcgis_currentVersion"));
            s.getTopLayer().getDetails().remove("arcgis_currentVersion");
            s.getTopLayer().setName("-1");
            result.getLayerStatus().put(s.getTopLayer().getName(), (MutablePair<Layer, UpdateResult.Status>)new MutablePair((Object)s.getTopLayer(), (Object)UpdateResult.Status.UNMODIFIED));
            ArcGISFeatureSource linkedFS = null;
            try {
                linkedFS = (ArcGISFeatureSource)Stripersist.getEntityManager().createQuery("from FeatureSource where linkedService = :this").setParameter("this", (Object)s).getSingleResult();
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
            ArcGISServiceHelper.updateLayers(update, linkedFS, result, em, s);
            ArcGISServiceHelper.removeOrphanLayersAfterUpdate(result, s);
            if (linkedFS != null && linkedFS.getFeatureTypes().isEmpty()) {
                log.debug((Object)"Linked ArcGISFeatureSource has no type names anymore, removing it");
                Stripersist.getEntityManager().remove((Object)linkedFS);
            }
            result.setStatus(UpdateResult.Status.UPDATED);
        }
        catch (Exception e) {
            result.failedWithException(e);
        }
        return result;
    }

    private static void updateLayers(ArcGISService update, ArcGISFeatureSource linkedFS, UpdateResult result, EntityManager em, ArcGISService service) {
        HashMap<String, Layer> updatedLayersById = new HashMap<String, Layer>();
        for (Layer updateLayer : update.layersById.values()) {
            SimpleFeatureType ft;
            MutablePair layerStatus = (MutablePair)result.getLayerStatus().get(updateLayer.getName());
            Layer updatedLayer = null;
            if (layerStatus == null) {
                ft = updateLayer.getFeatureType();
                if (updateLayer.getFeatureType() != null) {
                    if (linkedFS != null) {
                        updateLayer.setFeatureType(linkedFS.addOrUpdateFeatureType(updateLayer.getName(), ft, new MutableBoolean()));
                    } else {
                        ft.getFeatureSource().setLinkedService((GeoService)service);
                    }
                }
                result.getLayerStatus().put(updateLayer.getName(), (MutablePair<Layer, UpdateResult.Status>)new MutablePair((Object)updateLayer, (Object)UpdateResult.Status.NEW));
                updatedLayer = updateLayer;
            } else {
                assert (layerStatus.getRight() == UpdateResult.Status.MISSING);
                Layer old = (Layer)layerStatus.getLeft();
                old.setParent(null);
                old.update(updateLayer, additionalUpdatableDetails);
                layerStatus.setRight((Object)UpdateResult.Status.UNMODIFIED);
                if (old.getFeatureType() == null || old.getFeatureType().getFeatureSource().getLinkedService() == service) {
                    if (updateLayer.getFeatureType() == null) {
                        if (old.getFeatureType() != null) {
                            layerStatus.setRight((Object)UpdateResult.Status.UPDATED);
                        }
                        old.setFeatureType(null);
                    } else {
                        if (linkedFS != null) {
                            MutableBoolean updated = new MutableBoolean(false);
                            ft = linkedFS.addOrUpdateFeatureType(updateLayer.getName(), updateLayer.getFeatureType(), updated);
                            if (old.getFeatureType() == null || updated.isTrue()) {
                                layerStatus.setRight((Object)UpdateResult.Status.UPDATED);
                            }
                        } else {
                            ft = updateLayer.getFeatureType();
                            ft.getFeatureSource().setLinkedService((GeoService)service);
                            layerStatus.setRight((Object)UpdateResult.Status.UPDATED);
                        }
                        old.setFeatureType(ft);
                    }
                }
                updatedLayer = old;
            }
            updatedLayer.getChildren().clear();
            updatedLayer.setParent(null);
            updatedLayer.setService((GeoService)service);
            updatedLayersById.put(updateLayer.getName(), updatedLayer);
        }
        ArcGISServiceHelper.setLayerTree(service.getTopLayer(), updatedLayersById, update.childrenByLayerId, em);
    }

    private static void removeOrphanLayersAfterUpdate(UpdateResult result, ArcGISService service) {
        assert (result.getDuplicateOrNoNameLayers().size() == 1);
        assert (result.getDuplicateOrNoNameLayers().get(0) == service.getTopLayer());
        HashSet<Layer> layerFeatureTypesToRemove = new HashSet<Layer>();
        for (Pair pair : result.getLayerStatus().values()) {
            if (pair.getRight() != UpdateResult.Status.MISSING) continue;
            Layer removed = (Layer)pair.getLeft();
            if (removed.getFeatureType() != null && removed.getFeatureType().getFeatureSource().getLinkedService().equals(removed.getService())) {
                layerFeatureTypesToRemove.add(removed);
            }
            Stripersist.getEntityManager().remove((Object)removed);
        }
        for (Layer layer : layerFeatureTypesToRemove) {
            SimpleFeatureType ft = layer.getFeatureType();
            Stripersist.getEntityManager().createQuery("update ConfiguredAttribute set featureType = null where featureType = :ft").setParameter("ft", (Object)ft).executeUpdate();
            Stripersist.getEntityManager().createQuery("update Layer set featureType = null where featureType = :ft").setParameter("ft", (Object)ft).executeUpdate();
            Stripersist.getEntityManager().createQuery("update SolrConf set simpleFeatureType = null where simpleFeatureType = :ft").setParameter("ft", (Object)ft).executeUpdate();
            Stripersist.getEntityManager().createQuery("update FeatureTypeRelation set foreignFeatureType = null where foreignFeatureType = :ft").setParameter("ft", (Object)ft).executeUpdate();
            FeatureSourceFactoryHelper.removeFeatureType(layer.getFeatureType().getFeatureSource(), layer.getFeatureType());
        }
    }

    private static JSONObject issueRequest(String url, HTTPClient client) throws Exception {
        return new JSONObject(IOUtils.toString((InputStream)client.get(new URL(url)).getResponseStream(), (String)"UTF-8"));
    }

    public static JSONObject toJSONObject(ArcGISService geoService, boolean flatten, Set<String> layersToInclude, boolean validXmlTags, boolean includeAuthorizations, EntityManager em) throws JSONException {
        JSONObject o = GeoServiceHelper.toJSONObject((GeoService)geoService, flatten, layersToInclude, validXmlTags, includeAuthorizations, em);
        JSONObject json = new JSONObject();
        o.put("arcGISVersion", (Object)json);
        json.put("s", (Object)"9.x");
        json.put("major", 9L);
        json.put("number", 9.0);
        String cv = geoService.getCurrentVersion();
        if (cv != null) {
            json.put("s", (Object)cv);
            try {
                String[] parts = cv.split("\\.");
                json.put("major", Integer.parseInt(parts[0]));
                json.put("number", Double.parseDouble(cv));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return o;
    }
}

