/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.config.app;

import java.util.List;
import javax.persistence.EntityManager;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.app.Level;
import nl.tailormap.viewer.config.app.StartLayer;
import nl.tailormap.viewer.config.app.StartLevel;
import nl.tailormap.viewer.helpers.app.ApplicationHelper;
import nl.tailormap.viewer.util.TestUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ApplicationTest
extends TestUtil {
    private static final Log log = LogFactory.getLog(ApplicationTest.class);

    @Test
    public void testDeepCopy() throws Exception {
        this.initData(true);
        int expectedStartLayerSize = this.app.getStartLayers().size();
        int expectedStartLevelSize = this.app.getStartLevels().size();
        Application copy = ApplicationHelper.deepCopy((Application)this.app);
        copy.setVersion("666");
        this.entityManager.detach((Object)this.app);
        this.entityManager.persist((Object)copy);
        this.entityManager.getTransaction().commit();
        this.entityManager.getTransaction().begin();
        Application toTest = (Application)this.entityManager.find(Application.class, (Object)copy.getId());
        Assertions.assertFalse((boolean)this.app.getId().equals(toTest.getId()));
        Assertions.assertEquals((int)expectedStartLayerSize, (int)toTest.getStartLayers().size());
        Assertions.assertEquals((int)expectedStartLevelSize, (int)toTest.getStartLevels().size());
        for (StartLayer startLayer : toTest.getStartLayers()) {
            Assertions.assertEquals((Long)toTest.getId(), (Long)startLayer.getApplication().getId());
        }
        for (StartLevel startLevel : toTest.getStartLevels()) {
            Assertions.assertEquals((Long)toTest.getId(), (Long)startLevel.getApplication().getId());
        }
        this.app = (Application)this.entityManager.merge((Object)this.app);
    }

    @Test
    public void testDeepCopyReaders() throws Exception {
        this.initData(true);
        Application copy = ApplicationHelper.deepCopy((Application)this.app);
        Assertions.assertEquals((int)2, (int)copy.getReaders().size());
        for (String reader : this.app.getReaders()) {
            Assertions.assertTrue((boolean)copy.getReaders().contains(reader));
        }
    }

    @Test
    public void testDeleteApplications() throws Exception {
        this.initData(true);
        Application application = (Application)this.entityManager.find(Application.class, (Object)this.app.getId());
        Application copy = ApplicationHelper.deepCopy((Application)application);
        this.entityManager.detach((Object)application);
        copy.setVersion("123");
        this.entityManager.persist((Object)copy);
        application = (Application)this.entityManager.merge((Object)application);
    }

    @Test
    public void testMakeMashupLinkComponents() throws Exception {
        block6: {
            this.initData(true);
            try {
                int expectedStartLayerSize = this.app.getStartLayers().size();
                int expectedStartLevelSize = this.app.getStartLevels().size();
                int expectedRootStartLevelSize = this.app.getRoot().getStartLevels().size() * 2;
                Application mashup = ApplicationHelper.createMashup((Application)this.app, (String)"mashup", (EntityManager)this.entityManager, (boolean)true);
                this.entityManager.persist((Object)mashup);
                this.entityManager.getTransaction().commit();
                this.entityManager.getTransaction().begin();
                Assertions.assertFalse((boolean)this.app.getId().equals(mashup.getId()));
                Assertions.assertEquals((int)expectedStartLayerSize, (int)mashup.getStartLayers().size());
                Assertions.assertEquals((int)expectedStartLevelSize, (int)mashup.getStartLevels().size());
                for (StartLayer startLayer : mashup.getStartLayers()) {
                    Assertions.assertEquals((Long)mashup.getId(), (Long)startLayer.getApplication().getId());
                }
                for (StartLevel startLevel : mashup.getStartLevels()) {
                    Assertions.assertEquals((Long)mashup.getId(), (Long)startLevel.getApplication().getId());
                }
                Assertions.assertEquals((int)expectedRootStartLevelSize, (int)this.app.getRoot().getStartLevels().size());
                Assertions.assertEquals((Object)this.app.getRoot(), (Object)mashup.getRoot());
                Application.TreeCache tc = mashup.loadTreeCache(this.entityManager);
                List levels = tc.getLevels();
                List appLayers = tc.getApplicationLayers();
                for (ApplicationLayer appLayer : appLayers) {
                    Assertions.assertTrue((boolean)appLayer.getStartLayers().containsKey(mashup));
                }
                for (Level level : levels) {
                    if (level.getParent() == null) continue;
                    Assertions.assertTrue((boolean)level.getStartLevels().containsKey(mashup));
                }
            }
            catch (Exception e) {
                log.error((Object)"Fout", (Throwable)e);
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testMakeMashupDontDuplicateStartLayers() {
        block6: {
            this.initData(true);
            try {
                int expectedStartLayerSize = this.app.getStartLayers().size();
                Application mashup = ApplicationHelper.createMashup((Application)this.app, (String)"mashup", (EntityManager)this.entityManager, (boolean)false);
                this.entityManager.persist((Object)mashup);
                Application secondMashup = ApplicationHelper.createMashup((Application)this.app, (String)"mashup2", (EntityManager)this.entityManager, (boolean)false);
                this.entityManager.persist((Object)secondMashup);
                this.entityManager.getTransaction().commit();
                this.entityManager.getTransaction().begin();
                Assertions.assertFalse((boolean)this.app.getId().equals(mashup.getId()));
                Assertions.assertEquals((int)expectedStartLayerSize, (int)mashup.getStartLayers().size());
                for (StartLayer startLayer : mashup.getStartLayers()) {
                    Assertions.assertEquals((Long)mashup.getId(), (Long)startLayer.getApplication().getId());
                }
                Application.TreeCache tc = mashup.loadTreeCache(this.entityManager);
                List appLayers = tc.getApplicationLayers();
                for (ApplicationLayer appLayer : appLayers) {
                    Assertions.assertTrue((boolean)appLayer.getStartLayers().containsKey(mashup));
                }
                Assertions.assertFalse((boolean)this.app.getId().equals(secondMashup.getId()));
                Assertions.assertEquals((int)expectedStartLayerSize, (int)secondMashup.getStartLayers().size());
                for (StartLayer startLayer : secondMashup.getStartLayers()) {
                    Assertions.assertEquals((Long)secondMashup.getId(), (Long)startLayer.getApplication().getId());
                }
                Application.TreeCache tc2 = secondMashup.loadTreeCache(this.entityManager);
                List appLayers2 = tc2.getApplicationLayers();
                for (ApplicationLayer appLayer : appLayers2) {
                    Assertions.assertTrue((boolean)appLayer.getStartLayers().containsKey(secondMashup));
                }
            }
            catch (Exception e) {
                log.error((Object)"Fout", (Throwable)e);
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testMakeMashupDontDuplicateStartLevels() {
        block4: {
            this.initData(true);
            try {
                int expectedStartLevelSize = this.app.getStartLevels().size();
                int expectedRootStartLevelSize = this.app.getRoot().getStartLevels().size() * 2;
                Application mashup = ApplicationHelper.createMashup((Application)this.app, (String)"mashup", (EntityManager)this.entityManager, (boolean)false);
                this.entityManager.persist((Object)mashup);
                Application secondMashup = ApplicationHelper.createMashup((Application)this.app, (String)"mashup2", (EntityManager)this.entityManager, (boolean)false);
                this.entityManager.persist((Object)secondMashup);
                this.entityManager.getTransaction().commit();
                this.entityManager.getTransaction().begin();
                Assertions.assertFalse((boolean)this.app.getId().equals(mashup.getId()));
                Assertions.assertEquals((int)expectedStartLevelSize, (int)mashup.getStartLevels().size());
                Assertions.assertEquals((int)expectedRootStartLevelSize, (int)this.app.getRoot().getStartLevels().size());
                Assertions.assertEquals((Object)this.app.getRoot(), (Object)mashup.getRoot());
                for (StartLevel startLevel : mashup.getStartLevels()) {
                    Assertions.assertEquals((Long)mashup.getId(), (Long)startLevel.getApplication().getId());
                }
                Assertions.assertFalse((boolean)this.app.getId().equals(secondMashup.getId()));
                Assertions.assertEquals((int)expectedStartLevelSize, (int)secondMashup.getStartLevels().size());
                Assertions.assertEquals((int)expectedRootStartLevelSize, (int)this.app.getRoot().getStartLevels().size());
                Assertions.assertEquals((Object)this.app.getRoot(), (Object)secondMashup.getRoot());
                for (StartLevel startLevel : secondMashup.getStartLevels()) {
                    Assertions.assertEquals((Long)secondMashup.getId(), (Long)startLevel.getApplication().getId());
                }
                Application.TreeCache treeCache = secondMashup.loadTreeCache(this.entityManager);
            }
            catch (Exception e) {
                log.error((Object)"Fout", (Throwable)e);
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testMakeMashupDontLinkComponents() throws Exception {
        block6: {
            this.initData(true);
            try {
                int expectedStartLayerSize = this.app.getStartLayers().size();
                int expectedStartLevelSize = this.app.getStartLevels().size();
                int expectedRootStartLevelSize = this.app.getRoot().getStartLevels().size() * 2;
                Application mashup = ApplicationHelper.createMashup((Application)this.app, (String)"mashup", (EntityManager)this.entityManager, (boolean)false);
                this.entityManager.persist((Object)mashup);
                this.entityManager.getTransaction().commit();
                this.entityManager.getTransaction().begin();
                Assertions.assertFalse((boolean)this.app.getId().equals(mashup.getId()));
                Assertions.assertEquals((int)expectedStartLayerSize, (int)mashup.getStartLayers().size());
                Assertions.assertEquals((int)expectedStartLevelSize, (int)mashup.getStartLevels().size());
                for (StartLayer startLayer : mashup.getStartLayers()) {
                    Assertions.assertEquals((Long)mashup.getId(), (Long)startLayer.getApplication().getId());
                }
                for (StartLevel startLevel : mashup.getStartLevels()) {
                    Assertions.assertEquals((Long)mashup.getId(), (Long)startLevel.getApplication().getId());
                }
                Assertions.assertEquals((int)expectedRootStartLevelSize, (int)this.app.getRoot().getStartLevels().size());
                Assertions.assertEquals((Object)this.app.getRoot(), (Object)mashup.getRoot());
                Application.TreeCache tc = mashup.loadTreeCache(this.entityManager);
                List levels = tc.getLevels();
                List appLayers = tc.getApplicationLayers();
                for (ApplicationLayer appLayer : appLayers) {
                    Assertions.assertTrue((boolean)appLayer.getStartLayers().containsKey(mashup));
                }
                for (Level level : levels) {
                    if (level.getParent() == null) continue;
                    Assertions.assertTrue((boolean)level.getStartLevels().containsKey(mashup));
                }
            }
            catch (Exception e) {
                log.error((Object)"Fout", (Throwable)e);
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testMakeMashupOfApplicationWithExistingMashup() throws Exception {
        block6: {
            this.initData(true);
            try {
                int expectedStartLayerSize = this.app.getStartLayers().size();
                int expectedStartLevelSize = this.app.getStartLevels().size();
                int expectedRootStartLevelSize = this.app.getRoot().getStartLevels().size() * 3;
                Application mashup1 = ApplicationHelper.createMashup((Application)this.app, (String)"mashup", (EntityManager)this.entityManager, (boolean)false);
                this.entityManager.persist((Object)mashup1);
                this.entityManager.getTransaction().commit();
                this.entityManager.getTransaction().begin();
                Application mashup = ApplicationHelper.createMashup((Application)this.app, (String)"mashup2", (EntityManager)this.entityManager, (boolean)false);
                this.entityManager.persist((Object)mashup);
                this.entityManager.getTransaction().commit();
                this.entityManager.getTransaction().begin();
                Assertions.assertFalse((boolean)this.app.getId().equals(mashup.getId()));
                Assertions.assertEquals((int)expectedStartLayerSize, (int)mashup.getStartLayers().size());
                Assertions.assertEquals((int)expectedStartLevelSize, (int)mashup.getStartLevels().size());
                for (StartLayer startLayer : mashup.getStartLayers()) {
                    Assertions.assertEquals((Long)mashup.getId(), (Long)startLayer.getApplication().getId());
                }
                for (StartLevel startLevel : mashup.getStartLevels()) {
                    Assertions.assertEquals((Long)mashup.getId(), (Long)startLevel.getApplication().getId());
                }
                Assertions.assertEquals((int)expectedRootStartLevelSize, (int)this.app.getRoot().getStartLevels().size());
                Assertions.assertEquals((Object)this.app.getRoot(), (Object)mashup.getRoot());
                Application.TreeCache tc = mashup.loadTreeCache(this.entityManager);
                List levels = tc.getLevels();
                List appLayers = tc.getApplicationLayers();
                for (ApplicationLayer appLayer : appLayers) {
                    Assertions.assertTrue((boolean)appLayer.getStartLayers().containsKey(mashup));
                }
                for (Level level : levels) {
                    if (level.getParent() == null) continue;
                    Assertions.assertTrue((boolean)level.getStartLevels().containsKey(mashup));
                }
            }
            catch (Exception e) {
                log.error((Object)"Fout", (Throwable)e);
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }
}

