/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.config.app;

import javax.persistence.EntityManager;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ConfiguredComponent;
import nl.tailormap.viewer.helpers.app.ApplicationHelper;
import nl.tailormap.viewer.util.TestUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfiguredComponentTest
extends TestUtil {
    private static final Log log = LogFactory.getLog(ConfiguredComponentTest.class);

    @Test
    public void deleteSingleConfiguredComponent() {
        block2: {
            try {
                this.initData(true);
                long cId = this.testComponent.getId();
                this.app.getComponents().remove(this.testComponent);
                this.entityManager.remove((Object)this.testComponent);
                this.entityManager.getTransaction().commit();
                this.entityManager.getTransaction().begin();
                ConfiguredComponent cc = (ConfiguredComponent)this.entityManager.find(ConfiguredComponent.class, (Object)cId);
                Assertions.assertEquals(null, (Object)cc);
            }
            catch (Exception e) {
                log.error((Object)"Error:", (Throwable)e);
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void deleteLinkedConfiguredComponent() {
        block2: {
            this.initData(true);
            try {
                Application mashup = ApplicationHelper.createMashup((Application)this.app, (String)"mashup", (EntityManager)this.entityManager, (boolean)true);
                this.entityManager.persist((Object)mashup);
                this.entityManager.getTransaction().commit();
                this.entityManager.getTransaction().begin();
                ConfiguredComponent cc = (ConfiguredComponent)mashup.getComponents().toArray()[0];
                long cId = this.testComponent.getId();
                mashup.getComponents().remove(cc);
                this.entityManager.remove((Object)cc);
                this.entityManager.getTransaction().commit();
                this.entityManager.getTransaction().begin();
                Assertions.assertEquals((int)1, (int)this.app.getComponents().size());
                Assertions.assertNotNull((Object)this.entityManager.find(ConfiguredComponent.class, (Object)cId));
            }
            catch (Exception e) {
                log.error((Object)"Error:", (Throwable)e);
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void deleteMotherConfiguredComponent() {
        block3: {
            this.initData(true);
            try {
                Application mashup = ApplicationHelper.createMashup((Application)this.app, (String)"mashup", (EntityManager)this.entityManager, (boolean)true);
                this.entityManager.persist((Object)mashup);
                this.entityManager.getTransaction().commit();
                this.entityManager.getTransaction().begin();
                ConfiguredComponent cc = (ConfiguredComponent)mashup.getComponents().toArray()[0];
                long cId = cc.getId();
                this.app.getComponents().remove(this.testComponent);
                for (ConfiguredComponent linkedComponent : this.testComponent.getLinkedComponents()) {
                    linkedComponent.setMotherComponent(null);
                }
                this.entityManager.remove((Object)this.testComponent);
                this.entityManager.getTransaction().commit();
                this.entityManager.getTransaction().begin();
                Assertions.assertEquals((int)1, (int)mashup.getComponents().size());
                Assertions.assertNotNull((Object)this.entityManager.find(ConfiguredComponent.class, (Object)cId));
            }
            catch (Exception e) {
                log.error((Object)"Error:", (Throwable)e);
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }
}

