/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.util.databaseupdate;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import nl.tailormap.viewer.config.metadata.Metadata;
import nl.tailormap.viewer.config.services.SolrConf;
import nl.tailormap.viewer.util.TestUtil;
import nl.tailormap.viewer.util.databaseupdate.DatabaseSynchronizer;
import nl.tailormap.viewer.util.databaseupdate.DatabaseSynchronizerEM;
import nl.tailormap.viewer.util.databaseupdate.DatabaseSynchronizerTestInterface;
import nl.tailormap.viewer.util.databaseupdate.UpdateElement;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DatabaseSynchronizerTest
extends DatabaseSynchronizerTestInterface {
    @Test
    public void testSQLScriptUpdate() {
        DatabaseSynchronizer ds = new DatabaseSynchronizer();
        LinkedHashMap updates = DatabaseSynchronizer.updates;
        Assertions.assertFalse((boolean)updates.isEmpty());
        Metadata metadata = (Metadata)this.entityManager.createQuery("From Metadata where configKey = :v", Metadata.class).setParameter("v", (Object)"database_version").getSingleResult();
        String oldVersion = metadata.getConfigValue();
        updates.put("" + TestUtil.TEST_VERSION_NUMBER, new UpdateElement(Collections.singletonList("emptySql.sql"), String.class));
        ds.doInit(this.entityManager);
        Metadata newMetadata = (Metadata)this.entityManager.createQuery("From Metadata where configKey = :v", Metadata.class).setParameter("v", (Object)"database_version").getSingleResult();
        Assertions.assertNotEquals((Object)oldVersion, (Object)newMetadata.getConfigValue());
        Assertions.assertEquals((int)TestUtil.TEST_VERSION_NUMBER, (int)Integer.parseInt(newMetadata.getConfigValue()));
    }

    @Test
    public void testCodeUpdateWrongMethodname() throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Metadata metadata = (Metadata)this.entityManager.createQuery("From Metadata where configKey = :v", Metadata.class).setParameter("v", (Object)"database_version").getSingleResult();
        String oldVersion = metadata.getConfigValue();
        DatabaseSynchronizer ds = new DatabaseSynchronizer();
        LinkedHashMap updates = DatabaseSynchronizer.updates;
        updates.put("" + TestUtil.TEST_VERSION_NUMBER, new UpdateElement(Collections.singletonList("nonExistentMethod"), DatabaseSynchronizerEM.class));
        ds.doInit(this.entityManager);
        Metadata newMetadata = (Metadata)this.entityManager.createQuery("From Metadata where configKey = :v", Metadata.class).setParameter("v", (Object)"database_version").getSingleResult();
        Assertions.assertEquals((Object)oldVersion, (Object)newMetadata.getConfigValue());
    }

    @Test
    public void testConvertSolrConfigReferenceToValues() {
        DatabaseSynchronizer ds = new DatabaseSynchronizer();
        LinkedHashMap updates = DatabaseSynchronizer.updates;
        updates.put("" + TestUtil.TEST_VERSION_NUMBER, new UpdateElement(Collections.singletonList("hqsqldb-solrconf_reference_to_value.sql"), String.class));
        ds.doInit(this.entityManager);
        SolrConf conf = (SolrConf)this.entityManager.find(SolrConf.class, (Object)1L);
        List indexAttrs = conf.getIndexAttributes();
        Assertions.assertEquals((Object)"ident", indexAttrs.get(0));
        Assertions.assertEquals((Object)"status", indexAttrs.get(1));
        List resultAttrs = conf.getResultAttributes();
        Assertions.assertEquals((Object)"ident", resultAttrs.get(0));
        Assertions.assertEquals((Object)"status", resultAttrs.get(1));
    }
}

