/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.features;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.tailormap.viewer.config.app.ConfiguredAttribute;
import nl.tailormap.viewer.config.services.AttributeDescriptor;
import org.geotools.data.simple.SimpleFeatureSource;
import org.opengis.feature.simple.SimpleFeature;

public abstract class FeatureDownloader {
    protected List<ConfiguredAttribute> attributes;
    protected SimpleFeatureSource fs;
    protected Map<String, AttributeDescriptor> featureTypeAttributes;
    protected Map<String, String> attributeAliases;
    protected String params;
    protected Map<String, String> parameterMap = new HashMap<String, String>();

    public FeatureDownloader(List<ConfiguredAttribute> attributes, SimpleFeatureSource fs, Map<String, AttributeDescriptor> featureTypeAttributes, Map<String, String> attributeAliases, String params) {
        this.attributes = attributes;
        this.fs = fs;
        this.featureTypeAttributes = featureTypeAttributes;
        this.attributeAliases = attributeAliases;
        if (params != null && params.length() > 0) {
            String[] split;
            for (String s : split = params.split(",")) {
                String[] kv = s.split("=", 2);
                if (kv.length != 2) continue;
                this.parameterMap.put(kv[0], kv[1]);
            }
        }
    }

    public abstract void init() throws IOException;

    public abstract void processFeature(SimpleFeature var1);

    public abstract File write() throws IOException;
}

