/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.image;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import nl.tailormap.viewer.image.Bbox;
import nl.tailormap.viewer.image.CombineArcServerRestUrl;
import nl.tailormap.viewer.image.CombineArcServerUrl;
import nl.tailormap.viewer.image.CombineImageUrl;
import nl.tailormap.viewer.image.CombineImageWkt;
import nl.tailormap.viewer.image.CombineStaticImageUrl;
import nl.tailormap.viewer.image.CombineTMSUrl;
import nl.tailormap.viewer.image.CombineTileImageUrl;
import nl.tailormap.viewer.image.CombineWMTSUrl;
import nl.tailormap.viewer.image.CombineWmsUrl;
import nl.tailormap.viewer.image.CombineWmscUrl;
import nl.tailormap.viewer.image.FeatureStyle;
import nl.tailormap.viewer.image.ImageBbox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CombineImageSettings {
    private static final Log log = LogFactory.getLog(CombineImageSettings.class);
    public static final String WMS_PROTOCOL = "WMS";
    public static final String ARCSERVER_PROTOCOL = "ARCSERVER";
    public static final String ARCSERVERREST_PROTOCOL = "ARCSERVERREST";
    public static final String IMAGE_PROTOCOL = "IMAGE";
    public static final String WMSC_PROTOCOL = "WMSC";
    public static final String TMS_PROTOCOL = "TMS";
    public static final String WMTS_PROTOCOL = "WMTS";
    private List<CombineImageUrl> urls = null;
    private List<CombineImageWkt> wktGeoms = null;
    private Bbox bbox = null;
    private Integer srid = 28992;
    private Integer width = null;
    private Integer height = null;
    private Integer angle = null;
    public static Color defaultWktGeomColor = Color.RED;
    private String mimeType = "image/png";
    private String tilingServiceUrl = null;

    public List<CombineImageUrl> getCalculatedUrls() {
        return this.getCalculatedUrls(this.urls);
    }

    private List<CombineImageUrl> getCalculatedUrls(List<CombineImageUrl> oldList) {
        ArrayList<CombineImageUrl> returnValue = new ArrayList<CombineImageUrl>();
        if (this.bbox == null || this.width == null || this.height == null) {
            log.warn((Object)"Not all settings set (width,height and bbox must be set to recalculate). Return original urls");
            return oldList;
        }
        if (oldList == null) {
            return returnValue;
        }
        ImageBbox imBBox = this.getRequestBbox();
        for (int i = 0; i < oldList.size(); ++i) {
            CombineImageUrl ciu = oldList.get(i);
            returnValue.addAll(ciu.calculateNewUrl(imBBox));
        }
        return returnValue;
    }

    public Bbox getCalculatedBbox() {
        double unitsPerPixelHeight;
        if (this.bbox == null || this.width == null || this.height == null) {
            log.info((Object)"Not all settings set (width,height and bbox must be set)");
            return null;
        }
        Bbox newBbox = new Bbox(this.bbox);
        double bboxXwidth = this.bbox.getMaxx() - this.bbox.getMinx();
        double bboxYheight = this.bbox.getMaxy() - this.bbox.getMiny();
        double unitsPerPixelWidth = bboxXwidth / (double)this.width.intValue();
        if (unitsPerPixelWidth > (unitsPerPixelHeight = bboxYheight / (double)this.height.intValue())) {
            double newYHeight2 = (unitsPerPixelWidth * (double)this.height.intValue() - bboxYheight) / 2.0;
            newBbox.setMiny(newBbox.getMiny() - newYHeight2);
            newBbox.setMaxy(newBbox.getMaxy() + newYHeight2);
        } else {
            double newXWidth2 = (unitsPerPixelHeight * (double)this.width.intValue() - bboxXwidth) / 2.0;
            newBbox.setMinx(newBbox.getMinx() - newXWidth2);
            newBbox.setMaxx(newBbox.getMaxx() + newXWidth2);
        }
        return newBbox;
    }

    public void addUrl(CombineImageUrl ciu) {
        if (this.urls == null) {
            this.urls = new ArrayList<CombineImageUrl>();
        }
        this.urls.add(ciu);
    }

    public void setWktGeoms(String[] wktGeoms) {
        this.wktGeoms = new ArrayList<CombineImageWkt>();
        for (int i = 0; i < wktGeoms.length; ++i) {
            CombineImageWkt ciw = new CombineImageWkt(wktGeoms[i]);
            this.wktGeoms.add(ciw);
        }
    }

    public Bbox getBboxFromUrls() {
        Bbox bb = null;
        for (int i = 0; i < this.urls.size() && bb == null; ++i) {
            CombineImageUrl ciu = this.urls.get(i);
            if (!(ciu instanceof CombineWmsUrl)) continue;
            bb = ((CombineWmsUrl)ciu).getBboxFromUrl();
        }
        return bb;
    }

    public Integer[] getWidthAndHeightFromUrls() {
        Integer[] hw = null;
        for (int i = 0; i < this.urls.size() && hw == null; ++i) {
            CombineImageUrl ciu = this.urls.get(i);
            if (!(ciu instanceof CombineWmsUrl)) continue;
            hw = ((CombineWmsUrl)ciu).getWidthAndHeightFromUrl();
        }
        return hw;
    }

    public Color getDefaultWktGeomColor() {
        return defaultWktGeomColor;
    }

    public void setDefaultWktGeomColor(Color defaultWktGeomColor) {
        CombineImageSettings.defaultWktGeomColor = defaultWktGeomColor;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public List<CombineImageUrl> getUrls() {
        return this.urls;
    }

    public void setUrls(List<CombineImageUrl> urls) {
        this.urls = urls;
    }

    public List getWktGeoms() {
        return this.wktGeoms;
    }

    public void setWktGeoms(List<CombineImageWkt> wktGeoms) {
        this.wktGeoms = wktGeoms;
    }

    public Bbox getBbox() {
        return this.bbox;
    }

    public void setBbox(double[] bbox) {
        this.bbox = new Bbox(bbox);
    }

    public void setBbox(String bbox) throws Exception {
        this.bbox = new Bbox(bbox);
    }

    public Integer getSrid() {
        return this.srid;
    }

    public void setSrid(Integer srid) {
        this.srid = srid;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public String getTilingServiceUrl() {
        return this.tilingServiceUrl;
    }

    public void setTilingServiceUrl(String tilingServiceUrl) {
        this.tilingServiceUrl = tilingServiceUrl;
    }

    public Integer getAngle() {
        return this.angle;
    }

    public void setAngle(Integer angle) {
        this.angle = angle;
    }

    private Bbox getBboxWithRotation(Bbox bb, Integer rotation) {
        Bbox newBbox = new Bbox(bb);
        if (rotation == null || rotation <= 0 || rotation >= 360) {
            return newBbox;
        }
        double centerX = newBbox.getCenterX();
        double centerY = newBbox.getCenterY();
        newBbox.transform(-centerX, -centerY);
        double[][] coords = new double[4][2];
        coords[0] = this.calcRotation(rotation, newBbox.getMinx(), newBbox.getMiny());
        coords[1] = this.calcRotation(rotation, newBbox.getMaxx(), newBbox.getMiny());
        coords[2] = this.calcRotation(rotation, newBbox.getMaxx(), newBbox.getMaxy());
        coords[3] = this.calcRotation(rotation, newBbox.getMinx(), newBbox.getMaxy());
        for (int i = 0; i < coords.length; ++i) {
            double x = coords[i][0];
            double y = coords[i][1];
            if (x < newBbox.getMinx()) {
                newBbox.setMinx(x);
            }
            if (x > newBbox.getMaxx()) {
                newBbox.setMaxx(x);
            }
            if (y < newBbox.getMiny()) {
                newBbox.setMiny(y);
            }
            if (!(y > newBbox.getMaxy())) continue;
            newBbox.setMaxy(y);
        }
        newBbox.transform(centerX, centerY);
        return newBbox;
    }

    private double[] calcRotation(Integer rotation, double x, double y) {
        double rad = Math.toRadians(rotation.intValue());
        double[] returnValue = new double[]{x * Math.cos(rad) - y * Math.sin(rad), x * Math.sin(rad) + y * Math.cos(rad)};
        return returnValue;
    }

    public ImageBbox getRequestBbox() {
        Bbox correctedBbox = this.getCalculatedBbox();
        Integer reqWidth = this.width;
        Integer reqHeight = this.height;
        if (this.angle != null && this.angle > 0 && this.angle < 360) {
            Bbox reqBbox = this.getBboxWithRotation(correctedBbox, this.angle);
            Double floorWidth = Math.floor(reqBbox.getWidth() / correctedBbox.getWidth() * (double)this.width.intValue());
            Double floorHeight = Math.floor(reqBbox.getHeight() / correctedBbox.getHeight() * (double)this.height.intValue());
            reqWidth = floorWidth.intValue();
            reqHeight = floorHeight.intValue();
            correctedBbox = reqBbox;
        }
        return new ImageBbox(correctedBbox, reqWidth, reqHeight);
    }

    public static CombineImageSettings fromJson(JSONObject settings) throws JSONException, Exception {
        JSONObject jResponse = new JSONObject();
        CombineImageSettings cis = new CombineImageSettings();
        if (settings.has("requests")) {
            JSONArray requests = settings.getJSONArray("requests");
            for (int r = 0; r < requests.length(); ++r) {
                CombineTileImageUrl ctu;
                int i;
                Double[] res;
                String[] tokens;
                String resolutions;
                CombineImageUrl ciu = null;
                JSONObject request = requests.getJSONObject(r);
                String protocol = null;
                if (request.has("protocol")) {
                    protocol = request.getString("protocol");
                }
                if (ARCSERVER_PROTOCOL.equals(protocol)) {
                    ciu = new CombineArcServerUrl();
                } else if (WMS_PROTOCOL.equals(protocol)) {
                    ciu = new CombineWmsUrl();
                } else if (IMAGE_PROTOCOL.equals(protocol)) {
                    CombineStaticImageUrl csiu = new CombineStaticImageUrl();
                    if (request.has("extent")) {
                        csiu.setBbox(new Bbox(request.getString("extent")));
                    }
                    ciu = csiu;
                } else if (WMSC_PROTOCOL.equals(protocol)) {
                    CombineWmscUrl cwu = new CombineWmscUrl();
                    if (request.has("serverExtent")) {
                        cwu.setServiceBbox(new Bbox(request.getString("serverExtent")));
                    }
                    if (request.has("tileWidth")) {
                        cwu.setTileWidth(request.getInt("tileWidth"));
                    }
                    if (request.has("tileHeight")) {
                        cwu.setTileHeight(request.getInt("tileHeight"));
                    }
                    if (request.has("resolutions")) {
                        resolutions = request.getString("resolutions");
                        tokens = resolutions.split(",");
                        res = new Double[tokens.length];
                        for (i = 0; i < tokens.length; ++i) {
                            res[i] = new Double(tokens[i]);
                        }
                        cwu.setResolutions(res);
                    }
                    ciu = cwu;
                } else if (TMS_PROTOCOL.equals(protocol)) {
                    ctu = new CombineTMSUrl();
                    if (request.has("serverExtent")) {
                        ctu.setServiceBbox(new Bbox(request.getString("serverExtent")));
                    }
                    if (request.has("tileWidth")) {
                        ctu.setTileWidth(request.getInt("tileWidth"));
                    }
                    if (request.has("tileHeight")) {
                        ctu.setTileHeight(request.getInt("tileHeight"));
                    }
                    if (request.has("extension")) {
                        ctu.setExtension(request.getString("extension"));
                    }
                    if (request.has("resolutions")) {
                        resolutions = request.getString("resolutions");
                        tokens = resolutions.split(",");
                        res = new Double[tokens.length];
                        for (i = 0; i < tokens.length; ++i) {
                            res[i] = new Double(tokens[i]);
                        }
                        ctu.setResolutions(res);
                    }
                    ciu = ctu;
                } else if (WMTS_PROTOCOL.equals(protocol)) {
                    ctu = new CombineWMTSUrl();
                    if (request.has("serverExtent")) {
                        ctu.setServiceBbox(new Bbox(request.getString("serverExtent")));
                    }
                    if (request.has("tileWidth")) {
                        ctu.setTileWidth(request.getInt("tileWidth"));
                    }
                    if (request.has("tileHeight")) {
                        ctu.setTileHeight(request.getInt("tileHeight"));
                    }
                    if (request.has("extension")) {
                        ctu.setExtension(request.getString("extension"));
                    }
                    if (request.has("matrixSet")) {
                        ((CombineWMTSUrl)ctu).setMatrixSet(request.getJSONObject("matrixSet"));
                    }
                    String layername = request.getString("name");
                    ((CombineWMTSUrl)ctu).setLayername(layername);
                    ciu = ctu;
                } else if (ARCSERVERREST_PROTOCOL.equals(protocol)) {
                    CombineArcServerRestUrl casr = new CombineArcServerRestUrl();
                    ciu = casr;
                } else {
                    throw new IllegalArgumentException("Illegal servicetype: " + protocol);
                }
                ciu.setUrl(request.getString("url"));
                if (request.has("alpha")) {
                    Double alpha = request.getDouble("alpha");
                    ciu.setAlpha(Float.valueOf(alpha.floatValue() / 100.0f));
                }
                if (request.has("body")) {
                    ciu.setBody(request.getString("body"));
                }
                cis.addUrl(ciu);
            }
        }
        if (settings.has("geometries")) {
            JSONArray geometries = settings.getJSONArray("geometries");
            ArrayList<CombineImageWkt> wkts = new ArrayList<CombineImageWkt>();
            for (int g = 0; g < geometries.length(); ++g) {
                JSONObject geom = geometries.getJSONObject(g);
                if (!geom.has("_wktgeom")) continue;
                CombineImageWkt ciw = new CombineImageWkt(geom.getString("_wktgeom"));
                if (geom.has("color") && !geom.isNull("color")) {
                    ciw.setColor(geom.getString("color"));
                }
                if (geom.has("label") && !geom.isNull("label")) {
                    ciw.setLabel(geom.getString("label"));
                }
                if (geom.has("strokeWidth") && !geom.isNull("strokeWidth")) {
                    ciw.setStrokeWidth(Float.valueOf((float)geom.getDouble("strokeWidth")));
                }
                if (geom.has("style")) {
                    JSONObject jsonStyle = geom.getJSONObject("style");
                    FeatureStyle fs = new FeatureStyle(jsonStyle);
                    ciw.setStyle(fs);
                }
                wkts.add(ciw);
            }
            cis.setWktGeoms(wkts);
        }
        if (settings.has("bbox")) {
            cis.setBbox(settings.getString("bbox"));
        }
        if (settings.has("width")) {
            cis.setWidth(settings.getInt("width"));
        }
        if (settings.has("height")) {
            cis.setHeight(settings.getInt("height"));
        }
        if (settings.has("srid")) {
            cis.setSrid(settings.getInt("srid"));
        }
        if (settings.has("angle")) {
            cis.setAngle(settings.getInt("angle"));
        }
        if (settings.has("quality")) {
            int quality = settings.getInt("quality");
            if (cis.getWidth() > cis.getHeight()) {
                cis.setHeight(Math.round(cis.getHeight() * quality / cis.getWidth()));
                cis.setWidth(quality);
            } else {
                cis.setWidth(Math.round(cis.getWidth() * quality / cis.getHeight()));
                cis.setHeight(quality);
            }
        }
        return cis;
    }
}

