/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.tailormap.geotools.data.arcgis.ArcGISFeatureReader;
import nl.tailormap.geotools.data.arcgis.ArcGISFeatureSource;
import nl.tailormap.geotools.filter.visitor.RemoveDistanceUnit;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.config.services.SimpleFeatureType;
import nl.tailormap.viewer.helpers.AuthorizationsHelper;
import nl.tailormap.viewer.helpers.featuresources.FeatureSourceFactoryHelper;
import nl.tailormap.viewer.stripes.LocalizableApplicationActionBean;
import nl.tailormap.viewer.util.TailormapCQL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/arcquery")
@StrictBinding
public class ArcQueryUtilActionBean
extends LocalizableApplicationActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(ArcQueryUtilActionBean.class);
    @Validate
    private String cql;
    @Validate
    private boolean whereOnly = false;
    @Validate
    private ApplicationLayer appLayer;
    @Validate
    private Application application;
    private boolean unauthorized;
    private Layer layer = null;
    private ActionBeanContext context;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getCql() {
        return this.cql;
    }

    public void setCql(String cql) {
        this.cql = cql;
    }

    public boolean isWhereOnly() {
        return this.whereOnly;
    }

    public void setWhereOnly(boolean whereOnly) {
        this.whereOnly = whereOnly;
    }

    public ApplicationLayer getAppLayer() {
        return this.appLayer;
    }

    public void setAppLayer(ApplicationLayer appLayer) {
        this.appLayer = appLayer;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    @After(stages={LifecycleStage.BindingAndValidation})
    public void loadLayer() {
        this.layer = this.appLayer.getService().getSingleLayer(this.appLayer.getLayerName(), Stripersist.getEntityManager());
    }

    @Before(stages={LifecycleStage.EventHandling})
    public void checkAuthorization() {
        EntityManager em = Stripersist.getEntityManager();
        if (this.application == null || this.appLayer == null || !AuthorizationsHelper.isApplicationReadAuthorized((Application)this.application, (Set)AuthorizationsHelper.getRoles((HttpServletRequest)this.context.getRequest(), (EntityManager)em), (EntityManager)em) || !AuthorizationsHelper.isAppLayerReadAuthorized((Application)this.application, (ApplicationLayer)this.appLayer, (HttpServletRequest)this.context.getRequest(), (EntityManager)em)) {
            this.unauthorized = true;
        }
    }

    @DefaultHandler
    public Resolution getObjectIds() throws JSONException, Exception {
        JSONObject json = new JSONObject();
        if (this.unauthorized) {
            json.put("success", false);
            json.put("message", (Object)this.getBundle().getString("viewer.general.noauth"));
            return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
        }
        try {
            if (this.layer != null && this.layer.getFeatureType() != null) {
                if (this.layer.getFeatureType().getFeatureSource() instanceof nl.tailormap.viewer.config.services.ArcGISFeatureSource) {
                    FeatureSource fs = FeatureSourceFactoryHelper.openGeoToolsFeatureSource((SimpleFeatureType)this.layer.getFeatureType());
                    Query q = new Query(fs.getName().toString());
                    this.setFilter(q, Stripersist.getEntityManager());
                    ArcGISFeatureReader agfr = new ArcGISFeatureReader((ArcGISFeatureSource)fs, q);
                    List objIds = agfr.getObjectIds();
                    json.put("objectIds", (Collection)objIds);
                    json.put("objectIdFieldName", (Object)agfr.getObjectIdFieldName());
                    json.put("success", true);
                } else {
                    json.put("success", false);
                    json.put("message", (Object)MessageFormat.format(this.getBundle().getString("viewer.arcqueryutilactionbean.incortype"), this.layer.getFeatureType().getFeatureSource().getClass()));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error loading feature ids", (Throwable)e);
            json.put("success", false);
            Object message = MessageFormat.format(this.getBundle().getString("viewer.arcqueryutilactionbean.ff"), e.toString());
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                message = (String)message + "; " + cause.toString();
            }
            json.put("message", message);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
    }

    private void setFilter(Query q, EntityManager em) throws Exception {
        if (this.cql != null && this.cql.trim().length() > 0) {
            Filter f = TailormapCQL.toFilter(this.cql, em);
            f = (Filter)f.accept((FilterVisitor)new RemoveDistanceUnit(), null);
            q.setFilter(f);
        }
    }
}

