/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.stripes;

import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.SourceFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.tailormap.viewer.components.ComponentRegistryInitializer;
import nl.tailormap.viewer.components.ViewerComponent;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ConfiguredComponent;
import nl.tailormap.viewer.helpers.AuthorizationsHelper;
import nl.tailormap.viewer.helpers.app.ComponentHelper;
import nl.tailormap.viewer.stripes.ApplicationActionBean;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/app/component/{className}/{$event}/{file}")
@StrictBinding
public class ComponentActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(ComponentActionBean.class);
    @Validate
    private String app;
    @Validate
    private String version;
    @Validate
    private String className;
    @Validate
    private String file;
    @Validate
    private boolean minified;
    private Application application;
    private ViewerComponent component;
    private ActionBeanContext context;
    private static final Map<String, Object[]> minifiedSourceCache = new HashMap<String, Object[]>();

    public void setContext(ActionBeanContext abc) {
        this.context = abc;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public boolean isMinified() {
        return this.minified;
    }

    public void setMinified(boolean minified) {
        this.minified = minified;
    }

    @Before(stages={LifecycleStage.EventHandling})
    public void load() {
        this.component = ComponentRegistryInitializer.getInstance().getViewerComponent(this.className);
    }

    @DefaultHandler
    public Resolution source() throws IOException {
        long ifModifiedSince;
        File[] files = null;
        if (this.className != null && this.component == null) {
            return new ErrorResolution(403, "User not authorized for this components' source");
        }
        if (this.component == null) {
            this.application = ApplicationActionBean.findApplication(this.app, this.version);
            ArrayList comps = new ArrayList(this.application.getComponents());
            Collections.sort(comps);
            HashSet<String> classNamesDone = new HashSet<String>();
            ArrayList fileList = new ArrayList();
            EntityManager em = Stripersist.getEntityManager();
            Iterator iterator = comps.iterator();
            while (iterator.hasNext()) {
                ConfiguredComponent cc = (ConfiguredComponent)iterator.next();
                if (!AuthorizationsHelper.isConfiguredComponentAuthorized((ConfiguredComponent)cc, (Set)AuthorizationsHelper.getRoles((HttpServletRequest)this.context.getRequest(), (EntityManager)em), (EntityManager)em) || classNamesDone.contains(cc.getClassName())) continue;
                classNamesDone.add(cc.getClassName());
                ViewerComponent vc = ComponentHelper.getViewerComponent((String)cc.getClassName());
                if (vc == null || vc.getSources() == null) continue;
                fileList.addAll(Arrays.asList(vc.getSources()));
            }
            files = fileList.toArray(new File[0]);
        } else if (this.file != null) {
            for (File f : this.component.getSources()) {
                if (!f.getName().equals(this.file)) continue;
                files = new File[]{f};
                break;
            }
            if (files == null) {
                return new ErrorResolution(404, this.file);
            }
        } else {
            files = this.component.getSources();
        }
        long lastModified = -1L;
        for (File f : files) {
            lastModified = Math.max(lastModified, f.lastModified());
        }
        if (lastModified != -1L && (ifModifiedSince = this.context.getRequest().getDateHeader("If-Modified-Since")) != -1L && ifModifiedSince >= lastModified) {
            return new ErrorResolution(304);
        }
        final File[] theFiles = files;
        StreamingResolution res = new StreamingResolution("application/javascript"){

            public void stream(HttpServletResponse response) throws Exception {
                ServletOutputStream out = response.getOutputStream();
                for (File f : theFiles) {
                    if (theFiles.length != 1) {
                        out.write(("\n\n// Source file: " + f.getName() + "\n\n").getBytes("UTF-8"));
                    }
                    if (ComponentActionBean.this.isMinified()) {
                        String minified = ComponentActionBean.getMinifiedSource(f);
                        if (minified != null) {
                            out.write(minified.getBytes("UTF-8"));
                            continue;
                        }
                        IOUtils.copy((InputStream)new FileInputStream(f), (OutputStream)out);
                        continue;
                    }
                    IOUtils.copy((InputStream)new FileInputStream(f), (OutputStream)out);
                }
            }
        };
        if (lastModified != -1L) {
            res.setLastModified(lastModified);
        }
        res.setCharacterEncoding("UTF-8");
        return res;
    }

    public Resolution resource() throws IOException {
        this.getContext().getResponse().sendError(404);
        return null;
    }

    private static synchronized String getMinifiedSource(File f) throws IOException {
        Long lastModified;
        String key = f.getCanonicalPath();
        Object[] cache = minifiedSourceCache.get(key);
        if (cache != null && !(lastModified = (Long)cache[0]).equals(f.lastModified())) {
            minifiedSourceCache.remove(key);
            cache = null;
        }
        if (cache != null) {
            return (String)cache[1];
        }
        String minified = null;
        try {
            Compiler compiler = new Compiler();
            CompilerOptions options = new CompilerOptions();
            options.setLanguageOut(CompilerOptions.LanguageMode.ECMASCRIPT5);
            options.setEmitUseStrict(false);
            CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(options);
            options.setOutputCharset(Charset.forName("UTF-8"));
            compiler.compile(SourceFile.fromCode((String)"dummy.js", (String)""), SourceFile.fromFile((String)f.getCanonicalPath()), options);
            if (compiler.hasErrors()) {
                log.warn((Object)(compiler.getErrorCount() + " error(s) minifying source file " + f.getCanonicalPath() + "; using original source"));
                minified = IOUtils.toString((InputStream)new FileInputStream(f), (Charset)Charset.forName("UTF-8"));
                for (int i = 0; i < compiler.getErrorCount(); ++i) {
                    JSError error = (JSError)compiler.getErrors().get(i);
                    log.warn((Object)String.format("#%d line %d,%d: %s: %s", i + 1, error.getLineno(), error.getCharno(), error.getDefaultLevel(), error.getDescription()));
                }
            } else {
                minified = compiler.toSource();
            }
        }
        catch (Exception e) {
            log.warn((Object)String.format("Error minifying file \"%s\" using closure compiler, sending original source\n", f.getCanonicalPath()), (Throwable)e);
        }
        Object[] entry = new Object[]{f.lastModified(), minified};
        minifiedSourceCache.put(key, entry);
        return minified;
    }
}

