/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.stripes;

import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.tailormap.viewer.components.ComponentRegistry;
import nl.tailormap.viewer.components.ViewerComponent;
import nl.tailormap.web.stripes.ErrorMessageResolution;
import org.apache.commons.io.IOUtils;

@UrlBinding(value="/action/componentresource")
@StrictBinding
public class ComponentResourceActionBean
implements ActionBean {
    private ActionBeanContext context;
    @Validate
    private String className;
    @Validate
    private String resource;
    @Validate
    private String mimeType;

    public Resolution resource() throws IOException {
        if (this.className == null || this.getResource() == null) {
            return new ErrorMessageResolution("Both 'className' and 'resource' are required.");
        }
        ViewerComponent comp = ComponentRegistry.getInstance().getViewerComponent(this.className);
        Object path = comp.getPath();
        final File file = new File((String)(path = (String)path + File.separator + this.getResource()));
        if (!file.canRead()) {
            return new ErrorResolution(404, "Resource not found");
        }
        String check = file.getCanonicalPath();
        if (!check.startsWith(comp.getPath())) {
            return new ErrorResolution(403, "Not allowed to access file");
        }
        String contentType = this.getMimeType() == null ? this.getContentType(file) : this.getMimeType();
        return new StreamingResolution(contentType){

            protected void stream(HttpServletResponse response) throws IOException {
                IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)response.getOutputStream());
            }
        };
    }

    private String getContentType(File f) {
        Collection mimeTypes;
        if (MimeUtil.getMimeDetector((String)"eu.medsea.mimeutil.detector.MagicMimeMimeDetector") == null) {
            MimeUtil.registerMimeDetector((String)"eu.medsea.mimeutil.detector.MagicMimeMimeDetector");
            MimeUtil.registerMimeDetector((String)"eu.medsea.mimeutil.detector.ExtensionMimeDetector");
            MimeUtil.registerMimeDetector((String)"eu.medsea.mimeutil.detector.OpendesktopMimeDetector");
        }
        if (!(mimeTypes = MimeUtil.getMimeTypes((File)f)).isEmpty()) {
            Object[] mimeArray = mimeTypes.toArray();
            MimeType mime = (MimeType)mimeArray[0];
            return mime.toString();
        }
        return "plain/text";
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }
}

