/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.stripes;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.tailormap.viewer.config.app.Resource;
import org.apache.commons.io.IOUtils;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/image/{name}")
@StrictBinding
public class ImageActionBean
implements ActionBean {
    private ActionBeanContext context;
    @Validate
    private String name;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Resolution download() throws FileNotFoundException {
        long ifModifiedSince;
        final Resource r = (Resource)Stripersist.getEntityManager().find(Resource.class, (Object)this.name);
        if (r == null) {
            return new ErrorResolution(404);
        }
        if (r.getModified() != null && (ifModifiedSince = this.context.getRequest().getDateHeader("If-Modified-Since")) != -1L && ifModifiedSince >= r.getModified().getTime()) {
            return new ErrorResolution(304);
        }
        StreamingResolution res = new StreamingResolution(r.getContentType()){

            public void stream(HttpServletResponse response) throws Exception {
                ServletOutputStream out = response.getOutputStream();
                ByteArrayInputStream in = new ByteArrayInputStream(r.getData());
                IOUtils.copy((InputStream)in, (OutputStream)out);
                ((InputStream)in).close();
            }
        };
        res.setLastModified(r.getModified().getTime());
        res.setFilename(r.getName());
        res.setLength(r.getSize());
        res.setAttachment(false);
        return res;
    }
}

