/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.tailormap.viewer.audit.AuditMessageObject;
import nl.tailormap.viewer.audit.Auditable;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.helpers.AuthorizationsHelper;
import nl.tailormap.viewer.helpers.featuresources.FeatureSourceFactoryHelper;
import nl.tailormap.viewer.stripes.LocalizableApplicationActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureSource;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.util.GeometryTypeConverterFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.geometry.jts.GeometryCollector;
import org.geotools.util.Converter;
import org.json.JSONException;
import org.json.JSONObject;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.operation.overlay.snap.GeometrySnapper;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/feature/merge")
@StrictBinding
public class MergeFeaturesActionBean
extends LocalizableApplicationActionBean
implements Auditable {
    private static final Log LOG = LogFactory.getLog(MergeFeaturesActionBean.class);
    private static final String FID = "__fid";
    private ActionBeanContext context;
    @Validate
    private Application application;
    @Validate
    private ApplicationLayer appLayer;
    @Validate
    private String strategy;
    @Validate
    private String extraData;
    @Validate
    private int mergeGapDist;
    @Validate
    private String fidA;
    @Validate
    private String fidB;
    private SimpleFeatureStore store;
    private Layer layer = null;
    private boolean unauthorized;
    private AuditMessageObject auditMessageObject;

    @After(stages={LifecycleStage.BindingAndValidation})
    public void loadLayer() {
        this.layer = this.appLayer.getService().getSingleLayer(this.appLayer.getLayerName(), Stripersist.getEntityManager());
    }

    @Before(stages={LifecycleStage.EventHandling})
    public void checkAuthorization() {
        if (this.application == null || this.appLayer == null || !AuthorizationsHelper.isLayerGeomWriteAuthorized((Layer)this.layer, (HttpServletRequest)this.context.getRequest(), (EntityManager)Stripersist.getEntityManager())) {
            this.unauthorized = true;
        }
        this.auditMessageObject = new AuditMessageObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution merge() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        Object error = null;
        if (this.appLayer == null) {
            error = this.getBundle().getString("viewer.mergefeaturesactionbean.1");
        } else if (this.unauthorized) {
            error = this.getBundle().getString("viewer.mergefeaturesactionbean.2");
        } else {
            FeatureSource fs = null;
            try {
                if (this.fidA == null || this.fidB == null) {
                    throw new IllegalArgumentException(this.getBundle().getString("viewer.mergefeaturesactionbean.3"));
                }
                if (this.strategy == null) {
                    throw new IllegalArgumentException(this.getBundle().getString("viewer.mergefeaturesactionbean.4"));
                }
                nl.tailormap.viewer.config.services.SimpleFeatureType sft = this.layer.getFeatureType();
                fs = FeatureSourceFactoryHelper.openGeoToolsFeatureSource((nl.tailormap.viewer.config.services.SimpleFeatureType)sft);
                if (!(fs instanceof SimpleFeatureStore)) {
                    throw new IllegalArgumentException(this.getBundle().getString("viewer.mergefeaturesactionbean.5"));
                }
                this.store = (SimpleFeatureStore)fs;
                List<FeatureId> ids = this.mergeFeatures();
                if (ids.isEmpty()) {
                    throw new IllegalArgumentException(this.getBundle().getString("viewer.mergefeaturesactionbean.6"));
                }
                if (ids.size() > 1) {
                    throw new IllegalArgumentException(this.getBundle().getString("viewer.mergefeaturesactionbean.7"));
                }
                json.put("fids", ids);
                json.put("success", (Object)Boolean.TRUE);
            }
            catch (IllegalArgumentException e) {
                LOG.warn((Object)"Merge error", (Throwable)e);
                error = e.getLocalizedMessage();
            }
            catch (Exception e) {
                LOG.error((Object)MessageFormat.format(this.getBundle().getString("viewer.mergefeaturesactionbean.8"), this.fidB, this.fidA, e));
                error = e.toString();
                if (e.getCause() != null) {
                    error = (String)error + "; cause: " + e.getCause().toString();
                }
            }
            finally {
                if (fs != null) {
                    fs.getDataStore().dispose();
                }
            }
        }
        if (error != null) {
            json.put("error", error);
        }
        this.auditMessageObject.addMessage((Object)json);
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    protected List<SimpleFeature> handleExtraData(List<SimpleFeature> features) throws Exception {
        return features;
    }

    protected SimpleFeature handleExtraData(SimpleFeature feature) throws Exception {
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        features.add(feature);
        return this.handleExtraData(features).get(0);
    }

    private List<FeatureId> mergeFeatures() throws Exception {
        ArrayList<FeatureId> ids = new ArrayList();
        try (DefaultTransaction transaction = new DefaultTransaction("split");){
            this.store.setTransaction((Transaction)transaction);
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
            Id filterA = ff.id(new FeatureId[]{new FeatureIdImpl(this.fidA)});
            Id filterB = ff.id(new FeatureId[]{new FeatureIdImpl(this.fidB)});
            SimpleFeature fA = null;
            SimpleFeatureCollection fc = this.store.getFeatures((Filter)filterA);
            if (!fc.features().hasNext()) {
                throw new IllegalArgumentException(MessageFormat.format(this.getBundle().getString("viewer.mergefeaturesactionbean.9"), this.fidA));
            }
            fA = (SimpleFeature)fc.features().next();
            SimpleFeature fB = null;
            fc = this.store.getFeatures((Filter)filterB);
            if (!fc.features().hasNext()) {
                throw new IllegalArgumentException(MessageFormat.format(this.getBundle().getString("viewer.mergefeaturesactionbean.10"), this.fidB));
            }
            fB = (SimpleFeature)fc.features().next();
            String geomAttrName = ((SimpleFeatureType)this.store.getSchema()).getGeometryDescriptor().getLocalName();
            Geometry geomA = (Geometry)fA.getProperty(geomAttrName).getValue();
            Geometry geomB = (Geometry)fB.getProperty(geomAttrName).getValue();
            LOG.debug((Object)("input geomA: " + geomA));
            LOG.debug((Object)("input geomB: " + geomB));
            Geometry newGeom = null;
            GeometryCollector geoms = new GeometryCollector();
            geoms.setFactory(new GeometryFactory(new PrecisionModel(), geomA.getSRID()));
            geoms.add(geomA);
            geoms.add(geomB);
            if (!geomB.intersects(geomA)) {
                double distance = geomA.distance(geomB);
                LOG.info((Object)MessageFormat.format(this.getBundle().getString("viewer.mergefeaturesactionbean.11"), distance));
                if (distance > (double)this.mergeGapDist) {
                    throw new IllegalArgumentException(MessageFormat.format(this.getBundle().getString("viewer.mergefeaturesactionbean.12"), distance));
                }
                newGeom = GeometrySnapper.snapToSelf((Geometry)geoms.collect(), (double)this.mergeGapDist, (boolean)true);
                geoms.add(newGeom);
            }
            newGeom = geoms.collect().union();
            LOG.debug((Object)("new geometry: " + newGeom));
            LOG.debug((Object)("New Geometry is valid? " + newGeom.isValid()));
            newGeom = GeometrySnapper.snapToSelf((Geometry)newGeom, (double)0.01, (boolean)true);
            newGeom.normalize();
            LOG.debug((Object)("Normalized new geometry: " + newGeom));
            LOG.debug((Object)("Normalized new Geometry is valid? " + newGeom.isValid()));
            ids = this.handleStrategy(fA, fB, newGeom, (Filter)filterA, (Filter)filterB, this.store, this.strategy);
            transaction.commit();
            this.afterMerge(ids);
        }
        return ids;
    }

    protected List<FeatureId> handleStrategy(SimpleFeature featureA, SimpleFeature featureB, Geometry newGeom, Filter filterA, Filter filterB, SimpleFeatureStore localStore, String localStrategy) throws Exception {
        List<Object> ids = new ArrayList<FeatureId>();
        String geomAttrName = ((SimpleFeatureType)localStore.getSchema()).getGeometryDescriptor().getLocalName();
        GeometryType type = ((SimpleFeatureType)localStore.getSchema()).getGeometryDescriptor().getType();
        GeometryTypeConverterFactory cf = new GeometryTypeConverterFactory();
        Converter c = cf.createConverter(Geometry.class, ((SimpleFeatureType)localStore.getSchema()).getGeometryDescriptor().getType().getBinding(), null);
        if (localStrategy.equalsIgnoreCase("replace")) {
            featureA.setAttribute(geomAttrName, c.convert((Object)newGeom, type.getBinding()));
            featureA = this.handleExtraData(featureA);
            Object[] attributevalues = featureA.getAttributes().toArray(new Object[featureA.getAttributeCount()]);
            String[] attributes = DataUtilities.attributeNames((SimpleFeatureType)featureA.getFeatureType());
            localStore.modifyFeatures(attributes, attributevalues, filterA);
            localStore.removeFeatures(filterB);
            ids.add((FeatureId)new FeatureIdImpl(this.fidA));
        } else if (localStrategy.equalsIgnoreCase("new")) {
            localStore.removeFeatures(filterA);
            localStore.removeFeatures(filterB);
            SimpleFeature newFeat = DataUtilities.createFeature((SimpleFeatureType)featureA.getType(), (String)DataUtilities.encodeFeature((SimpleFeature)featureA, (boolean)false));
            newFeat.setAttribute(geomAttrName, c.convert((Object)newGeom, type.getBinding()));
            List<SimpleFeature> newFeats = new ArrayList<SimpleFeature>();
            newFeats.add(newFeat);
            newFeats = this.handleExtraData(newFeats);
            ids = localStore.addFeatures((FeatureCollection)DataUtilities.collection(newFeats));
        } else {
            throw new IllegalArgumentException(MessageFormat.format(this.getBundle().getString("viewer.mergefeaturesactionbean.13"), localStrategy));
        }
        return ids;
    }

    protected void afterMerge(List<FeatureId> ids) {
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public ApplicationLayer getAppLayer() {
        return this.appLayer;
    }

    public void setAppLayer(ApplicationLayer appLayer) {
        this.appLayer = appLayer;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public String getFidA() {
        return this.fidA;
    }

    public void setFidA(String fidA) {
        this.fidA = fidA;
    }

    public String getFidB() {
        return this.fidB;
    }

    public void setFidB(String fidB) {
        this.fidB = fidB;
    }

    public int getMergeGapDist() {
        return this.mergeGapDist;
    }

    public void setMergeGapDist(int mergeGapDist) {
        this.mergeGapDist = mergeGapDist;
    }

    public String getExtraData() {
        return this.extraData;
    }

    public void setExtraData(String extraData) {
        this.extraData = extraData;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public AuditMessageObject getAuditMessageObject() {
        return this.auditMessageObject;
    }
}

