/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.util;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import nl.tailormap.viewer.config.security.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.stripesstuff.stripersist.Stripersist;

public class IPAuthenticationFilter
implements Filter {
    private static final Log log = LogFactory.getLog(IPAuthenticationFilter.class);
    private FilterConfig filterConfig = null;
    private static final String IP_CHECK = IPAuthenticationFilter.class + "_IP_CHECK";
    private static final String USER_CHECK = IPAuthenticationFilter.class + "_USER_CHECK";
    private static final String TIME_USER_CHECKED = IPAuthenticationFilter.class + "_TIME_USER_CHECKED";
    private static final int MAX_TIME_USER_CACHE = 20000;

    public void doFilter(ServletRequest r, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)r;
        HttpSession session = request.getSession();
        if (request.getUserPrincipal() != null) {
            chain.doFilter((ServletRequest)request, response);
        } else {
            User u = null;
            if (session.getAttribute(IP_CHECK) == null && session.getAttribute(USER_CHECK) == null || this.isCacheValid(session)) {
                String ipAddress = this.getIp(request);
                session.setAttribute(IP_CHECK, (Object)ipAddress);
                Stripersist.requestInit();
                EntityManager em = Stripersist.getEntityManager();
                List users = em.createQuery("from User", User.class).getResultList();
                ArrayList<User> possibleUsers = new ArrayList<User>();
                for (User user : users) {
                    if (!this.checkValidIpAddress(request, user)) continue;
                    possibleUsers.add(user);
                }
                if (possibleUsers.isEmpty()) {
                    log.debug((Object)"No eligible users found for ip");
                } else if (possibleUsers.size() == 1) {
                    u = (User)possibleUsers.get(0);
                    u.setAuthenticatedByIp(true);
                    Hibernate.initialize((Object)u.getGroups());
                    Hibernate.initialize((Object)u.getDetails());
                    session.setAttribute(IP_CHECK, (Object)ipAddress);
                    session.setAttribute(USER_CHECK, (Object)u);
                    session.setAttribute(TIME_USER_CHECKED, (Object)System.currentTimeMillis());
                } else {
                    log.debug((Object)"Too many eligible users found for ip.");
                }
                Stripersist.requestComplete();
            } else {
                u = (User)session.getAttribute(USER_CHECK);
            }
            final User user = u;
            RequestWrapper wrappedRequest = new RequestWrapper(request){

                public Principal getUserPrincipal() {
                    if (user != null) {
                        return user;
                    }
                    return super.getUserPrincipal();
                }

                public String getRemoteUser() {
                    if (user != null) {
                        return user.getName();
                    }
                    return super.getRemoteUser();
                }

                public boolean isUserInRole(String role) {
                    if (user != null) {
                        return user.checkRole(role);
                    }
                    return super.isUserInRole(role);
                }
            };
            Throwable problem = null;
            try {
                chain.doFilter((ServletRequest)wrappedRequest, response);
            }
            catch (IOException | ServletException t) {
                log.error((Object)"Error processing chain", problem);
                throw t;
            }
        }
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public String toString() {
        if (this.filterConfig == null) {
            return "IPAuthenticationFilter()";
        }
        StringBuilder sb = new StringBuilder("IPAuthenticationFilter(");
        sb.append(this.filterConfig);
        sb.append(")");
        return sb.toString();
    }

    private boolean checkValidIpAddress(HttpServletRequest request, User user) {
        String remoteAddress = this.getIp(request);
        for (String ipAddress : user.getIps()) {
            log.debug((Object)("Check ip: " + ipAddress + " against: " + remoteAddress));
            if (ipAddress.contains("*") && this.isRemoteAddressWithinIpRange(ipAddress, remoteAddress)) {
                return true;
            }
            if (!ipAddress.equalsIgnoreCase(remoteAddress)) continue;
            return true;
        }
        log.info((Object)("IP address " + remoteAddress + " not allowed for user " + user.getName()));
        return false;
    }

    private String getIp(HttpServletRequest request) {
        String remoteAddress = request.getRemoteAddr();
        String forwardedFor = request.getHeader("X-Forwarded-For");
        if (forwardedFor != null) {
            int endIndex = forwardedFor.contains(",") ? forwardedFor.indexOf(",") : forwardedFor.length();
            remoteAddress = forwardedFor.substring(0, endIndex);
        }
        return remoteAddress;
    }

    protected boolean isRemoteAddressWithinIpRange(String ip, String remote) {
        if (ip == null || remote == null) {
            return false;
        }
        String[] arrIp = ip.split("\\.");
        String[] arrRemote = remote.split("\\.");
        if (arrIp == null || arrIp.length < 1 || arrRemote == null || arrRemote.length < 1) {
            return false;
        }
        for (int i = 0; i < arrIp.length; ++i) {
            if (arrIp[i].equalsIgnoreCase("*") || arrIp[i].equalsIgnoreCase(arrRemote[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isCacheValid(HttpSession session) {
        if (session == null) {
            return true;
        }
        if (session.getAttribute(TIME_USER_CHECKED) == null) {
            return true;
        }
        long prev = (Long)session.getAttribute(TIME_USER_CHECKED);
        long now = System.currentTimeMillis();
        return now - prev > 20000L;
    }

    class RequestWrapper
    extends HttpServletRequestWrapper {
        protected Hashtable localParams;

        public RequestWrapper(HttpServletRequest request) {
            super(request);
            this.localParams = null;
        }

        public void setParameter(String name, String[] values) {
            if (this.localParams == null) {
                this.localParams = new Hashtable();
                Map wrappedParams = this.getRequest().getParameterMap();
                Set keySet = wrappedParams.keySet();
                for (Object key : keySet) {
                    Object value = wrappedParams.get(key);
                    this.localParams.put(key, value);
                }
            }
            this.localParams.put(name, values);
        }

        public String getParameter(String name) {
            if (this.localParams == null) {
                return this.getRequest().getParameter(name);
            }
            Object val = this.localParams.get(name);
            if (val instanceof String) {
                return (String)val;
            }
            if (val instanceof String[]) {
                String[] values = (String[])val;
                return values[0];
            }
            return val == null ? null : val.toString();
        }

        public String[] getParameterValues(String name) {
            if (this.localParams == null) {
                return this.getRequest().getParameterValues(name);
            }
            return (String[])this.localParams.get(name);
        }

        public Enumeration getParameterNames() {
            if (this.localParams == null) {
                return this.getRequest().getParameterNames();
            }
            return this.localParams.keys();
        }

        public Map getParameterMap() {
            if (this.localParams == null) {
                return this.getRequest().getParameterMap();
            }
            return this.localParams;
        }
    }
}

