/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.services.FeatureTypeRelation;
import nl.tailormap.viewer.config.services.FeatureTypeRelationKey;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.config.services.SimpleFeatureType;
import nl.tailormap.viewer.helpers.featuresources.FeatureSourceFactoryHelper;
import nl.tailormap.viewer.util.ChangeMatchCase;
import nl.tailormap.viewer.util.Subselect;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;

public class TailormapCQL {
    private static final Log LOG = LogFactory.getLog(TailormapCQL.class);
    private static final String BEGIN_APPLAYER_PART = "APPLAYER(";
    public static final String BEGIN_RELATED_FEATURE_PART = "RELATED_FEATURE(";
    private static FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);

    public static Filter toFilter(String filter, EntityManager em) throws CQLException {
        return TailormapCQL.toFilter(filter, em, true);
    }

    public static Filter toFilter(String filter, EntityManager em, boolean simplify) throws CQLException {
        filter = TailormapCQL.processFilter(filter, em);
        return TailormapCQL.getFilter(filter, em, simplify);
    }

    private static String processFilter(String filter, EntityManager em) throws CQLException {
        if (filter.contains(BEGIN_APPLAYER_PART)) {
            filter = TailormapCQL.replaceApplayerFilter(filter, em);
        }
        return filter;
    }

    private static Filter getFilter(String filter, EntityManager em, boolean simplify) throws CQLException {
        Filter f = null;
        f = filter.contains(BEGIN_RELATED_FEATURE_PART) ? TailormapCQL.replaceSubselectsFromFilter(filter, em, simplify) : ECQL.toFilter((String)filter);
        return f;
    }

    private static Filter replaceSubselectsFromFilter(String filter, EntityManager em, boolean simplify) throws CQLException {
        Object remainingFilter = filter;
        Filter f = null;
        Filter current = null;
        if (TailormapCQL.startsWithRelatedLayer((String)remainingFilter)) {
            int startIndex = ((String)remainingFilter).indexOf(BEGIN_RELATED_FEATURE_PART) + BEGIN_RELATED_FEATURE_PART.length();
            int endIndex = TailormapCQL.findIndexOfClosingBracket(startIndex - 1, (String)remainingFilter);
            String filterPart = BEGIN_RELATED_FEATURE_PART + ((String)remainingFilter).substring(startIndex, endIndex + 1);
            if (simplify) {
                String replaced = TailormapCQL.replaceRelatedFilter(filterPart, em);
                current = ECQL.toFilter((String)replaced);
            } else {
                current = TailormapCQL.createSubselect(filterPart, em);
            }
            remainingFilter = ((String)remainingFilter).substring(0, ((String)remainingFilter).indexOf(BEGIN_RELATED_FEATURE_PART)) + ((String)remainingFilter).substring(endIndex + 1);
        } else {
            int endAnd = Math.max(0, ((String)remainingFilter).toLowerCase().indexOf(" and "));
            int endOR = Math.max(0, ((String)remainingFilter).toLowerCase().indexOf(" or "));
            int end = Math.max(endAnd, endOR);
            String filterPart = ((String)remainingFilter).substring(0, end);
            current = ECQL.toFilter((String)filterPart);
            remainingFilter = ((String)remainingFilter).substring(end);
        }
        remainingFilter = ((String)remainingFilter).trim();
        remainingFilter = TailormapCQL.removeUnnecessaryParens((String)remainingFilter);
        if (!((String)remainingFilter).isEmpty()) {
            remainingFilter = ((String)remainingFilter).trim();
            String nextFilter = ((String)remainingFilter).substring(((String)remainingFilter).indexOf(" "));
            f = TailormapCQL.getBinaryLogicOperator((String)remainingFilter, current, TailormapCQL.getFilter(nextFilter, em, simplify));
        } else {
            f = current;
        }
        return f;
    }

    public static String removeUnnecessaryParens(String filter) {
        String newFilter = TailormapCQL.removeAdjoiningParens(filter);
        newFilter = TailormapCQL.removeEnclosingParens(newFilter);
        return newFilter;
    }

    public static String removeAdjoiningParens(String filter) {
        if (filter.isEmpty()) {
            return filter;
        }
        Object cur = "";
        for (int i = 0; i < filter.length(); ++i) {
            char c = filter.charAt(i);
            if (i + 1 < filter.length()) {
                char next = filter.charAt(i + 1);
                if (c == '(' && next == ')') {
                    ++i;
                    continue;
                }
                cur = (String)cur + c;
                continue;
            }
            cur = (String)cur + c;
        }
        if (filter.length() > ((String)cur).length() && ((String)cur).length() >= 2) {
            cur = TailormapCQL.removeAdjoiningParens((String)cur);
        }
        return cur;
    }

    public static String removeEnclosingParens(String filter) {
        String cur = filter;
        while (cur.startsWith("(") && cur.endsWith(")")) {
            cur = cur.substring(1, cur.length() - 1);
        }
        return cur;
    }

    private static boolean startsWithRelatedLayer(String filter) {
        int threshold = 6;
        return filter.substring(0, BEGIN_RELATED_FEATURE_PART.length() + threshold).contains(BEGIN_RELATED_FEATURE_PART);
    }

    private static BinaryLogicOperator getBinaryLogicOperator(String filter, Filter prev, Filter current) {
        int endIndex = filter.indexOf(" ");
        String logicPart = filter.substring(0, endIndex);
        return logicPart.contains("AND") ? ff.and(prev, current) : ff.or(prev, current);
    }

    private static Subselect createSubselect(String filter, EntityManager em) throws CQLException {
        FeatureTypeRelation relation = TailormapCQL.retrieveFeatureTypeRelation(filter, em);
        SimpleFeatureType subSft = relation.getForeignFeatureType();
        FeatureTypeRelationKey key = (FeatureTypeRelationKey)relation.getRelationKeys().get(0);
        String relatedColumn = key.getRightSide().getName();
        String mainColumn = key.getLeftSide().getName();
        String relatedTable = subSft.getTypeName();
        Filter relatedFilter = TailormapCQL.toFilter(TailormapCQL.retrieveRelatedFilter(filter), em, false);
        Subselect s = new Subselect(relatedFilter, relatedColumn, mainColumn, relatedTable);
        return s;
    }

    private static int findIndexOfClosingBracket(int startIndex, String filter) {
        int openBrackets = 0;
        int closingBrackets = 0;
        int endIndex = 0;
        for (int i = startIndex; i < filter.length(); ++i) {
            char c = filter.charAt(i);
            if (c == '(') {
                ++openBrackets;
            }
            if (c == ')') {
                ++closingBrackets;
            }
            if (openBrackets != closingBrackets || c == ' ') continue;
            endIndex = i;
            break;
        }
        return endIndex;
    }

    private static String retrieveRelatedFilter(String filter) {
        int endSubFilter = StringUtils.ordinalIndexOf((CharSequence)filter, (CharSequence)",", (int)2) + 1;
        int endIndex = TailormapCQL.findIndexOfClosingBracket(endSubFilter, filter);
        if (endIndex == endSubFilter || endIndex - 1 == endSubFilter) {
            endIndex = filter.indexOf(")", endSubFilter) - 1;
        }
        String relatedFilterString = filter.substring(endSubFilter, endIndex + 1);
        return relatedFilterString;
    }

    private static FeatureTypeRelation retrieveFeatureTypeRelation(String filter, EntityManager em) throws CQLException {
        int beginPartLength = filter.indexOf(BEGIN_RELATED_FEATURE_PART) + BEGIN_RELATED_FEATURE_PART.length();
        int endMainFeatureType = filter.indexOf(",", beginPartLength + 1);
        int endSimpleFeatureIdSub = filter.indexOf(",", endMainFeatureType + 1);
        if (endMainFeatureType == -1 || endSimpleFeatureIdSub == -1) {
            throw new CQLException("Related layer filter incorrectly formed. Must be of form: RELATED_LAYER(<SIMPLEFEATURETYPEID_MAIN>, <SIMPLEFEATURETYPEID_SUB>, <FILTER>)");
        }
        String simpleFeatureTypeIdMain = filter.substring(beginPartLength, endMainFeatureType);
        String simpleFeatureIdSub = filter.substring(endMainFeatureType + 1, endSimpleFeatureIdSub);
        if (simpleFeatureTypeIdMain.isEmpty() || simpleFeatureIdSub.isEmpty()) {
            throw new CQLException("Related layer filter incorrectly formed. Must be of form: RELATED_LAYER(<SIMPLEFEATURETYPEID_MAIN>, <SIMPLEFEATURETYPEID_SUB>, <FILTER>)");
        }
        simpleFeatureTypeIdMain = simpleFeatureTypeIdMain.trim();
        simpleFeatureIdSub = simpleFeatureIdSub.trim();
        try {
            SimpleFeatureType sub = (SimpleFeatureType)em.find(SimpleFeatureType.class, (Object)Long.parseLong(simpleFeatureIdSub));
            SimpleFeatureType main = (SimpleFeatureType)em.find(SimpleFeatureType.class, (Object)Long.parseLong(simpleFeatureTypeIdMain));
            AtomicReference<FeatureTypeRelation> atomRel = new AtomicReference<FeatureTypeRelation>();
            List mainRelations = main.getRelations();
            mainRelations.forEach(rel -> {
                if (rel.getForeignFeatureType().getId().equals(sub.getId())) {
                    atomRel.set((FeatureTypeRelation)rel);
                }
            });
            if (atomRel.get() == null) {
                List subRelations = sub.getRelations();
                subRelations.forEach(rel -> {
                    if (rel.getForeignFeatureType().getId().equals(main.getId())) {
                        atomRel.set((FeatureTypeRelation)rel);
                    }
                });
                if (atomRel.get() != null) {
                    FeatureTypeRelation old = (FeatureTypeRelation)atomRel.get();
                    FeatureTypeRelation switched = new FeatureTypeRelation();
                    switched.setFeatureType(old.getForeignFeatureType());
                    switched.setForeignFeatureType(old.getFeatureType());
                    switched.setRelationKeys(old.getRelationKeys().stream().map(featureTypeRelationKey -> {
                        FeatureTypeRelationKey tmp = new FeatureTypeRelationKey();
                        tmp.setLeftSide(featureTypeRelationKey.getRightSide());
                        tmp.setRightSide(featureTypeRelationKey.getLeftSide());
                        return tmp;
                    }).collect(Collectors.toList()));
                    atomRel.set(switched);
                }
            }
            if (atomRel.get() == null) {
                throw new CQLException("featuretypes do not have a relation");
            }
            return (FeatureTypeRelation)atomRel.get();
        }
        catch (NumberFormatException nfe) {
            throw new CQLException("Related layer filter incorrectly formed. Ids are not parsable to Longs. Must be of form: RELATED_LAYER(<LAYERID_MAIN>, <SIMPLEFEATURETYPEID_SUB>, <FILTER>)");
        }
    }

    private static String replaceRelatedFilter(String filter, EntityManager em) throws CQLException {
        FeatureTypeRelation relation = TailormapCQL.retrieveFeatureTypeRelation(filter, em);
        FeatureTypeRelationKey key = (FeatureTypeRelationKey)relation.getRelationKeys().get(0);
        String relatedFilter = TailormapCQL.retrieveRelatedFilter(filter);
        List<Object> ids = TailormapCQL.getFIDSFromRelatedFeatures(relation.getForeignFeatureType(), relatedFilter, key.getRightSide().getName(), em);
        if (ids.isEmpty()) {
            String cql = "1 = 0";
            return cql;
        }
        Object cql = key.getLeftSide().getName();
        cql = (String)cql + " IN (";
        String cs = ",";
        String escapChar = key.getLeftSide().getType().equals("string") ? "'" : "";
        for (Object id : ids) {
            cql = (String)cql + escapChar + id + escapChar + ",";
        }
        cql = ((String)cql).substring(0, ((String)cql).length() - 1);
        cql = (String)cql + ")";
        return cql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Object> getFIDSFromRelatedFeatures(SimpleFeatureType sft, String filter, String column, EntityManager em) {
        ArrayList<Object> arrayList;
        ArrayList<Object> fids = new ArrayList<Object>();
        FeatureSource fs = FeatureSourceFactoryHelper.openGeoToolsFeatureSource((SimpleFeatureType)sft);
        Query q = new Query(fs.getName().toString());
        if (filter != null && !filter.isEmpty()) {
            Filter attributeFilter = TailormapCQL.toFilter(filter, em);
            attributeFilter = (Filter)attributeFilter.accept((FilterVisitor)new ChangeMatchCase(false), null);
            q.setFilter(attributeFilter);
        }
        q.setMaxFeatures(1000);
        FeatureIterator it = fs.getFeatures(q).features();
        try {
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                fids.add(f.getAttribute(column));
            }
            arrayList = fids;
        }
        catch (Throwable throwable) {
            try {
                it.close();
                fs.getDataStore().dispose();
                throw throwable;
            }
            catch (Exception ex) {
                LOG.error((Object)("retrieving fids for RELATED_LAYER filter in TailormapCQL failed: " + ex));
                return fids;
            }
        }
        it.close();
        fs.getDataStore().dispose();
        return arrayList;
    }

    private static String replaceApplayerFilter(String filter, EntityManager em) throws CQLException {
        int begin = filter.indexOf(BEGIN_APPLAYER_PART);
        int startIndex = begin + BEGIN_APPLAYER_PART.length();
        int closingBrackets = 0;
        int openBrackets = 1;
        int endIndex = 0;
        for (int i = startIndex; i < filter.length(); ++i) {
            char c = filter.charAt(i);
            if (c == '(') {
                ++openBrackets;
            }
            if (c == ')') {
                ++closingBrackets;
            }
            if (openBrackets != closingBrackets) continue;
            endIndex = i;
            break;
        }
        String appLayerPart = filter.substring(startIndex, endIndex);
        appLayerPart = TailormapCQL.processFilter(appLayerPart, em);
        String geometryFilter = TailormapCQL.rewriteAppLayerFilter(appLayerPart, em);
        String beginpart = filter.substring(0, begin);
        String endpart = filter.substring(endIndex + 1);
        String result = beginpart + geometryFilter + endpart;
        return result;
    }

    private static String rewriteAppLayerFilter(String applayerfilter, EntityManager em) throws CQLException {
        int firstIndex = applayerfilter.indexOf(", ");
        int secondIndex = applayerfilter.indexOf(",", firstIndex + 1);
        String attribute = applayerfilter.substring(0, firstIndex);
        String appLayerId = applayerfilter.substring(firstIndex + 1, secondIndex);
        String filter = applayerfilter.substring(secondIndex + 1);
        filter = filter.trim();
        appLayerId = appLayerId.trim();
        Long id = Long.parseLong(appLayerId);
        String geom = TailormapCQL.getUnionedFeatures(filter, id, em);
        String nieuwFilter = "intersects (" + attribute + ", " + geom + ")";
        return nieuwFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUnionedFeatures(String filter, Long appLayerId, EntityManager em) throws CQLException {
        String string;
        ApplicationLayer al = (ApplicationLayer)em.find(ApplicationLayer.class, (Object)appLayerId);
        GeoService gs = al.getService();
        Layer l = gs.getLayer(al.getLayerName(), em);
        if (l.getFeatureType() == null) {
            throw new Exception("Layer has no feature type");
        }
        FeatureSource fs = FeatureSourceFactoryHelper.openGeoToolsFeatureSource((SimpleFeatureType)l.getFeatureType());
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(), 28992);
        Query q = new Query(fs.getName().toString());
        if (filter != null && !filter.isEmpty()) {
            Filter attributeFilter = ECQL.toFilter((String)filter);
            attributeFilter = (Filter)attributeFilter.accept((FilterVisitor)new ChangeMatchCase(false), null);
            q.setFilter(attributeFilter);
        }
        q.setMaxFeatures(1000);
        FeatureIterator it = fs.getFeatures(q).features();
        try {
            GeometryCollection gc = new GeometryCollection(null, gf);
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                Geometry g = (Geometry)f.getDefaultGeometry();
                if (g == null) continue;
                gc = gc.union(g);
            }
            string = gc.union().toText();
        }
        catch (Throwable throwable) {
            try {
                it.close();
                fs.getDataStore().dispose();
                throw throwable;
            }
            catch (Exception ex) {
                LOG.error((Object)("retrieving geometry for intersects filter in TailormapCQL failed: " + ex));
                return null;
            }
        }
        it.close();
        fs.getDataStore().dispose();
        return string;
    }
}

