/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.image;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import nl.tailormap.viewer.image.Bbox;
import nl.tailormap.viewer.image.CombineImageUrl;
import nl.tailormap.viewer.image.CombineXMLBodyUrl;
import nl.tailormap.viewer.image.ImageBbox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CombineArcServerUrl
extends CombineXMLBodyUrl {
    private static final Log log = LogFactory.getLog(CombineArcServerUrl.class);
    private static XPathExpression xPathExtent;
    private static XPathExpression xPathImageDisplay;

    public CombineArcServerUrl() {
    }

    private CombineArcServerUrl(CombineArcServerUrl casu) {
        super((CombineXMLBodyUrl)casu);
    }

    public List<CombineImageUrl> calculateNewUrl(ImageBbox imbbox) {
        Integer width = imbbox.getWidth();
        Integer height = imbbox.getHeight();
        Bbox bbox = imbbox.getBbox();
        CombineArcServerUrl ciu = new CombineArcServerUrl(this);
        try {
            Document doc = this.bodyAsDocument();
            Node root = doc.getFirstChild();
            Node extent = (Node)xPathExtent.evaluate(root, XPathConstants.NODE);
            NodeList nl = extent.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node child = nl.item(i);
                if ("XMin".equals(child.getLocalName())) {
                    child.setTextContent("" + bbox.getMinx());
                    continue;
                }
                if ("YMin".equals(child.getLocalName())) {
                    child.setTextContent("" + bbox.getMiny());
                    continue;
                }
                if ("XMax".equals(child.getLocalName())) {
                    child.setTextContent("" + bbox.getMaxx());
                    continue;
                }
                if (!"YMax".equals(child.getLocalName())) continue;
                child.setTextContent("" + bbox.getMaxy());
            }
            Node imageSize = (Node)xPathImageDisplay.evaluate(root, XPathConstants.NODE);
            nl = imageSize.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node child = nl.item(i);
                if ("ImageHeight".equals(child.getLocalName())) {
                    child.setTextContent(height.toString());
                    continue;
                }
                if (!"ImageWidth".equals(child.getLocalName())) continue;
                child.setTextContent(width.toString());
            }
            ciu.setBody(doc);
        }
        catch (Exception e) {
            log.warn((Object)"Error while changing body fragment", (Throwable)e);
        }
        ArrayList<CombineImageUrl> list = new ArrayList<CombineImageUrl>();
        list.add((CombineImageUrl)ciu);
        return list;
    }

    static {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        try {
            xPathExtent = xPath.compile("//MapArea/Extent");
            xPathImageDisplay = xPath.compile("//ImageDisplay");
        }
        catch (Exception ex) {
            log.error((Object)"Error while creating xpath expr", (Throwable)ex);
        }
    }
}

