/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.image;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import nl.tailormap.viewer.image.Bbox;
import nl.tailormap.viewer.image.CombineImageSettings;
import nl.tailormap.viewer.image.CombineImageUrl;
import nl.tailormap.viewer.image.CombineStaticImageUrl;
import nl.tailormap.viewer.image.CombineWmsUrl;

/*
 * Exception performing whole class analysis ignored.
 */
public class TileServerSettings {
    private Bbox bbox = null;
    private Double[] resolutions = null;
    private Integer tileWidth = null;
    private Integer tileHeight = null;
    private String url = null;

    public List<CombineImageUrl> getTilingImages(CombineImageSettings settings) throws MalformedURLException, Exception {
        ArrayList<CombineImageUrl> tileImages = new ArrayList<CombineImageUrl>();
        Bbox requestBbox = null;
        if (settings.getBbox() != null) {
            requestBbox = settings.getBbox();
        }
        Double res = null;
        if (requestBbox != null) {
            Integer mapWidth = settings.getWidth();
            res = (requestBbox.getMaxx() - requestBbox.getMinx()) / (double)mapWidth.intValue();
        }
        Double useRes = null;
        if (this.resolutions != null) {
            for (int i = 0; i < this.resolutions.length; ++i) {
                Double testRes = this.resolutions[i];
                if (res - testRes < 1.0E-10 && res - testRes > -1.0E-10) {
                    useRes = testRes;
                    break;
                }
                if (!(res >= testRes)) continue;
                useRes = testRes;
                break;
            }
            if (useRes == null) {
                useRes = res;
            }
        }
        Integer mapWidth = null;
        Integer mapHeight = null;
        if (settings.getWidth() != null) {
            mapWidth = settings.getWidth();
        }
        if (settings.getHeight() != null) {
            mapHeight = settings.getHeight();
        }
        Double tileWidthMapUnits = null;
        Double tileHeightMapUnits = null;
        if (this.getTileWidth() != null && useRes != null) {
            tileWidthMapUnits = (double)this.getTileWidth().intValue() * useRes;
        }
        if (this.getTileWidth() != null && useRes != null) {
            tileHeightMapUnits = (double)this.getTileWidth().intValue() * useRes;
        }
        Integer minTileIndexX = null;
        Integer maxTileIndexX = null;
        Integer minTileIndexY = null;
        Integer maxTileIndexY = null;
        if (tileWidthMapUnits != null && tileWidthMapUnits > 0.0 && tileHeightMapUnits != null && tileHeightMapUnits > 0.0) {
            minTileIndexX = TileServerSettings.getTilingCoord((Double)this.bbox.getMinx(), (Double)this.bbox.getMaxx(), (Double)tileWidthMapUnits, (Double)requestBbox.getMinx());
            maxTileIndexX = TileServerSettings.getTilingCoord((Double)this.bbox.getMinx(), (Double)this.bbox.getMaxx(), (Double)tileWidthMapUnits, (Double)requestBbox.getMaxx());
            minTileIndexY = TileServerSettings.getTilingCoord((Double)this.bbox.getMiny(), (Double)this.bbox.getMaxy(), (Double)tileHeightMapUnits, (Double)requestBbox.getMiny());
            maxTileIndexY = TileServerSettings.getTilingCoord((Double)this.bbox.getMiny(), (Double)this.bbox.getMaxy(), (Double)tileHeightMapUnits, (Double)requestBbox.getMaxy());
        }
        for (int ix = minTileIndexX.intValue(); ix <= maxTileIndexX; ++ix) {
            for (int iy = minTileIndexY.intValue(); iy <= maxTileIndexY; ++iy) {
                double[] tempBbox;
                tempBbox = new double[]{this.bbox.getMinx() + (double)ix * tileWidthMapUnits, this.bbox.getMiny() + (double)iy * tileHeightMapUnits, tempBbox[0] + tileWidthMapUnits, tempBbox[1] + tileHeightMapUnits};
                Bbox tileBbox = new Bbox(tempBbox);
                CombineStaticImageUrl tile = this.calcTilePosition(mapWidth, mapHeight, tileBbox, requestBbox, ix, iy);
                String newUrl = this.createTileUrl(tile);
                CombineWmsUrl url = new CombineWmsUrl();
                url.setUrl(newUrl);
                url.setRealUrl(new URL(newUrl));
                tileImages.add((CombineImageUrl)tile);
            }
        }
        return tileImages;
    }

    public static int getTilingCoord(Double serviceMin, Double serviceMax, Double tileSizeMapUnits, Double coord) {
        double epsilon = 1.0E-8;
        Double tileIndex = 0.0;
        tileIndex = Math.floor((coord - serviceMin) / (tileSizeMapUnits + epsilon));
        if (tileIndex < 0.0) {
            tileIndex = 0.0;
        }
        Double maxBbox = Math.floor((serviceMax - serviceMin) / (tileSizeMapUnits + epsilon));
        if (tileIndex > maxBbox) {
            tileIndex = maxBbox;
        }
        return tileIndex.intValue();
    }

    public CombineStaticImageUrl calcTilePosition(Integer mapWidth, Integer mapHeight, Bbox tileBbox, Bbox requestBbox, int offsetX, int offsetY) {
        CombineStaticImageUrl tile = new CombineStaticImageUrl();
        tile.setBbox(tileBbox);
        tile.setUrl(this.url);
        Double msx = (requestBbox.getMaxx() - requestBbox.getMinx()) / (double)mapWidth.intValue();
        Double msy = (requestBbox.getMaxy() - requestBbox.getMiny()) / (double)mapHeight.intValue();
        Double posX = Math.floor((tileBbox.getMinx() - requestBbox.getMinx()) / msx);
        Double posY = Math.floor((requestBbox.getMaxy() - tileBbox.getMaxy()) / msy);
        Double width = Math.floor((tileBbox.getMaxx() - tileBbox.getMinx()) / msx);
        Double height = Math.floor((tileBbox.getMaxy() - tileBbox.getMiny()) / msy);
        tile.setX(Integer.valueOf(posX.intValue() - offsetX));
        tile.setY(Integer.valueOf(posY.intValue() + offsetY));
        tile.setWidth(Integer.valueOf(width.intValue()));
        tile.setHeight(Integer.valueOf(height.intValue()));
        return tile;
    }

    public Bbox getBbox() {
        return this.bbox;
    }

    public void setBbox(Bbox bbox) {
        this.bbox = bbox;
    }

    public Double[] getResolutions() {
        return this.resolutions;
    }

    public void setResolutions(String commaSeperatedResolutions) {
        String[] tokens = null;
        tokens = commaSeperatedResolutions.indexOf(",") > 0 ? commaSeperatedResolutions.split(",") : commaSeperatedResolutions.split(" ");
        Double[] res = new Double[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            res[i] = Double.parseDouble(tokens[i]);
        }
        this.resolutions = res;
    }

    public void setResolutions(Double[] resolutions) {
        this.resolutions = resolutions;
    }

    public Integer getTileWidth() {
        return this.tileWidth;
    }

    public void setTileWidth(Integer tileWidth) {
        this.tileWidth = tileWidth;
    }

    public Integer getTileHeight() {
        return this.tileHeight;
    }

    public void setTileHeight(Integer tileHeight) {
        this.tileHeight = tileHeight;
    }

    private String createTileUrl(CombineStaticImageUrl tile) {
        String sizes = null;
        if (this.getTileWidth() != null && this.getTileHeight() != null) {
            sizes = "&WIDTH=" + this.getTileWidth() + "&HEIGHT=" + this.getTileHeight();
        }
        String bboxString = "&BBOX=" + tile.getBbox().toString();
        String newUrl = this.url + sizes + bboxString;
        return newUrl;
    }
}

