/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.stripes;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.tailormap.i18n.ResourceBundleProvider;
import nl.tailormap.viewer.audit.AuditMessageObject;
import nl.tailormap.viewer.audit.Auditable;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.app.FileUpload;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.helpers.AuthorizationsHelper;
import nl.tailormap.viewer.stripes.FileUploadActionBean;
import nl.tailormap.viewer.stripes.LocalizableApplicationActionBean;
import nl.tailormap.web.stripes.ErrorMessageResolution;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/upload")
@StrictBinding
public class FileUploadActionBean
extends LocalizableApplicationActionBean
implements Auditable {
    private static final Log log = LogFactory.getLog(FileUploadActionBean.class);
    private ActionBeanContext context;
    public static final String DATA_DIR = "tailormap.data.dir";
    @Validate
    private List<FileBean> files;
    @Validate
    private ApplicationLayer appLayer;
    @Validate
    private Application application;
    @Validate
    private String type;
    @Validate
    private String fid;
    @Validate
    private FileUpload upload;
    private AuditMessageObject auditMessageObject;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public ApplicationLayer getAppLayer() {
        return this.appLayer;
    }

    public void setAppLayer(ApplicationLayer appLayer) {
        this.appLayer = appLayer;
    }

    public String getFid() {
        return this.fid;
    }

    public void setFid(String fid) {
        this.fid = fid;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public List<FileBean> getFiles() {
        return this.files;
    }

    public void setFiles(List<FileBean> files) {
        this.files = files;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public FileUpload getUpload() {
        return this.upload;
    }

    public void setUpload(FileUpload upload) {
        this.upload = upload;
    }

    public AuditMessageObject getAuditMessageObject() {
        return this.auditMessageObject;
    }

    @Before(stages={LifecycleStage.EventHandling})
    public void initAudit() {
        this.auditMessageObject = new AuditMessageObject();
    }

    @DefaultHandler
    public Resolution uploadFile() {
        JSONObject json = new JSONObject();
        String error = null;
        if (this.appLayer == null) {
            error = this.getBundle().getString("viewer.fileuploadactionbean.noaps");
        }
        if (error == null && !AuthorizationsHelper.isAppLayerWriteAuthorized((Application)this.application, (ApplicationLayer)this.appLayer, (HttpServletRequest)this.context.getRequest(), (EntityManager)Stripersist.getEntityManager())) {
            error = this.getBundle().getString("viewer.general.noauth");
        }
        if (error != null) {
            json.put("success", false);
            json.put("message", (Object)error);
        } else {
            String datadir = this.context.getServletContext().getInitParameter(DATA_DIR);
            if (datadir.isEmpty()) {
                json.put("success", false);
                json.put("message", (Object)this.getBundle().getString("viewer.fileuploadactionbean.badconfig"));
            } else {
                File dir = new File(datadir);
                if (dir.exists() && dir.canWrite()) {
                    Long time = System.currentTimeMillis();
                    EntityManager em = Stripersist.getEntityManager();
                    Layer layer = this.appLayer.getService().getLayer(this.appLayer.getLayerName(), em);
                    for (FileBean fb : this.files) {
                        String filename = fb.getFileName();
                        String extension = filename.substring(filename.lastIndexOf("."));
                        filename = filename.substring(0, filename.lastIndexOf("."));
                        File f = new File(dir, "uploads" + File.separator + this.appLayer.getLayerName() + "_" + this.fid + "_" + filename + "_" + time + extension);
                        try {
                            FileUtils.copyToFile((InputStream)fb.getInputStream(), (File)f);
                            if (!em.getTransaction().isActive()) {
                                em.getTransaction().begin();
                            }
                            FileUpload fu = new FileUpload();
                            fu.setCreatedAt(new Date());
                            fu.setFid(this.fid);
                            fu.setType_(this.type);
                            fu.setFilename(fb.getFileName());
                            fu.setMimetype(fb.getContentType());
                            fu.setLocation(f.getName());
                            fu.setSft(layer.getFeatureType());
                            em.persist((Object)fu);
                            em.getTransaction().commit();
                        }
                        catch (IOException e) {
                            log.error((Object)"Cannot write file", (Throwable)e);
                        }
                    }
                    json.put("success", true);
                } else {
                    json.put("success", false);
                    json.put("message", (Object)this.getBundle().getString("viewer.fileuploadactionbean.badconfig"));
                }
            }
        }
        this.auditMessageObject.addMessage((Object)json);
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
    }

    public static JSONObject retrieveUploads(String fid, ApplicationLayer appLayer, EntityManager em, Application application, HttpServletRequest request) {
        JSONObject uploads = new JSONObject();
        String error = null;
        ResourceBundle bundle = ResourceBundleProvider.getResourceBundle((Locale)request.getLocale());
        if (appLayer == null) {
            error = bundle.getString("viewer.fileuploadactionbean.1");
        }
        if (error == null && !AuthorizationsHelper.isAppLayerReadAuthorized((Application)application, (ApplicationLayer)appLayer, (HttpServletRequest)request, (EntityManager)Stripersist.getEntityManager())) {
            error = bundle.getString("viewer.fileuploadactionbean.2");
        }
        if (error == null) {
            Layer layer = appLayer.getService().getLayer(appLayer.getLayerName(), em);
            List fups = em.createQuery("FROM FileUpload WHERE sft = :sft and fid = :fid", FileUpload.class).setParameter("sft", (Object)layer.getFeatureType()).setParameter("fid", (Object)fid).getResultList();
            for (FileUpload fup : fups) {
                if (!uploads.has(fup.getType_())) {
                    uploads.put(fup.getType_(), (Object)new JSONArray());
                }
                JSONArray ar = uploads.getJSONArray(fup.getType_());
                ar.put((Object)fup.toJSON());
            }
        }
        return uploads;
    }

    public Resolution view() {
        FileUpload up = this.upload;
        String error = null;
        if (this.appLayer == null) {
            error = this.getBundle().getString("viewer.fileuploadactionbean.noaps");
        }
        if (error == null && !AuthorizationsHelper.isAppLayerReadAuthorized((Application)this.application, (ApplicationLayer)this.appLayer, (HttpServletRequest)this.context.getRequest(), (EntityManager)Stripersist.getEntityManager())) {
            error = this.getBundle().getString("viewer.general.noauth");
        }
        if (error == null) {
            String datadir = this.context.getServletContext().getInitParameter(DATA_DIR);
            File dir = new File(datadir);
            File f = new File(dir, "uploads" + File.separator + up.getLocation());
            try {
                FileInputStream fis = new FileInputStream(f);
                1 res = new /* Unavailable Anonymous Inner Class!! */;
                String name = up.getFilename();
                res.setFilename(name);
                res.setAttachment(false);
                this.auditMessageObject.addMessage((Object)f);
                return res;
            }
            catch (FileNotFoundException e) {
                log.error((Object)"Cannot retrieve file: ", (Throwable)e);
                return new ErrorMessageResolution("Cannot retrieve upload:" + e.getLocalizedMessage());
            }
        }
        log.error((Object)("User unauthorized: " + error));
        return new ErrorMessageResolution("User unauthorized: " + error);
    }

    public Resolution removeUpload() {
        String error = null;
        JSONObject json = new JSONObject();
        json.put("uploadid", (Object)this.upload.getId());
        json.put("success", false);
        if (this.appLayer == null) {
            error = this.getBundle().getString("viewer.fileuploadactionbean.noaps");
        }
        if (error == null && !AuthorizationsHelper.isAppLayerWriteAuthorized((Application)this.application, (ApplicationLayer)this.appLayer, (HttpServletRequest)this.context.getRequest(), (EntityManager)Stripersist.getEntityManager())) {
            error = this.getBundle().getString("viewer.general.noauth");
        }
        if (error == null) {
            String datadir = this.context.getServletContext().getInitParameter(DATA_DIR);
            File dir = new File(datadir);
            File f = new File(dir, "uploads" + File.separator + this.upload.getLocation());
            EntityManager em = Stripersist.getEntityManager();
            if (f.exists()) {
                boolean deleted = f.delete();
                if (deleted) {
                    json.put("success", true);
                } else {
                    log.error((Object)("Can not delete file: " + this.upload.getFilename()));
                }
            } else {
                json.put("message", (Object)this.getBundle().getString("viewer.fileuploadactionbean.nofile"));
            }
            em.remove((Object)this.upload);
            em.getTransaction().commit();
        } else {
            json.put("message", (Object)error);
        }
        this.auditMessageObject.addMessage((Object)json);
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString(4)));
    }
}

