/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.stripes;

import java.awt.geom.AffineTransform;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.WKTReader2;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.json.JSONArray;
import org.json.JSONObject;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.linearref.LengthIndexedLine;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;
import org.locationtech.jts.util.GeometricShapeFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opensphere.geometry.algorithm.ConcaveHull;

@UrlBinding(value="/action/ontbrandings")
@StrictBinding
public class OntbrandingsActionBean
implements ActionBean {
    private static final Log LOG = LogFactory.getLog(OntbrandingsActionBean.class);
    private ActionBeanContext context;
    private WKTReader2 wkt;
    private GeometryFactory gf;
    @Validate
    private String features;

    @DefaultHandler
    public Resolution calculate() throws TransformException {
        JSONObject result = new JSONObject();
        result.put("type", (Object)"calculate");
        this.gf = new GeometryFactory(new PrecisionModel(), 28992);
        this.wkt = new WKTReader2(this.gf);
        JSONArray jsonFeatures = new JSONArray(this.features);
        JSONObject mainLocation = null;
        for (JSONObject feature : jsonFeatures) {
            JSONObject attrs = feature.getJSONObject("attributes");
            if (!attrs.getString("type").equals("audienceLocation") || !attrs.getBoolean("mainLocation")) continue;
            mainLocation = feature;
            break;
        }
        JSONArray safetyZones = new JSONArray();
        JSONObject referenceLine = this.calculateReferenceLine(jsonFeatures);
        for (JSONObject feature : jsonFeatures) {
            try {
                JSONArray obs = this.calculateSafetyZone(feature, mainLocation, referenceLine);
                if (obs == null || obs.length() <= 0) continue;
                for (JSONObject g : obs) {
                    safetyZones.put((Object)g);
                }
            }
            catch (ParseException ex) {
                LOG.debug((Object)"Error calculating safetyzone: ", (Throwable)ex);
            }
        }
        result.put("safetyZones", (Object)safetyZones);
        return new StreamingResolution("application/json", (Reader)new StringReader(result.toString()));
    }

    private JSONObject calculateReferenceLine(JSONArray features) {
        JSONObject referenceLine = new JSONObject();
        try {
            ArrayList<Point> centroids = new ArrayList<Point>();
            for (JSONObject feature : features) {
                JSONObject attributes = feature.getJSONObject("attributes");
                String type = attributes.getString("type");
                if (!type.equals("ignitionLocation")) continue;
                Geometry ignition = this.wkt.read(feature.getString("wktgeom"));
                centroids.add(ignition.getCentroid());
            }
            GeometryCollection gc = new GeometryCollection(centroids.toArray(new Geometry[0]), this.gf);
            Point centerCentroid = gc.getCentroid();
            referenceLine.put("x", centerCentroid.getX());
            referenceLine.put("y", centerCentroid.getY());
        }
        catch (ParseException ex) {
            LOG.error((Object)"Cannot parse wkt for reference line", (Throwable)ex);
        }
        return referenceLine;
    }

    private JSONArray calculateSafetyZone(JSONObject feature, JSONObject mainLocation, JSONObject referenceLine) throws ParseException, TransformException {
        JSONObject attributes = feature.getJSONObject("attributes");
        String type = attributes.getString("type");
        JSONArray gs = new JSONArray();
        if (type.equals("ignitionLocation")) {
            boolean fan = false;
            fan = attributes.getString("fireworks_type").equals("consumer") ? attributes.getBoolean("zonedistance_consumer_fan") : attributes.getBoolean("zonedistance_professional_fan");
            if (fan) {
                this.calculateFan(feature, mainLocation, gs, referenceLine);
            } else {
                this.calculateNormalSafetyZone(feature, mainLocation, gs, referenceLine);
            }
        }
        return gs;
    }

    private void calculateFan(JSONObject feature, JSONObject mainLocation, JSONArray gs, JSONObject referenceLine) throws ParseException, TransformException {
        Geometry zone;
        double fanHeight;
        double fanLength;
        JSONObject attributes = feature.getJSONObject("attributes");
        if (attributes.getString("fireworks_type").equals("consumer")) {
            fanLength = attributes.getDouble("zonedistance_consumer_m") * 1.5;
            fanHeight = attributes.getDouble("zonedistance_consumer_m");
        } else {
            fanLength = attributes.getDouble("zonedistance_professional_m") * 1.5;
            fanHeight = attributes.getDouble("zonedistance_professional_m");
        }
        Geometry ignition = this.wkt.read(feature.getString("wktgeom"));
        Geometry audience = this.wkt.read(mainLocation.getString("wktgeom"));
        Geometry boundary = ignition.getBoundary();
        LineString boundaryLS = (LineString)boundary;
        LengthIndexedLine lil = new LengthIndexedLine((Geometry)boundaryLS);
        Point ignitionCentroid = ignition.getCentroid();
        Point audienceCentroid = audience.getCentroid();
        double offset = 0.1;
        int endIndex = (int)lil.getEndIndex();
        Geometry unioned = zone = this.createNormalSafetyZone(feature, ignition, fanHeight);
        double dx = ignitionCentroid.getX() - audienceCentroid.getX();
        double dy = ignitionCentroid.getY() - audienceCentroid.getY();
        double theta = Math.atan2(dy, dx);
        double correctBearing = 1.5707963267948966;
        double rotation = theta - correctBearing;
        for (double i = 0.0; i < (double)endIndex; i += offset) {
            Coordinate c = lil.extractPoint(i);
            Geometry fan = this.createEllipse(c, rotation, fanLength, fanHeight, 220);
            if (fan.isEmpty()) continue;
            unioned = unioned.union(fan);
        }
        ConcaveHull con = new ConcaveHull(unioned, fanHeight);
        Geometry g = con.getConcaveHull();
        TopologyPreservingSimplifier tp = new TopologyPreservingSimplifier(g);
        tp.setDistanceTolerance(0.5);
        if (attributes.getBoolean("showcircle")) {
            gs.put((Object)this.createFeature(tp.getResultGeometry(), "safetyZone", ""));
        }
        this.createSafetyDistances(gs, audience, ignition, g, attributes, referenceLine, true, fanLength, fanHeight);
    }

    private void createSafetyDistances(JSONArray gs, Geometry audience, Geometry ignition, Geometry safetyZone, JSONObject attributes, JSONObject referenceLine, boolean isFan, double fanLength, double fanHeight) throws TransformException {
        ignition = ignition.buffer(0.0);
        boolean showLength = attributes.getBoolean("lengthdistanceline");
        boolean showLine = attributes.getBoolean("distanceline");
        if (!showLine) {
            return;
        }
        Point audienceCentroid = audience.getCentroid();
        Point ignitionCentroid = ignition.getCentroid();
        LineString audienceIgnitionLine = this.gf.createLineString(new Coordinate[]{audienceCentroid.getCoordinate(), ignitionCentroid.getCoordinate()});
        Geometry ignitionBoundary = ignition.getBoundary();
        LineString ignitionBounds = (LineString)ignitionBoundary;
        LengthIndexedLine ignitionIndexedLine = new LengthIndexedLine((Geometry)ignitionBounds);
        int factor = 3;
        double dx = (audienceCentroid.getX() - ignitionCentroid.getX()) * (double)factor;
        double dy = (audienceCentroid.getY() - ignitionCentroid.getY()) * (double)factor;
        double epsilon = 0.01;
        Geometry distanceLine = null;
        double offset = 10.0;
        block0: for (int k = 1; k < 5 && distanceLine == null; ++k) {
            offset /= 10.0;
            for (double i = 0.0; i < ignitionIndexedLine.getEndIndex(); i += offset) {
                Geometry cuttoffTestLine;
                double l;
                double tempY;
                double tempX;
                Coordinate endTestLine;
                Coordinate ignitionTestCoord = ignitionIndexedLine.extractPoint(i);
                LineString ls = this.gf.createLineString(new Coordinate[]{ignitionTestCoord, endTestLine = new Coordinate(tempX = ignitionTestCoord.x + dx, tempY = ignitionTestCoord.y + dy)});
                if (ignition.crosses((Geometry)ls) || !((l = (cuttoffTestLine = ls.intersection(safetyZone)).getLength()) + epsilon >= fanHeight) || !(l - epsilon <= fanHeight)) continue;
                distanceLine = cuttoffTestLine;
                continue block0;
            }
        }
        if (distanceLine == null) {
            distanceLine = audienceIgnitionLine.intersection(safetyZone).difference(ignition);
        }
        double length = distanceLine.getLength();
        gs.put((Object)this.createFeature(distanceLine, "safetyDistance", (String)(showLength ? (double)Math.round(length * 10.0) / 10.0 + " m" : "")));
        double ratioX = dx / length;
        double ratioY = dy / length;
        double fanX = ratioX * -1000.0;
        double fanY = ratioY * -1000.0;
        double x = referenceLine.getDouble("x");
        double y = referenceLine.getDouble("y");
        Coordinate centerTip = new Coordinate(x, y);
        Coordinate audienceTail = audienceCentroid.getCoordinate();
        Coordinate ignitionTip = ignitionCentroid.getCoordinate();
        Point eindLoodlijn = this.gf.createPoint(new Coordinate(ignitionTip.x + fanX, ignitionTip.y + fanY));
        if (isFan) {
            double angle = Angle.angleBetweenOriented((Coordinate)centerTip, (Coordinate)audienceTail, (Coordinate)ignitionTip);
            double angleRad = Math.toRadians(angle >= 0.0 ? 90.0 : -90.0);
            Geometry foundLoodLijn = null;
            offset = 10.0;
            block2: for (int k = 1; k < 5 && foundLoodLijn == null; ++k) {
                offset /= 10.0;
                for (double i = 0.0; i < ignitionIndexedLine.getEndIndex(); i += offset) {
                    Coordinate ignitionTestCoord = ignitionIndexedLine.extractPoint(i);
                    AffineTransform affineTransform = AffineTransform.getRotateInstance(angleRad, ignitionTestCoord.x, ignitionTestCoord.y);
                    AffineTransform2D mathTransform = new AffineTransform2D(affineTransform);
                    Geometry rotatedPoint = JTS.transform((Geometry)eindLoodlijn, (MathTransform)mathTransform);
                    Coordinate[] loodLijnCoords = new Coordinate[]{ignitionTestCoord, rotatedPoint.getCoordinate()};
                    LineString loodLijn = this.gf.createLineString(loodLijnCoords);
                    Geometry cutoffLoodlijn = loodLijn.intersection(safetyZone);
                    if ((cutoffLoodlijn = cutoffLoodlijn.difference(ignition)) instanceof MultiLineString) {
                        MultiLineString ms = (MultiLineString)cutoffLoodlijn;
                        for (int j = 0; j < ms.getNumGeometries(); ++j) {
                            Geometry g = ms.getGeometryN(j);
                            double l = g.getLength();
                            if (!(l + epsilon >= fanLength) || !(l - epsilon <= fanLength)) continue;
                            cutoffLoodlijn = g;
                        }
                    }
                    if (!((length = cutoffLoodlijn.getLength()) + epsilon >= fanLength) || !(length - epsilon <= fanLength)) continue;
                    foundLoodLijn = cutoffLoodlijn;
                    continue block2;
                }
            }
            if (foundLoodLijn == null) {
                Coordinate[] endContinuousLine = new Coordinate[]{ignitionTip, eindLoodlijn.getCoordinate()};
                LineString continuousLine = this.gf.createLineString(endContinuousLine);
                Geometry cutoffContLine = continuousLine.intersection(safetyZone);
                foundLoodLijn = cutoffContLine.difference(ignition);
                length = foundLoodLijn.getLength();
            }
            gs.put((Object)this.createFeature(foundLoodLijn, "safetyDistance", (String)(showLength ? (double)Math.round(length * 10.0) / 10.0 + " m" : "")));
        }
    }

    public Geometry createEllipse(Coordinate startPoint, double rotation, double fanlength, double fanheight, int numPoints) throws TransformException {
        GeometricShapeFactory gsf = new GeometricShapeFactory(this.gf);
        gsf.setBase(new Coordinate(startPoint.x - fanlength, startPoint.y - fanheight));
        gsf.setWidth(fanlength * 2.0);
        gsf.setHeight(fanheight * 2.0);
        gsf.setNumPoints(numPoints);
        gsf.setRotation(rotation);
        Polygon ellipse = gsf.createEllipse();
        return ellipse;
    }

    private void calculateNormalSafetyZone(JSONObject feature, JSONObject audienceObj, JSONArray gs, JSONObject referenceLine) throws ParseException, TransformException {
        Geometry ignition = this.wkt.read(feature.getString("wktgeom"));
        Geometry audience = this.wkt.read(audienceObj.getString("wktgeom"));
        JSONObject attributes = feature.getJSONObject("attributes");
        double zoneDistance = attributes.getString("fireworks_type").equals("consumer") ? attributes.getDouble("zonedistance_consumer_m") : attributes.getDouble("zonedistance_professional_m");
        Geometry zone = this.createNormalSafetyZone(feature, ignition, zoneDistance);
        if (attributes.getBoolean("showcircle")) {
            gs.put((Object)this.createFeature(zone, "safetyZone", ""));
        }
        this.createSafetyDistances(gs, audience, ignition, zone, attributes, referenceLine, false, zoneDistance, zoneDistance);
    }

    private Geometry createNormalSafetyZone(JSONObject feature, Geometry ignition, double zoneDistance) throws ParseException {
        Geometry zone = ignition.buffer(zoneDistance);
        return zone;
    }

    private JSONObject createFeature(Geometry geom, String type, String label) {
        JSONObject feat = new JSONObject();
        JSONObject attrs = new JSONObject();
        feat.put("attributes", (Object)attrs);
        feat.put("wktgeom", (Object)geom.toText());
        attrs.put("type", (Object)type);
        attrs.put("label", (Object)label);
        return feat;
    }

    public Resolution print() {
        JSONObject result = new JSONObject();
        result.put("type", (Object)"print");
        return new StreamingResolution("application/json", (Reader)new StringReader(result.toString()));
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getFeatures() {
        return this.features;
    }

    public void setFeatures(String features) {
        this.features = features;
    }
}

