/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.stripes;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.tailormap.commons.HttpClientConfigured;
import nl.tailormap.viewer.audit.AuditMessageObject;
import nl.tailormap.viewer.audit.Auditable;
import nl.tailormap.viewer.stripes.ProxyActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/proxyrest")
@StrictBinding
public class ProxyRESTActionBean
implements ActionBean,
Auditable {
    private Map<String, String> endpoints;
    private static final Log log = LogFactory.getLog(ProxyActionBean.class);
    private ActionBeanContext context;
    private AuditMessageObject auditMessageObject;
    @Validate
    private String url;
    @Validate
    private String endpoint = "0";
    private boolean unauthorized;

    @Before(stages={LifecycleStage.EventHandling})
    public void checkAuthorization() {
        HttpServletRequest request = this.getContext().getRequest();
        HttpSession sess = request.getSession(false);
        if (sess == null || this.url == null || request.getRemoteUser() == null) {
            this.unauthorized = true;
        }
    }

    @Before(stages={LifecycleStage.EventHandling})
    public void initEndpoints() {
        String[] eps;
        this.endpoints = new HashMap();
        String config = this.context.getServletContext().getInitParameter("tailormap.restproxy.endpoints");
        for (String ep : eps = config.split(";")) {
            if (ep.isEmpty()) continue;
            int splitter = ep.indexOf("=");
            String id = ep.substring(0, splitter);
            String contextPath = ep.substring(splitter + 1);
            this.endpoints.put(id, contextPath);
        }
    }

    @DefaultHandler
    public Resolution proxy() throws IOException, URISyntaxException {
        HttpServletRequest request = this.getContext().getRequest();
        HttpSession sess = request.getSession(false);
        if (this.unauthorized) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        if (!this.endpoints.containsKey(this.endpoint)) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        EntityManager em = Stripersist.getEntityManager();
        URL theUrl = this.constructURL();
        HttpClientConfigured client = this.getHttpClient(theUrl, em);
        HttpUriRequest req = this.getHttpRequest(theUrl);
        req.setHeader("X-Remote-User", request.getUserPrincipal().getName());
        try {
            HttpResponse response = client.execute(req);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode >= 200 && statusCode < 300) {
                HttpResponse finalResponse = response;
                HttpEntity entity = response.getEntity();
                return new /* Unavailable Anonymous Inner Class!! */;
            }
            return new ErrorResolution(statusCode, "Service returned: " + response.getStatusLine().getReasonPhrase());
        }
        catch (IOException e) {
            log.error((Object)"Failed to write output:", (Throwable)e);
            return null;
        }
    }

    private URL constructURL() throws MalformedURLException {
        HttpServletRequest request = this.getContext().getRequest();
        Object parentId = "";
        if (request.getParameter("parentId") != null) {
            parentId = "?parentId=" + request.getParameter("parentId");
        }
        URL requestUrl = new URL(this.context.getRequest().getRequestURL().toString());
        String host = this.context.getServletContext().getInitParameter("flamingo.restproxy.host");
        String port = this.context.getServletContext().getInitParameter("flamingo.restproxy.port");
        String constructedURL = "http://" + (host != null ? host : "localhost") + ":" + (port != null ? port : "8084") + "/" + (String)this.endpoints.get(this.endpoint) + this.url + (String)parentId;
        URL u = new URL(constructedURL);
        return u;
    }

    public HttpClientConfigured getHttpClient(URL theUrl, EntityManager em) {
        String username = null;
        String password = null;
        HttpClientConfigured client = new HttpClientConfigured(username, password, theUrl.toString());
        return client;
    }

    public HttpUriRequest getHttpRequest(URL url) throws URISyntaxException, IOException {
        HttpGet req = null;
        HttpServletRequest request = this.context.getRequest();
        InputStreamEntity entity = new InputStreamEntity((InputStream)request.getInputStream());
        entity.setContentEncoding(request.getCharacterEncoding());
        entity.setContentType("application/json");
        switch (request.getMethod()) {
            case "GET": {
                req = new HttpGet(url.toURI());
                break;
            }
            case "POST": {
                HttpPost post = new HttpPost(url.toURI());
                post.setEntity((HttpEntity)entity);
                req = post;
                break;
            }
            case "PUT": {
                HttpPut put = new HttpPut(url.toURI());
                put.setEntity((HttpEntity)entity);
                req = put;
                break;
            }
            case "DELETE": {
                req = new HttpDelete(url.toURI());
            }
        }
        return req;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public AuditMessageObject getAuditMessageObject() {
        return this.auditMessageObject;
    }

    public void setAuditMessageObject(AuditMessageObject auditMessageObject) {
        this.auditMessageObject = auditMessageObject;
    }

    @Before(stages={LifecycleStage.EventHandling})
    public void initAudit() {
        this.auditMessageObject = new AuditMessageObject();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }
}

