/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.util;

import java.util.ArrayList;
import nl.tailormap.viewer.config.services.AttributeDescriptor;
import nl.tailormap.viewer.config.services.FeatureTypeRelation;
import nl.tailormap.viewer.config.services.FeatureTypeRelationKey;
import nl.tailormap.viewer.config.services.SimpleFeatureType;
import nl.tailormap.viewer.util.ValidFilterExtractor;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

/*
 * Exception performing whole class analysis ignored.
 */
public class FilterHelper {
    private static FilterFactory2 ff2 = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());

    public static Filter reformatFilter(Filter filter, SimpleFeatureType ft) throws Exception {
        return FilterHelper.reformatFilter((Filter)filter, (SimpleFeatureType)ft, (boolean)true);
    }

    public static Filter reformatFilter(Filter filter, SimpleFeatureType ft, boolean includeRelations) throws Exception {
        if (Filter.INCLUDE.equals(filter) || Filter.EXCLUDE.equals(filter)) {
            return filter;
        }
        if (includeRelations) {
            for (FeatureTypeRelation rel : ft.getRelations()) {
                if (!"join".equals(rel.getType())) continue;
                filter = FilterHelper.reformatFilter((Filter)filter, (SimpleFeatureType)rel.getForeignFeatureType(), (boolean)includeRelations);
                filter = (Filter)filter.accept((FilterVisitor)new ValidFilterExtractor(rel), (Object)filter);
            }
        }
        filter = (Filter)filter.accept((FilterVisitor)new SimplifyingFilterVisitor(), null);
        return filter;
    }

    static Filter createFilter(SimpleFeature feature, FeatureTypeRelation rel) {
        ArrayList<Object> filters = new ArrayList<Object>();
        for (FeatureTypeRelationKey key : rel.getRelationKeys()) {
            AttributeDescriptor rightSide = key.getRightSide();
            AttributeDescriptor leftSide = key.getLeftSide();
            Object value = feature.getAttribute(leftSide.getName());
            if (value == null) continue;
            if (AttributeDescriptor.GEOMETRY_TYPES.contains(rightSide.getType()) && AttributeDescriptor.GEOMETRY_TYPES.contains(leftSide.getType())) {
                filters.add(ff2.not((Filter)ff2.isNull((Expression)ff2.property(rightSide.getName()))));
                filters.add(ff2.intersects((Expression)ff2.property(rightSide.getName()), (Expression)ff2.literal(value)));
                continue;
            }
            filters.add(ff2.equals((Expression)ff2.property(rightSide.getName()), (Expression)ff2.literal(value)));
        }
        if (filters.size() > 1) {
            return ff2.and(filters);
        }
        if (filters.size() == 1) {
            return (Filter)filters.get(0);
        }
        return null;
    }

    public static void setSortBy(Query q, String sort, String dir) {
        if (sort != null) {
            q.setSortBy(new SortBy[]{ff2.sort(sort, "DESC".equals(dir) ? SortOrder.DESCENDING : SortOrder.ASCENDING)});
        }
    }
}

