/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.image;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import nl.tailormap.viewer.config.services.TileMatrix;
import nl.tailormap.viewer.config.services.TileMatrixSet;
import nl.tailormap.viewer.helpers.services.TilingServiceHelper;
import nl.tailormap.viewer.image.Bbox;
import nl.tailormap.viewer.image.CombineImageUrl;
import nl.tailormap.viewer.image.CombineStaticImageUrl;
import nl.tailormap.viewer.image.CombineTileImageUrl;
import nl.tailormap.viewer.image.ImageBbox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

public class CombineWMTSUrl_old
extends CombineTileImageUrl {
    private static final Log log = LogFactory.getLog(CombineTileImageUrl.class);
    private TileMatrixSet set;

    public List<CombineImageUrl> calculateNewUrl(ImageBbox requestBbox) {
        ArrayList<CombineImageUrl> urls = new ArrayList<CombineImageUrl>();
        int tilematrixindex = this.getClosestZoomlevel(requestBbox);
        TileMatrix tm = (TileMatrix)this.set.getMatrices().get(tilematrixindex);
        Double pixelSpan = Double.valueOf(tm.getScaleDenominator()) * 2.8E-4 / TilingServiceHelper.metersPerUnit((String)tm.getMatrixSet().getCrs());
        double tileWidthInMeters = (double)tm.getTileWidth() * pixelSpan;
        double tileHeightInMeters = (double)tm.getTileHeight() * pixelSpan;
        Bbox imbbox = requestBbox.getBbox();
        String topleft = tm.getTopLeftCorner();
        double tileMatrixMinX = Double.valueOf(topleft.substring(0, topleft.indexOf(" ")));
        double tileMatrixMaxY = Double.valueOf(topleft.substring(topleft.indexOf(" ") + 1));
        double tileMatrixMinY = tileMatrixMaxY - (double)tm.getMatrixHeight() * tileHeightInMeters;
        double tileMatrixMaxX = tileMatrixMinX + (double)tm.getMatrixWidth() * tileWidthInMeters;
        double tileSpanX = (double)tm.getTileWidth() * pixelSpan;
        double tileSpanY = (double)tm.getTileWidth() * pixelSpan;
        double epsilon = 1.0E-6;
        int tileMinCol = (int)(Math.floor(imbbox.getMinx() - tileMatrixMinX) / (tileSpanX + epsilon));
        int tileMaxCol = (int)(Math.floor(imbbox.getMaxx() - tileMatrixMinX) / (tileSpanX - epsilon));
        int tileMinRow = (int)Math.floor((tileMatrixMaxY - imbbox.getMaxy()) / (tileSpanY + epsilon));
        int tileMaxRow = (int)Math.floor((tileMatrixMaxY - imbbox.getMiny()) / (tileSpanY - epsilon));
        if (tileMinCol < 0) {
            tileMinCol = 0;
        }
        if (tileMaxCol >= tm.getMatrixWidth()) {
            tileMaxCol = tm.getMatrixWidth() - 1;
        }
        if (tileMinRow < 0) {
            tileMinRow = 0;
        }
        if (tileMaxRow >= tm.getMatrixHeight()) {
            tileMaxRow = tm.getMatrixHeight() - 1;
        }
        int imgX = 0;
        int imgY = 0;
        for (int x = tileMinCol; x <= tileMaxCol; ++x) {
            for (int y = tileMinRow; y <= tileMaxRow; ++y) {
                double tileMinX = tileMatrixMinX + (double)x * tileWidthInMeters;
                double tileMinY = tileMatrixMinY + (double)y * tileHeightInMeters;
                double tileMaxX = tileMinX + tileWidthInMeters;
                double tileMaxY = tileMinY + tileHeightInMeters;
                Bbox tileBbox = new Bbox(tileMinX, tileMinY, tileMaxX, tileMaxY);
                CombineStaticImageUrl tile = this.createTile(requestBbox, tileBbox, x, y, tilematrixindex, imgX, imgY);
                urls.add((CombineImageUrl)tile);
                ++imgY;
            }
            imgY = 0;
            ++imgX;
        }
        return urls;
    }

    public CombineStaticImageUrl createTile(ImageBbox imageBbox, Bbox tileBbox, int tileIndexX, int tileIndexY, int zoomlevel, int imgIndexX, int imgIndexY) {
        CombineStaticImageUrl img = new CombineStaticImageUrl();
        String url = this.createUrl(imageBbox, tileBbox, imgIndexX, imgIndexY, zoomlevel);
        log.error((Object)("Image: " + imgIndexX + " - " + imgIndexY + " : " + url));
        TileMatrix tm = (TileMatrix)this.set.getMatrices().get(zoomlevel);
        int tileWidth = tm.getTileWidth();
        int tileHeight = tm.getTileHeight();
        int x = imgIndexX * tileWidth;
        int y = imgIndexY * tileHeight;
        img.setX(Integer.valueOf(x));
        img.setY(Integer.valueOf(y));
        img.setUrl(url);
        img.setAlpha(this.getAlpha());
        img.setBbox(tileBbox);
        img.setWidth(Integer.valueOf(tileWidth));
        img.setHeight(Integer.valueOf(tileHeight));
        return img;
    }

    protected String createUrl(ImageBbox imageBbox, Bbox tileBbox, int indexX, int indexY, int zoomlevel) {
        try {
            TileMatrix tm = (TileMatrix)this.set.getMatrices().get(zoomlevel);
            String tileUrl = this.url + "request=GetTile&version=1.0.0&format=image/png&SERVICE=WMTS&layer=brtachtergrondkaart&TileMatrixSet=" + URLEncoder.encode(this.set.getIdentifier(), "UTF-8") + "&TileRow=" + indexY + "&TileCol=" + indexX + "&TileMatrix=" + URLEncoder.encode(tm.getIdentifier(), "UTF-8");
            return tileUrl;
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)("Cannot encode identifier:" + ex));
            return null;
        }
    }

    public void setMatrixSet(JSONObject matrixSet) {
        this.set = TileMatrixSet.fromJSONObject((JSONObject)matrixSet);
    }

    public Integer getClosestZoomlevel(ImageBbox requestBbox) {
        double res = requestBbox.getUnitsPixelX();
        int dpi = 72;
        double dpm = 0.0254;
        double scale = res * ((double)dpi / dpm);
        List matrices = this.set.getMatrices();
        int index = -1;
        for (int i = 0; i < matrices.size(); ++i) {
            TileMatrix tm = (TileMatrix)matrices.get(i);
            TileMatrix next = (TileMatrix)matrices.get(i + 1);
            double scCur = Double.valueOf(tm.getScaleDenominator());
            double scNext = Double.valueOf(next.getScaleDenominator());
            if (!(scale < scCur) || !(scale > scNext)) continue;
            index = i;
            break;
        }
        return index;
    }
}

