/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.print;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.sourceforge.stripes.action.RedirectResolution;
import nl.tailormap.viewer.print.PrintInfo;
import nl.tailormap.viewer.stripes.CombineImageActionBean;
import nl.tailormap.viewer.stripes.PrintActionBean;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class PrintUtil {
    private static final Log LOG = LogFactory.getLog(PrintUtil.class);

    public static String getOverviewUrl(String params, String url, String sessionID, String ssosessionID) throws JSONException, Exception {
        JSONObject info = new JSONObject(params);
        info.remove("requests");
        info.remove("geometries");
        info.remove("quality");
        JSONObject overview = info.getJSONObject("overview");
        info.put("bbox", overview.get("extent"));
        JSONArray reqs = new JSONArray();
        JSONObject image = new JSONObject();
        image.put("protocol", (Object)overview.optString("protocol", "WMS"));
        image.put("url", overview.get("overviewUrl"));
        image.put("extent", overview.get("extent"));
        reqs.put((Object)image);
        info.put("requests", (Object)reqs);
        String overviewUrl = PrintUtil.getImageUrl((String)info.toString(), (String)url, (String)sessionID, (String)ssosessionID);
        return overviewUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageUrl(String param, String url, String sessionID, String ssosessionID) throws Exception {
        RedirectResolution cia = new RedirectResolution(CombineImageActionBean.class);
        RedirectResolution pa = new RedirectResolution(PrintActionBean.class);
        url = ((String)url).replace(pa.getUrl(new Locale("NL")), cia.getUrl(new Locale("NL")));
        url = (String)url + ";jsessionid=" + sessionID;
        HttpClient client = new HttpClient();
        PostMethod method = null;
        try {
            int statusCode;
            method = new PostMethod((String)url);
            method.addParameter("params", param);
            method.addParameter("JSESSIONID", sessionID);
            if (ssosessionID != null) {
                method.addParameter("JSESSIONIDSSO", ssosessionID);
                Header cookieHeader = new Header("Cookie", null);
                cookieHeader.setValue("JSESSIONIDSSO=" + ssosessionID);
                method.setRequestHeader(cookieHeader);
            }
            if ((statusCode = client.executeMethod((HttpMethod)method)) != 200) {
                LOG.debug((Object)("Connection error for " + (String)url));
                throw new Exception("Error connecting to server. HTTP status code: " + statusCode);
            }
            JSONObject response = new JSONObject(method.getResponseBodyAsString());
            if (!response.getBoolean("success")) {
                throw new Exception("Error getting image: " + response.getString("error"));
            }
            String string = response.getString("imageUrl");
            return string;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public static String printInfoToString(PrintInfo info) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{PrintInfo.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter sw = new StringWriter();
        m.marshal((Object)info, (Writer)sw);
        String s = sw.toString();
        return s;
    }

    private PrintUtil() {
    }
}

