/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.stripes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.Bookmark;
import nl.tailormap.viewer.helpers.app.ApplicationHelper;
import nl.tailormap.viewer.stripes.ApplicationActionBean;
import nl.tailormap.viewer.stripes.LocalizableApplicationActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.owasp.encoder.Encode;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/bookmark")
@StrictBinding
public class BookmarkActionBean
extends LocalizableApplicationActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(BookmarkActionBean.class);
    private ActionBeanContext context;
    @Validate
    private Application application;
    @Validate
    @ValidateNestedProperties(value={@Validate(field="params", required=true, on={"create"}), @Validate(field="code", required=true, on={"load"})})
    private Bookmark bookmark;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public Bookmark getBookmark() {
        return this.bookmark;
    }

    public void setBookmark(Bookmark bookmark) {
        this.bookmark = bookmark;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Resolution create() throws JSONException {
        Object error;
        JSONObject json;
        block9: {
            json = new JSONObject();
            json.put("success", (Object)Boolean.FALSE);
            error = null;
            EntityManager em = Stripersist.getEntityManager();
            Resolution r = ApplicationActionBean.checkRestriction((ActionBeanContext)this.context, (Application)this.application, (EntityManager)em);
            if (r != null) {
                error = this.getBundle().getString("viewer.bookmarkactionbean.1");
            } else if (this.bookmark == null || this.bookmark.getParams() == null) {
                error = this.getBundle().getString("viewer.bookmarkactionbean.2");
            } else {
                try {
                    String createdBy = ApplicationHelper.createCreatedBy((ActionBeanContext)this.context);
                    UUID uuid = UUID.randomUUID();
                    String code = uuid.toString();
                    code = code.replaceAll("-", "");
                    this.bookmark.setCreatedBy(createdBy);
                    this.bookmark.setCreatedAt(new Date());
                    this.bookmark.setApplication(this.application);
                    this.bookmark.setCode(code);
                    String cleanedParams = this.processParams(this.bookmark.getParams());
                    if (cleanedParams == null) {
                        error = "Cannot clean bookmark input, aborting.";
                    } else {
                        this.bookmark.setParams(cleanedParams);
                        em.persist((Object)this.bookmark);
                        em.getTransaction().commit();
                        log.debug((Object)("Bookmark created with code " + this.bookmark.getCode() + " and params " + this.bookmark.getParams()));
                        json.put("bookmark", (Object)this.bookmark.getCode());
                        json.put("success", (Object)Boolean.TRUE);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error creating bookmark", (Throwable)e);
                    error = e.toString();
                    if (e.getCause() == null) break block9;
                    error = (String)error + "; cause: " + e.getCause().toString();
                }
            }
        }
        if (error != null) {
            json.put("error", error);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    private String processParams(String params) {
        ObjectMapper mapper = JsonMapper.builder().enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER}).build();
        try {
            JsonNode actualObj = mapper.readTree(params);
            JsonNode cleaned = this.clean(actualObj);
            return cleaned.isEmpty() ? null : cleaned.toString();
        }
        catch (JsonProcessingException e) {
            log.error((Object)"Cannot clean parameters: ", (Throwable)e);
            return null;
        }
    }

    private JsonNode clean(JsonNode node) {
        if (node.isValueNode()) {
            if (JsonNodeType.STRING == node.getNodeType()) {
                return JsonNodeFactory.instance.textNode(Encode.forHtml((String)node.asText()));
            }
            return node;
        }
        if (node.isObject()) {
            ObjectNode clean = JsonNodeFactory.instance.objectNode();
            Iterator it = node.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                clean.set(Encode.forHtml((String)((String)entry.getKey())), this.clean((JsonNode)entry.getValue()));
            }
            return clean;
        }
        ArrayNode clean = JsonNodeFactory.instance.arrayNode();
        for (JsonNode jsonNode : node) {
            clean.add(this.clean(jsonNode));
        }
        return clean;
    }

    @After(on={"load"}, stages={LifecycleStage.BindingAndValidation})
    private void loadEntities() {
        EntityManager em = Stripersist.getEntityManager();
        List bms = em.createQuery("FROM Bookmark WHERE application = :app and code = :code", Bookmark.class).setParameter("app", (Object)this.application).setParameter("code", (Object)this.bookmark.getCode()).getResultList();
        if (bms.isEmpty()) {
            bms = em.createQuery("FROM Bookmark WHERE code = :code", Bookmark.class).setParameter("code", (Object)this.bookmark.getCode()).getResultList();
        }
        if (!bms.isEmpty()) {
            this.bookmark = (Bookmark)bms.get(0);
        }
    }

    public Resolution load() throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        JSONObject json = new JSONObject();
        Resolution r = ApplicationActionBean.checkRestriction((ActionBeanContext)this.context, (Application)this.application, (EntityManager)em);
        if (r != null) {
            return r;
        }
        if (this.bookmark == null || this.bookmark.getCode() == null) {
            json.put("success", (Object)Boolean.FALSE);
            json.put("error", (Object)"Can't find bookmark");
        } else {
            json.put("success", (Object)Boolean.TRUE);
            json.put("params", (Object)this.bookmark.getParams());
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }
}

