/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.tailormap.i18n.LocalizableActionBean;
import nl.tailormap.viewer.config.services.ArcGISService;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.config.services.TileService;
import nl.tailormap.viewer.config.services.WMSService;
import nl.tailormap.viewer.helpers.services.ArcGISServiceHelper;
import nl.tailormap.viewer.helpers.services.GeoServiceHelper;
import nl.tailormap.viewer.helpers.services.TilingServiceHelper;
import nl.tailormap.viewer.helpers.services.WMSServiceHelper;
import nl.tailormap.web.WaitPageStatus;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/service/info")
@StrictBinding
public class ServiceActionBean
extends LocalizableActionBean
implements ActionBean {
    private ActionBeanContext context;
    @Validate
    private String protocol;
    @Validate
    private String url;
    @Validate
    private String serviceName;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Resolution info() throws JSONException {
        EntityManager em;
        WMSService service;
        Object error;
        JSONObject json;
        block14: {
            json = new JSONObject();
            json.put("success", (Object)Boolean.FALSE);
            error = null;
            service = null;
            em = Stripersist.getEntityManager();
            if (this.protocol == null || this.url == null) {
                error = this.getBundle().getString("viewer.serviceactionbean.1");
            } else {
                HashMap params = new HashMap();
                try {
                    if (this.protocol.equals("wms")) {
                        service = WMSServiceHelper.loadFromUrl((String)this.url, params, (WaitPageStatus)new WaitPageStatus(), (EntityManager)em);
                    } else if (this.protocol.equals("arcgis")) {
                        service = ArcGISServiceHelper.loadFromUrl((String)this.url, params, (WaitPageStatus)new WaitPageStatus(), (EntityManager)em);
                    } else {
                        error = this.getBundle().getString("viewer.serviceactionbean.2");
                    }
                }
                catch (Exception e) {
                    error = "Error loading service " + e.toString();
                    if (e.getCause() == null) break block14;
                    error = (String)error + "; cause: " + e.getCause().toString();
                }
            }
        }
        if (service != null) {
            json.put("success", (Object)Boolean.TRUE);
            if (service instanceof TileService) {
                json.put("service", (Object)TilingServiceHelper.toJSONObject((TileService)((TileService)service), (boolean)true, null, (boolean)false, (boolean)false, (EntityManager)em));
            } else if (service instanceof ArcGISService) {
                json.put("service", (Object)ArcGISServiceHelper.toJSONObject((ArcGISService)((ArcGISService)service), (boolean)true, null, (boolean)false, (boolean)false, (EntityManager)em));
            } else {
                json.put("service", (Object)GeoServiceHelper.toJSONObject((GeoService)service, (boolean)true, null, (boolean)false, (boolean)false, (EntityManager)em));
            }
        } else {
            json.put("success", (Object)Boolean.FALSE);
            json.put("error", error);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }
}

