/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.stripes;

import java.io.IOException;
import java.security.Principal;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationErrorHandler;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import net.sourceforge.stripes.validation.ValidationState;
import nl.tailormap.i18n.LocalizableActionBean;
import nl.tailormap.viewer.audit.AuditMessageObject;
import nl.tailormap.viewer.audit.Auditable;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.helpers.app.ApplicationLayerHelper;
import nl.tailormap.viewer.helpers.services.GeoServiceHelper;
import nl.tailormap.viewer.userlayer.UserLayerHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.filter.text.cql2.CQLException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/userlayer/{$event}/{application}/{appLayer}")
@StrictBinding
public class UserLayerActionBean
extends LocalizableActionBean
implements ActionBean,
ValidationErrorHandler,
Auditable {
    private static final Log LOG = LogFactory.getLog(UserLayerActionBean.class);
    private ActionBeanContext context;
    @Validate(required=true)
    private Application application;
    @Validate(required=true)
    private ApplicationLayer appLayer;
    @Validate(required=true, on={"add"})
    private String query;
    @Validate(required=true, on={"add"})
    private String title;
    @Validate(required=true, on={"put"})
    private String style;
    private AuditMessageObject auditMessageObject;
    private boolean unauthorized;
    private String wellKnownUserLayerWorkspaceName;
    private String wellKnownUserLayerStoreName;

    @ValidationMethod(when=ValidationState.NO_ERRORS)
    public void validateUser(ValidationErrors errors) {
        Principal p = this.context.getRequest().getUserPrincipal();
        if (p != null) {
            this.auditMessageObject.setUsername(p.getName());
            this.auditMessageObject.setEvent(this.context.getEventName() + " userlayer");
        }
    }

    @Before(stages={LifecycleStage.EventHandling})
    public void checkLayerAndAuthorization() {
        if (this.application == null || this.appLayer == null) {
            this.unauthorized = true;
        }
    }

    @Before(stages={LifecycleStage.BindingAndValidation})
    public void initializeAuditMessageObject() {
        this.auditMessageObject = new AuditMessageObject();
    }

    @Before(stages={LifecycleStage.EventHandling})
    public void readContextParams() {
        this.wellKnownUserLayerStoreName = this.getContext().getServletContext().getInitParameter("userlayer.geoserver.store");
        this.wellKnownUserLayerWorkspaceName = this.getContext().getServletContext().getInitParameter("userlayer.geoserver.workspace");
    }

    public Resolution handleValidationErrors(ValidationErrors errors) {
        StringBuilder msg = new StringBuilder("Validatiefouten: ");
        JSONObject json = new JSONObject().put("success", (Object)Boolean.FALSE);
        if (errors.hasFieldErrors()) {
            errors.entrySet().stream().forEach(entry -> ((List)entry.getValue()).stream().map(e -> {
                if (LOG.isTraceEnabled()) {
                    msg.append("veld: ").append((String)entry.getKey()).append(", waarde: ");
                    msg.append(e.getFieldValue()).append(", melding: ");
                }
                return e;
            }).forEach(e -> msg.append(e.getMessage(Locale.ROOT)).append("; ")));
        }
        if (errors.get((Object)"__stripes_global_error") != null) {
            ((List)errors.get((Object)"__stripes_global_error")).stream().forEach(e -> msg.append(e.getMessage(Locale.ROOT)));
        }
        json.put("error", (Object)msg.toString());
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @DefaultHandler
    public Resolution noop() {
        JSONObject json = new JSONObject().put("success", (Object)Boolean.FALSE);
        json.put("error", (Object)"invalid request");
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Resolution validate() throws FilterToSQLException, CQLException, IOException {
        UserLayerHandler ulh = new UserLayerHandler(this.auditMessageObject, Stripersist.getEntityManager(), this.application, this.appLayer, this.query, this.title, this.wellKnownUserLayerWorkspaceName, this.wellKnownUserLayerStoreName);
        boolean success = true;
        String isInvalidMsg = ulh.validate();
        JSONObject jsonObject = new JSONObject().put("success", (Object)Boolean.TRUE);
        jsonObject.put("valid", (Object)isInvalidMsg);
        jsonObject.put("sql", (Object)ulh.getSQLQuery());
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Resolution add() {
        JSONObject jsonObject = new JSONObject().put("success", (Object)Boolean.FALSE);
        if (this.unauthorized) {
            jsonObject.put("error", (Object)"not authorized to add");
        } else {
            try {
                boolean success;
                JSONObject message = new JSONObject();
                UserLayerHandler ulh = new UserLayerHandler(this.auditMessageObject, Stripersist.getEntityManager(), this.application, this.appLayer, this.query, this.title, this.wellKnownUserLayerWorkspaceName, this.wellKnownUserLayerStoreName);
                String isInvalidMsg = ulh.validate();
                if (isInvalidMsg != null) {
                    success = false;
                    jsonObject.put("error", (Object)isInvalidMsg);
                } else {
                    success = ulh.add();
                }
                jsonObject.put("success", success);
                if (success) {
                    message.put("appLayerId", ulh.getAppLayerId());
                    message.put("layerName", (Object)ulh.getLayerName());
                    message.put("appLayer", (Object)ApplicationLayerHelper.toJSONObject((ApplicationLayer)ulh.getCreatedAppLayer(), (EntityManager)Stripersist.getEntityManager()));
                    message.put("service", (Object)GeoServiceHelper.toJSONObject((GeoService)ulh.getCreatedAppLayer().getService(), (boolean)false, null, (boolean)false, (boolean)false, (EntityManager)Stripersist.getEntityManager()));
                    this.auditMessageObject.addMessage((Object)("UserLayer " + ulh.getLayerName() + " aangemaakt met id " + ulh.getAppLayerId()));
                }
                jsonObject.put("message", (Object)message);
                ulh.dispose();
            }
            catch (Exception unforeseen) {
                LOG.error((Object)unforeseen);
                jsonObject.put("error", (Object)("Fatale fout: " + unforeseen.getLocalizedMessage()));
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Resolution delete() {
        JSONObject jsonObject = new JSONObject().put("success", (Object)Boolean.FALSE);
        if (this.unauthorized) {
            jsonObject.put("error", (Object)"not authorized to delete");
        } else {
            try {
                UserLayerHandler ulh = new UserLayerHandler(this.auditMessageObject, Stripersist.getEntityManager(), this.application, this.appLayer, this.query, this.title, this.wellKnownUserLayerWorkspaceName, this.wellKnownUserLayerStoreName);
                boolean ok = ulh.delete();
                jsonObject.put("success", ok);
                this.auditMessageObject.addMessage((Object)("UserLayer " + ulh.getLayerName() + " met id " + ulh.getAppLayerId() + (ok ? "" : " niet") + " verwijderd."));
                ulh.dispose();
            }
            catch (Exception unforeseen) {
                LOG.error((Object)unforeseen);
                jsonObject.put("error", (Object)("Fatale fout: " + unforeseen.getLocalizedMessage()));
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Resolution put() {
        JSONObject jsonObject = new JSONObject().put("success", (Object)Boolean.FALSE);
        if (this.unauthorized) {
            jsonObject.put("error", (Object)"not authorized to change style");
        } else {
            try {
                UserLayerHandler ulh = new UserLayerHandler(this.auditMessageObject, Stripersist.getEntityManager(), this.application, this.appLayer, this.query, this.title, this.wellKnownUserLayerWorkspaceName, this.wellKnownUserLayerStoreName);
                boolean ok = ulh.updateStyle(this.style);
                jsonObject.put("success", ok);
                this.auditMessageObject.addMessage((Object)("Stijl van userLayer " + ulh.getLayerName() + " met id " + this.appLayer.getId() + " is " + (ok ? "" : "niet") + " aangepast."));
                ulh.dispose();
            }
            catch (Exception unforeseen) {
                LOG.error((Object)unforeseen);
                jsonObject.put("error", (Object)("Fatale fout: " + unforeseen.getLocalizedMessage()));
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public AuditMessageObject getAuditMessageObject() {
        return this.auditMessageObject;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public ApplicationLayer getAppLayer() {
        return this.appLayer;
    }

    public void setAppLayer(ApplicationLayer appLayer) {
        this.appLayer = appLayer;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }
}

