/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.userlayer;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import nl.tailormap.viewer.audit.AuditMessageObject;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.services.Category;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.config.services.SimpleFeatureType;
import nl.tailormap.viewer.config.services.WMSExceptionType;
import nl.tailormap.viewer.config.services.WMSService;
import nl.tailormap.viewer.helpers.featuresources.FeatureSourceFactoryHelper;
import nl.tailormap.viewer.helpers.services.WMSServiceHelper;
import nl.tailormap.viewer.userlayer.DataBase;
import nl.tailormap.viewer.userlayer.DataBaseFactory;
import nl.tailormap.viewer.userlayer.GeoServerManager;
import nl.tailormap.viewer.userlayer.TMFilterToSQL;
import nl.tailormap.viewer.userlayer.TailormapDBManager;
import nl.tailormap.viewer.util.TailormapCQL;
import nl.tailormap.web.WaitPageStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.jdbc.JDBCDataStore;

public class UserLayerHandler {
    private static final Log LOG = LogFactory.getLog(UserLayerHandler.class);
    private static final String USERLAYER_NAME = "B3P - Gebruikerslagen (niet aanpassen)";
    private final AuditMessageObject auditMessageObject;
    private final ApplicationLayer appLayer;
    private final String query;
    private final String layerTitle;
    private final EntityManager entityManager;
    private final Application application;
    private final GeoServerManager manager;
    private final String geoserverStore;
    private final String geoserverWorkspace;
    private final String baseUrl;
    private ApplicationLayer createdAppLayer;
    private Layer layer;
    private String tableName;
    private GeoService service;
    private JDBCDataStore dataStore;
    private DataBase dataBase;
    private TailormapDBManager tmManager;

    public UserLayerHandler(AuditMessageObject auditMessageObject, EntityManager entityManager, Application application, ApplicationLayer appLayer, String query, String userLayerTitle, String geoserverWorkspace, String geoserverStore) {
        this.auditMessageObject = auditMessageObject;
        this.entityManager = entityManager;
        this.application = application;
        this.appLayer = appLayer;
        this.query = query;
        this.layerTitle = userLayerTitle;
        this.geoserverWorkspace = geoserverWorkspace;
        this.geoserverStore = geoserverStore;
        try {
            this.service = this.appLayer.getService();
            this.layer = this.service.getLayer(this.appLayer.getLayerName(), this.entityManager);
            this.tableName = this.layer.getFeatureType().getTypeName();
            this.dataStore = (JDBCDataStore)FeatureSourceFactoryHelper.openGeoToolsFeatureSource((SimpleFeatureType)this.layer.getFeatureType()).getDataStore();
            this.dataBase = DataBaseFactory.getDataBase((JDBCDataStore)this.dataStore);
        }
        catch (Exception e) {
            LOG.fatal((Object)("Problem opening datastore. " + e.getLocalizedMessage()));
        }
        String serviceUrl = this.service.getUrl();
        this.baseUrl = serviceUrl.substring(0, serviceUrl.indexOf("/geoserver/") + "/geoserver/".length());
        this.manager = new GeoServerManager(this.service.getUsername(), this.service.getPassword(), this.geoserverWorkspace, this.geoserverStore, this.baseUrl);
        this.tmManager = new TailormapDBManager(entityManager, application, appLayer, this.service, this.layer, this.query, geoserverWorkspace, this.baseUrl, this.auditMessageObject);
    }

    public String validate() {
        Object message;
        try {
            String sql = this.getSQLQuery();
            message = this.dataBase.preValidateView(this.tableName, sql);
            if (message != null) {
                message = "Selectielaag kan niet gemaakt worden. " + (String)message;
            }
        }
        catch (IOException | CQLException e) {
            message = "Selectielaag kan niet gemaakt worden. Syntax fout in CQL expressie: " + e.getLocalizedMessage();
        }
        catch (FilterToSQLException e) {
            message = "Selectielaag kan niet gemaakt worden. Syntax fout in SQL expressie: " + e.getLocalizedMessage();
        }
        return message;
    }

    public boolean add() {
        String viewName;
        boolean succes;
        String viewTableName = this.tableName;
        if (viewTableName.length() > 23) {
            viewTableName = viewTableName.substring(0, 23);
        }
        if (succes = this.createView(viewName = this.dataBase.createViewName(viewTableName))) {
            succes = this.createWMSLayer(viewName);
        }
        if (succes) {
            succes = this.createUserLayer(viewName, this.layerTitle);
        } else {
            this.deleteWMSLayer(viewName);
            this.dropview(viewName);
        }
        return succes;
    }

    public boolean delete() {
        boolean success = this.removeApplayerFromApplication(this.appLayer);
        if (!success) {
            return success;
        }
        success = this.deleteWMSLayer(this.layer.getName());
        if (success) {
            success = this.dropview(this.layer.getName());
            if (!success) {
                this.createWMSLayer(this.layer.getName());
                this.createUserLayer(this.layer.getName(), this.layer.getTitle());
            }
        } else {
            this.createUserLayer(this.layer.getName(), this.layer.getTitle());
        }
        return success;
    }

    public boolean updateStyle(String cssStyle) {
        return this.manager.addStyleToLayer(this.layer.getName(), cssStyle);
    }

    public void dispose() {
        if (this.dataBase != null) {
            this.dataBase.close();
        }
        if (this.dataStore != null) {
            this.dataStore.dispose();
        }
    }

    public void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public String getSQLQuery() throws CQLException, FilterToSQLException, IOException {
        TMFilterToSQL f = new TMFilterToSQL(this.dataStore, this.tableName);
        f.createFilterCapabilities();
        return f.encodeToString(TailormapCQL.toFilter((String)this.query, (EntityManager)this.entityManager, (boolean)false));
    }

    private boolean createView(String viewName) {
        boolean ok = false;
        try {
            String where = this.getSQLQuery();
            ok = this.dataBase.createView(viewName, this.tableName, where, String.format(Locale.forLanguageTag("nl"), "GBI userlayer gemaakt van %s met query %s op %tc door gebruiker %s", this.tableName, where, new Date(), this.auditMessageObject.getUsername()));
            this.auditMessageObject.addMessage((Object)("Aanmaken van view " + viewName + " is " + (ok ? "gelukt" : "mislukt")));
        }
        catch (IOException | FilterToSQLException | CQLException e) {
            LOG.error((Object)("Problem converting CQL to SQL. " + e.getLocalizedMessage()));
        }
        return ok;
    }

    private boolean dropview(String viewName) {
        boolean ok = this.dataBase.dropView(viewName);
        this.auditMessageObject.addMessage((Object)("Verwijderen van view " + viewName + " is " + (ok ? "gelukt" : "mislukt")));
        return ok;
    }

    private boolean createWMSLayer(String viewName) {
        boolean ok = this.manager.createLayer(viewName, this.layerTitle, viewName);
        this.auditMessageObject.addMessage((Object)("Aanmaken van WMS layer " + viewName + " is " + (ok ? "gelukt" : "mislukt")));
        return ok;
    }

    private boolean deleteWMSLayer(String layerName) {
        boolean ok = this.manager.deleteLayer(layerName);
        this.auditMessageObject.addMessage((Object)("Verwijderen van WMS layer " + layerName + " is " + (ok ? "gelukt" : "mislukt")));
        return ok;
    }

    private boolean createUserLayer(String viewName, String title) {
        boolean success = this.tmManager.addLayer(viewName, title);
        this.auditMessageObject.addMessage((Object)("Aanmaken van laag in Tailormap database " + title + " - " + viewName + " is " + (success ? "gelukt" : "mislukt")));
        this.createdAppLayer = this.tmManager.getCreatedAppLayer();
        this.layer = this.tmManager.getLayer();
        return success;
    }

    private boolean removeApplayerFromApplication(ApplicationLayer applicationLayer) {
        boolean success = this.tmManager.removeLayer(applicationLayer);
        this.auditMessageObject.addMessage((Object)("Verwijderen van laag uit Tailormap database " + applicationLayer.getLayerName() + " is " + (success ? "gelukt" : "mislukt")));
        this.createdAppLayer = this.appLayer;
        return true;
    }

    public ApplicationLayer getApplicationLayer() {
        return this.appLayer;
    }

    public long getAppLayerId() {
        return this.createdAppLayer.getId();
    }

    public String getLayerName() {
        return this.layer.getName();
    }

    private GeoService retrieveUserLayerService() {
        List services = this.entityManager.createQuery("select distinct gs from GeoService gs where gs.url like :q ").setParameter("q", (Object)("%" + this.geoserverWorkspace + "%")).setMaxResults(1).getResultList();
        return services.isEmpty() ? null : (GeoService)services.get(0);
    }

    private GeoService createUserLayerService() {
        WMSService userlayerService = null;
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("username", this.service.getUsername());
            params.put("password", this.service.getPassword());
            params.put("skipDiscoverWFS", true);
            String url = this.baseUrl + this.geoserverWorkspace + "/wms";
            WaitPageStatus status = new WaitPageStatus();
            userlayerService = WMSServiceHelper.loadFromUrl((String)url, params, (WaitPageStatus)status, (EntityManager)this.entityManager);
            userlayerService.setException_type(WMSExceptionType.Inimage);
            userlayerService.setName(USERLAYER_NAME);
            userlayerService.setUsername(this.service.getUsername());
            userlayerService.setPassword(this.service.getPassword());
            userlayerService.getReaders().addAll(this.service.getReaders());
            Category category = (Category)this.entityManager.find(Category.class, (Object)this.service.getCategory().getId());
            userlayerService.setCategory(category);
            category.getServices().add(userlayerService);
            status.setCurrentAction("Service opslaan.");
            this.entityManager.persist((Object)userlayerService);
            this.entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            LOG.error((Object)"Error creating GeoService: ", (Throwable)e);
        }
        return userlayerService;
    }

    public ApplicationLayer getCreatedAppLayer() {
        return this.createdAppLayer;
    }
}

