/*
 * Decompiled with CFR 0.152.
 */
package nl.viewer.features;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import nl.viewer.config.app.ConfiguredAttribute;
import nl.viewer.config.services.AttributeDescriptor;
import nl.viewer.features.FeatureDownloader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geojson.feature.FeatureJSON;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opengis.feature.simple.SimpleFeature;

public class GeoJSONDownloader
extends FeatureDownloader {
    private static final Log log = LogFactory.getLog(GeoJSONDownloader.class);
    private FeatureJSON fjson;
    private JSONArray features = new JSONArray();

    public GeoJSONDownloader(List<ConfiguredAttribute> attributes, SimpleFeatureSource fs, Map<String, AttributeDescriptor> featureTypeAttributes, Map<String, String> attributeAliases, String params) {
        super(attributes, fs, featureTypeAttributes, attributeAliases, params);
    }

    public void init() throws IOException {
        this.fjson = new FeatureJSON();
    }

    public void processFeature(SimpleFeature oldFeature) {
        try {
            StringWriter sw = new StringWriter();
            this.fjson.writeFeature(oldFeature, (Object)sw);
            JSONObject featureObject = new JSONObject(sw.toString());
            this.features.put((Object)featureObject);
        }
        catch (IOException ex) {
            log.error((Object)"Cannot write feature: ", (Throwable)ex);
        }
    }

    public File write() throws IOException {
        JSONObject featureCollection = new JSONObject();
        featureCollection.put("type", (Object)"FeatureCollection");
        featureCollection.put("features", (Object)this.features);
        File f = File.createTempFile("GeoJSON", ".json");
        PrintWriter pw = new PrintWriter(f);
        pw.write(featureCollection.toString());
        pw.close();
        return f;
    }
}

