/*
 * Decompiled with CFR 0.152.
 */
package nl.viewer.features;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import nl.viewer.config.app.ConfiguredAttribute;
import nl.viewer.config.services.AttributeDescriptor;
import nl.viewer.features.FeatureDownloader;
import nl.viewer.features.StreamingShapeWriter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;
import org.xml.sax.SAXException;

public class ShapeDownloader
extends FeatureDownloader {
    private static final Log log = LogFactory.getLog(ShapeDownloader.class);
    private StreamingShapeWriter ssw;
    private SimpleFeatureBuilder featureBuilder;
    private File dir;

    public ShapeDownloader(List<ConfiguredAttribute> attributes, SimpleFeatureSource fs, Map<String, AttributeDescriptor> featureTypeAttributes, Map<String, String> attributeAliases, String params) {
        super(attributes, fs, featureTypeAttributes, attributeAliases, params);
    }

    public void init() throws IOException {
        try {
            String uniqueName = RandomStringUtils.randomAlphanumeric((int)8);
            this.dir = new File(System.getProperty("java.io.tmpdir"), uniqueName);
            this.dir.mkdir();
            this.ssw = new StreamingShapeWriter(this.dir.getAbsolutePath() + File.separator);
            SimpleFeatureType sft = this.createNewFeatureType(this.fs, this.attributes, this.featureTypeAttributes);
            this.featureBuilder = new SimpleFeatureBuilder(sft);
        }
        catch (IOException ex) {
            log.error((Object)"Cannot initialize new download", (Throwable)ex);
            throw ex;
        }
    }

    public void processFeature(SimpleFeature oldFeature) {
        try {
            for (ConfiguredAttribute configuredAttribute : this.attributes) {
                if (!configuredAttribute.isVisible() || this.attributeAliases.get(configuredAttribute.getAttributeName()) == null) continue;
                this.featureBuilder.add(oldFeature.getAttribute(configuredAttribute.getAttributeName()));
            }
            this.featureBuilder.add(oldFeature.getDefaultGeometry());
            SimpleFeature feature = this.featureBuilder.buildFeature(null);
            this.ssw.write(feature);
        }
        catch (IOException ex) {
            log.error((Object)"Cannot write feature", (Throwable)ex);
        }
        catch (ParserConfigurationException | TransformerException | FactoryException | TransformException | SAXException ex) {
            log.error((Object)"Cannot parse features");
        }
    }

    public File write() throws IOException {
        this.ssw.close();
        File zip = File.createTempFile("downloadshp", ".zip");
        this.zipDirectory(this.dir, zip);
        FileUtils.deleteDirectory((File)this.dir);
        return zip;
    }

    private SimpleFeatureType createNewFeatureType(SimpleFeatureSource sfs, List<ConfiguredAttribute> configuredAttributes, Map<String, AttributeDescriptor> featureTypeAttributes) throws IOException {
        SimpleFeatureType oldSft = (SimpleFeatureType)sfs.getSchema();
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName(sfs.getName());
        for (ConfiguredAttribute configuredAttribute : configuredAttributes) {
            if (!configuredAttribute.isVisible() || this.attributeAliases.get(configuredAttribute.getAttributeName()) == null) continue;
            AttributeDescriptor ad = featureTypeAttributes.get(configuredAttribute.getFullName());
            String alias = (String)this.attributeAliases.get(configuredAttribute.getAttributeName());
            b.add(alias, ad.getType().getClass());
        }
        b.setCRS(oldSft.getGeometryDescriptor().getCoordinateReferenceSystem());
        b.add("the_geom", oldSft.getGeometryDescriptor().getType().getBinding());
        SimpleFeatureType newFeatureType = b.buildFeatureType();
        return newFeatureType;
    }

    private void zipDirectory(File dir, File zip) throws IOException {
        try {
            ArrayList filesListInDir = new ArrayList();
            this.populateFilesList(dir, filesListInDir);
            FileOutputStream fos = new FileOutputStream(zip);
            ZipOutputStream zos = new ZipOutputStream(fos);
            for (String filePath : filesListInDir) {
                int len;
                ZipEntry ze = new ZipEntry(filePath.substring(dir.getAbsolutePath().length() + 1, filePath.length()));
                zos.putNextEntry(ze);
                FileInputStream fis = new FileInputStream(filePath);
                byte[] buffer = new byte[1024];
                while ((len = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                zos.closeEntry();
                fis.close();
            }
            zos.close();
            fos.close();
        }
        catch (IOException e) {
            log.error((Object)"Could not write zipfile. Exiting.", (Throwable)e);
            throw e;
        }
    }

    private void populateFilesList(File dir, List<String> filesListInDir) throws IOException {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isFile()) {
                filesListInDir.add(file.getAbsolutePath());
                continue;
            }
            this.populateFilesList(file, filesListInDir);
        }
    }
}

