/*
 * Decompiled with CFR 0.152.
 */
package nl.viewer.image;

import java.net.URL;
import java.util.List;
import nl.viewer.image.CombineImageSettings;
import nl.viewer.image.ImageBbox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CombineImageUrl {
    private static final Log log = LogFactory.getLog(CombineImageSettings.class);
    protected String url = null;
    private String body = null;
    private URL realUrl;
    private Float alpha = null;

    public CombineImageUrl() {
    }

    public CombineImageUrl(CombineImageUrl ciu) {
        this.url = ciu.getUrl();
        this.alpha = ciu.getAlpha();
        this.body = ciu.getBody();
        this.realUrl = ciu.getRealUrl();
    }

    public CombineImageUrl(String url, Float alpha) {
        this.setUrl(url);
        this.setAlpha(alpha);
    }

    public CombineImageUrl(URL realUrl, Float alpha) {
        this.setRealUrl(realUrl);
        this.setAlpha(alpha);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public URL getRealUrl() {
        return this.realUrl;
    }

    public void setRealUrl(URL realUrl) {
        this.realUrl = realUrl;
    }

    public Float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(Float alpha) {
        if (alpha == null) {
            this.alpha = null;
        } else if (alpha.floatValue() > 1.0f) {
            alpha = new Float("1");
        } else if (alpha.floatValue() < 0.0f) {
            alpha = new Float("0");
        }
        this.alpha = alpha;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getBody() {
        return this.body;
    }

    public String toString() {
        Object returnValue = "";
        if (this.url != null) {
            returnValue = (String)returnValue + this.url + " ";
        }
        if (this.alpha != null) {
            returnValue = (String)returnValue + "(" + this.alpha + ")";
        }
        return returnValue;
    }

    public abstract List<CombineImageUrl> calculateNewUrl(ImageBbox var1);
}

