/*
 * Decompiled with CFR 0.152.
 */
package nl.viewer.image;

import java.util.ArrayList;
import java.util.List;
import nl.viewer.image.Bbox;
import nl.viewer.image.CombineImageUrl;
import nl.viewer.image.CombineStaticImageUrl;
import nl.viewer.image.ImageBbox;

public abstract class CombineTileImageUrl
extends CombineImageUrl {
    protected Bbox serviceBbox = null;
    private Double[] resolutions = null;
    private Integer tileWidth = 256;
    private Integer tileHeight = 256;
    protected String extension;
    protected static double epsilon = 1.0E-10;

    public CombineTileImageUrl(CombineTileImageUrl ctiu) {
        super((CombineImageUrl)ctiu);
    }

    public CombineTileImageUrl() {
    }

    public Integer getClosestZoomlevel(ImageBbox requestBbox) {
        Double res = null;
        if (requestBbox != null) {
            res = requestBbox.getUnitsPixelX();
        }
        Integer zoomlevel = null;
        if (this.resolutions != null) {
            for (int i = 0; i < this.resolutions.length; ++i) {
                Double testRes = this.resolutions[i];
                if (res - testRes < epsilon && res - testRes > -epsilon) {
                    zoomlevel = i;
                    break;
                }
                if (res >= testRes) {
                    zoomlevel = i;
                    break;
                }
                if (!(res < testRes)) continue;
                zoomlevel = i;
            }
        }
        return zoomlevel;
    }

    public Double getResolution(ImageBbox imbbox, Integer zoomlevel) {
        return this.resolutions[zoomlevel];
    }

    public List<CombineImageUrl> calculateNewUrl(ImageBbox imbbox) {
        ArrayList<CombineImageUrl> tileImages = new ArrayList<CombineImageUrl>();
        Integer zoomlevel = this.getClosestZoomlevel(imbbox);
        Double closestResolution = this.getResolution(imbbox, zoomlevel);
        Double tileWidthMapUnits = null;
        Double tileHeightMapUnits = null;
        if (this.getTileWidth() != null && closestResolution != null) {
            tileWidthMapUnits = (double)this.getTileWidth().intValue() * closestResolution;
        }
        if (this.getTileWidth() != null && closestResolution != null) {
            tileHeightMapUnits = (double)this.getTileWidth().intValue() * closestResolution;
        }
        Integer minTileIndexX = null;
        Integer maxTileIndexX = null;
        Integer minTileIndexY = null;
        Integer maxTileIndexY = null;
        Bbox bbox = imbbox.getBbox();
        if (tileWidthMapUnits != null && tileWidthMapUnits > 0.0 && tileHeightMapUnits != null && tileHeightMapUnits > 0.0) {
            minTileIndexX = this.getTileIndexX(Double.valueOf(bbox.getMinx()), closestResolution, false);
            maxTileIndexX = this.getTileIndexX(Double.valueOf(bbox.getMaxx()), closestResolution, true);
            minTileIndexY = this.getTileIndexY(bbox.getMiny(), closestResolution, false);
            maxTileIndexY = this.getTileIndexY(bbox.getMaxy(), closestResolution, true);
        }
        int numX = 0;
        int numY = 0;
        for (int ix = minTileIndexX.intValue(); ix <= maxTileIndexX; ++ix) {
            for (int iy = minTileIndexY.intValue(); iy <= maxTileIndexY; ++iy) {
                double[] tempBbox;
                tempBbox = new double[]{this.serviceBbox.getMinx() + (double)ix * tileWidthMapUnits, this.serviceBbox.getMiny() + (double)iy * tileHeightMapUnits, tempBbox[0] + tileWidthMapUnits, tempBbox[1] + tileHeightMapUnits};
                Bbox tileBbox = new Bbox(tempBbox);
                CombineStaticImageUrl tile = this.createTile(imbbox, tileBbox, ix, iy, zoomlevel.intValue(), numX, numY);
                tileImages.add((CombineImageUrl)tile);
                ++numY;
            }
            ++numX;
            numY = 0;
        }
        return tileImages;
    }

    public CombineStaticImageUrl createTile(ImageBbox imageBbox, Bbox tileBbox, int tileIndexX, int tileIndexY, int zoomlevel, int imgIndexX, int imgIndexY) {
        CombineStaticImageUrl tile = new CombineStaticImageUrl();
        tile.setBbox(tileBbox);
        tile.setUrl(this.getUrl());
        tile.setAlpha(this.getAlpha());
        Bbox requestBbox = imageBbox.getBbox();
        Double msx = (requestBbox.getMaxx() - requestBbox.getMinx()) / (double)imageBbox.getWidth().intValue();
        Double msy = (requestBbox.getMaxy() - requestBbox.getMiny()) / (double)imageBbox.getHeight().intValue();
        Double posX = Math.ceil((tileBbox.getMinx() - requestBbox.getMinx()) / msx);
        Double posY = Math.ceil((requestBbox.getMaxy() - tileBbox.getMaxy()) / msy);
        Double width = Math.ceil((tileBbox.getMaxx() - tileBbox.getMinx()) / msx);
        Double height = Math.ceil((tileBbox.getMaxy() - tileBbox.getMiny()) / msy);
        tile.setX(Integer.valueOf(posX.intValue()));
        tile.setY(Integer.valueOf(posY.intValue()));
        tile.setWidth(Integer.valueOf(width.intValue()));
        tile.setHeight(Integer.valueOf(height.intValue()));
        tile.setUrl(this.createUrl(imageBbox, tileBbox, tileIndexX, tileIndexY, zoomlevel));
        return tile;
    }

    public Integer getTileIndexX(Double xCoord, Double res, boolean max) {
        Double tileSpanX = res * (double)this.getTileWidth().intValue();
        Double tileIndexX = Math.floor((xCoord - this.serviceBbox.getMinx()) / (tileSpanX + epsilon));
        if (tileIndexX < 0.0) {
            tileIndexX = 0.0;
        }
        Double maxBboxX = Math.floor((this.serviceBbox.getMaxx() - this.serviceBbox.getMinx()) / (tileSpanX + epsilon));
        if (tileIndexX > maxBboxX) {
            tileIndexX = maxBboxX;
        }
        return tileIndexX.intValue();
    }

    public Integer getTileIndexY(double yCoord, Double res, boolean max) {
        Double tileSpanY = res * (double)this.getTileHeight().intValue();
        Double tileIndexY = Math.floor((yCoord - this.serviceBbox.getMiny()) / (tileSpanY + epsilon));
        if (tileIndexY < 0.0) {
            tileIndexY = 0.0;
        }
        Double maxBboxY = Math.floor((this.serviceBbox.getMaxy() - this.serviceBbox.getMiny()) / (tileSpanY + epsilon));
        if (tileIndexY > maxBboxY) {
            tileIndexY = maxBboxY;
        }
        return tileIndexY.intValue();
    }

    public Bbox getServiceBbox() {
        return this.serviceBbox;
    }

    public void setServiceBbox(Bbox bbox) {
        this.serviceBbox = bbox;
    }

    public Double[] getResolutions() {
        return this.resolutions;
    }

    public void setResolutions(Double[] resolutions) {
        this.resolutions = resolutions;
    }

    public Integer getTileWidth() {
        return this.tileWidth;
    }

    public void setTileWidth(Integer tileWidth) {
        this.tileWidth = tileWidth;
    }

    public Integer getTileHeight() {
        return this.tileHeight;
    }

    public void setTileHeight(Integer tileHeight) {
        this.tileHeight = tileHeight;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    protected abstract String createUrl(ImageBbox var1, Bbox var2, int var3, int var4, int var5);
}

