/*
 * Decompiled with CFR 0.152.
 */
package nl.viewer.image;

import java.awt.Color;
import nl.viewer.image.CombineImageSettings;
import org.json.JSONObject;

public class FeatureStyle {
    private String label = "";
    private String labelOutlineColor = "FFFFFF";
    private Integer labelOutlineWidth = 1;
    private String labelAlign = null;
    private Float fontSize = Float.valueOf(12.0f);
    private String fontColor = "000000";
    private Double rotation = 0.0;
    private Double labelXOffset = 0.0;
    private Double labelYOffset = 0.0;
    private String fillColor = null;
    private double fillOpacity = 0.0;
    private String strokeColor = null;
    private Double strokeOpacity = 0.0;
    private Double strokeWidth = 0.0;
    private String strokeDashstyle = "solid";
    private String graphicName = null;
    private Double pointRadius = 0.0;

    @Deprecated
    public FeatureStyle() {
        this.fillColor = "ff0000";
        this.fillOpacity = 0.3;
        this.pointRadius = 6.0;
        this.strokeColor = "ff0000";
        this.strokeOpacity = 0.3;
        this.strokeWidth = 2.0;
    }

    public FeatureStyle(JSONObject style) {
        this.label = style.optString("label");
        this.labelOutlineColor = this.sanitizeColorString(style.optString("labelOutlineColor", "#FFFFFF"));
        this.labelOutlineWidth = style.optInt("labelOutlineWidth", 1);
        this.labelAlign = style.optString("labelAlign");
        this.fontSize = Float.valueOf(style.optFloat("fontSize", 12.0f));
        this.fontColor = this.sanitizeColorString(style.optString("fontColor", "#000000"));
        this.rotation = style.optDouble("rotation", 0.0);
        this.labelXOffset = style.optDouble("labelXOffset", 0.0);
        this.labelYOffset = style.optDouble("labelYOffset", 0.0);
        String fc = style.optString("fillColor");
        boolean transparentFillColor = fc.equalsIgnoreCase("transparent");
        fc = transparentFillColor ? null : fc;
        fc = this.sanitizeColorString(fc);
        this.fillColor = this.sanitizeColorString(fc);
        this.fillOpacity = transparentFillColor ? 0.0 : style.optDouble("fillOpacity", 0.0);
        this.strokeColor = this.sanitizeColorString(style.optString("strokeColor"));
        this.strokeOpacity = style.optDouble("strokeOpacity", 0.0);
        this.strokeDashstyle = style.optString("strokeDashstyle", "solid");
        this.strokeWidth = style.optDouble("strokeWidth", 3.0);
        this.graphicName = style.optString("graphicName");
        this.pointRadius = style.optDouble("pointRadius", 0.0);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Color getLabelOutlineColor() {
        return this.labelOutlineColor != null ? new Color(Integer.parseInt(this.labelOutlineColor, 16)) : null;
    }

    public void setLabelOutlineColor(String labelOutlineColor) {
        this.labelOutlineColor = this.sanitizeColorString(labelOutlineColor);
    }

    public Integer getLabelOutlineWidth() {
        return this.labelOutlineWidth;
    }

    public void setLabelOutlineWidth(Integer labelOutlineWidth) {
        this.labelOutlineWidth = labelOutlineWidth;
    }

    public String getLabelAlign() {
        return this.labelAlign;
    }

    public void setLabelAlign(String labelAlign) {
        this.labelAlign = labelAlign;
    }

    public Float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(Float fontSize) {
        this.fontSize = fontSize;
    }

    public Color getFontColor() {
        return this.fontColor != null ? new Color(Integer.parseInt(this.fontColor, 16)) : Color.BLACK;
    }

    public void setFontColor(String fontColor) {
        this.fontColor = this.sanitizeColorString(fontColor);
    }

    public Double getRotation() {
        return this.rotation;
    }

    public void setRotation(Double rotation) {
        this.rotation = rotation;
    }

    public Double getLabelXOffset() {
        return this.labelXOffset;
    }

    public void setLabelXOffset(Double labelXOffset) {
        this.labelXOffset = labelXOffset;
    }

    public Double getLabelYOffset() {
        return this.labelYOffset;
    }

    public void setLabelYOffset(Double labelYOffset) {
        this.labelYOffset = labelYOffset;
    }

    public Color getFillColor() {
        return this.fillColor != null && !this.fillColor.isEmpty() ? new Color(Integer.parseInt(this.fillColor, 16)) : CombineImageSettings.defaultWktGeomColor;
    }

    public void setFillColor(String fillColor) {
        this.fillColor = this.sanitizeColorString(fillColor);
    }

    public Double getFillOpacity() {
        return this.fillOpacity;
    }

    public void setFillOpacity(Double fillOpacity) {
        this.fillOpacity = fillOpacity;
    }

    public Color getStrokeColor() {
        return this.strokeColor != null ? new Color(Integer.parseInt(this.strokeColor, 16)) : null;
    }

    public void setStrokeColor(String strokeColor) {
        this.strokeColor = this.sanitizeColorString(strokeColor);
    }

    public Double getStrokeOpacity() {
        return this.strokeOpacity;
    }

    public void setStrokeOpacity(Double strokeOpacity) {
        this.strokeOpacity = strokeOpacity;
    }

    public String getStrokeDashstyle() {
        return this.strokeDashstyle;
    }

    public void setStrokeDashstyle(String strokeDashstyle) {
        this.strokeDashstyle = strokeDashstyle;
    }

    public String getGraphicName() {
        return this.graphicName;
    }

    public void setGraphicName(String graphicName) {
        this.graphicName = graphicName;
    }

    public Double getPointRadius() {
        return this.pointRadius;
    }

    public void setPointRadius(Double pointRadius) {
        this.pointRadius = pointRadius;
    }

    public Double getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(Double strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    private String sanitizeColorString(String color) {
        if (color == null || color.isEmpty()) {
            return null;
        }
        int index = color.indexOf("#");
        if (index != -1) {
            color = color.substring(index + 1);
        }
        return color;
    }

    public String toString() {
        return "FeatureStyle{label=" + this.label + ", labelOutlineColor=" + this.labelOutlineColor + ", labelOutlineWidth=" + this.labelOutlineWidth + ", labelAlign=" + this.labelAlign + ", fontSize=" + this.fontSize + ", fontColor=" + this.fontColor + ", rotation=" + this.rotation + ", labelXOffset=" + this.labelXOffset + ", labelYOffset=" + this.labelYOffset + ", fillColor=" + this.fillColor + ", fillOpacity=" + this.fillOpacity + ", strokeColor=" + this.strokeColor + ", strokeOpacity=" + this.strokeOpacity + ", strokeWidth=" + this.strokeWidth + ", strokeDashstyle=" + this.strokeDashstyle + ", graphicName=" + this.graphicName + ", pointRadius=" + this.pointRadius + "}";
    }
}

