/*
 * Decompiled with CFR 0.152.
 */
package nl.viewer.image;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.Callable;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import nl.viewer.image.CombineImageUrl;
import nl.viewer.image.ImageTool;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageCollector
implements Callable<ImageCollector> {
    private static final Log log = LogFactory.getLog(ImageCollector.class);
    private int maxResponseTime = 10000;
    public static final int NEW = 0;
    public static final int ACTIVE = 1;
    public static final int COMPLETED = 2;
    public static final int WARNING = 3;
    public static final int ERROR = 4;
    private int status = 0;
    private String message = null;
    private BufferedImage bufferedImage;
    private String username = null;
    private String password = null;
    private CombineImageUrl combinedImageUrl = null;
    protected HttpClient client = null;
    private HttpServletRequest req;

    public ImageCollector(CombineImageUrl ciu, int maxResponseTime, HttpClient client, HttpServletRequest req) {
        this.combinedImageUrl = ciu;
        this.maxResponseTime = maxResponseTime;
        this.client = client;
        this.setMessage("Still downloading...");
        this.req = req;
    }

    public ImageCollector(CombineImageUrl ciu, int maxResponseTime, HttpClient client, String uname, String pw, HttpServletRequest req) {
        this(ciu, maxResponseTime, client, req);
        this.username = uname;
        this.password = pw;
    }

    @Override
    public ImageCollector call() throws Exception {
        this.status = 1;
        if ((this.getUrl() == null || this.getUrl().length() == 0) && this.getRealUrl() == null) {
            return this;
        }
        try {
            if (this.getRealUrl() != null) {
                this.setBufferedImage(ImageIO.read(this.getRealUrl()));
            } else {
                this.setBufferedImage(this.loadImage(this.getUrl(), this.getUsername(), this.getPassword()));
            }
            this.setMessage("");
            this.setStatus(2);
        }
        catch (Exception ex) {
            log.warn((Object)"error call image collector: ", (Throwable)ex);
            this.setStatus(4);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage loadImage(String url, String user, String pass) throws IOException, Exception {
        GetMethod method = null;
        try {
            int statusCode;
            method = new GetMethod(url);
            if (this.req != null) {
                Cookie[] biscuits;
                Header cookieHeader;
                javax.servlet.http.Cookie[] cookies = this.req.getCookies();
                String jsessionid = null;
                String key = "JSESSIONID";
                String ssojsessionid = null;
                String ssokey = "JSESSIONIDSSO";
                if (cookies != null) {
                    for (javax.servlet.http.Cookie cookie : cookies) {
                        if (cookie == null || !cookie.getName().equalsIgnoreCase(key)) continue;
                        jsessionid = cookie.getValue();
                        break;
                    }
                    for (javax.servlet.http.Cookie cookie : cookies) {
                        if (cookie == null || !cookie.getName().equalsIgnoreCase(ssokey)) continue;
                        ssojsessionid = cookie.getValue();
                        break;
                    }
                } else if (this.req.getParameterValues(key).length == 1) {
                    jsessionid = this.req.getParameterValues(key)[0];
                }
                if (jsessionid != null) {
                    cookieHeader = new Header("Cookie", null);
                    cookieHeader.setValue(key + "=" + jsessionid);
                    method.setRequestHeader(cookieHeader);
                }
                if (ssojsessionid == null && (biscuits = this.client.getState().getCookies()) != null) {
                    for (Cookie biscuit : biscuits) {
                        if (biscuit == null || !biscuit.getName().equalsIgnoreCase(ssokey)) continue;
                        ssojsessionid = biscuit.getValue();
                        break;
                    }
                }
                if (ssojsessionid != null) {
                    cookieHeader = new Header("Cookie", null);
                    cookieHeader.setValue(ssokey + "=" + ssojsessionid);
                    method.setRequestHeader(cookieHeader);
                }
            }
            if ((statusCode = this.client.executeMethod((HttpMethod)method)) != 200) {
                throw new Exception("Error connecting to server with url " + url + ". HTTP status code: " + statusCode);
            }
            String mime = method.getResponseHeader("Content-Type").getValue();
            BufferedImage bufferedImage = ImageTool.readImage((HttpMethod)method, (String)mime);
            return bufferedImage;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public String getUrl() {
        if (this.combinedImageUrl == null) {
            return null;
        }
        return this.getCombinedImageUrl().getUrl();
    }

    public URL getRealUrl() {
        if (this.combinedImageUrl == null) {
            return null;
        }
        return this.getCombinedImageUrl().getRealUrl();
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public void setBufferedImage(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getMaxResponseTime() {
        return this.maxResponseTime;
    }

    public void setMaxResponseTime(int maxResponseTime) {
        this.maxResponseTime = maxResponseTime;
    }

    public CombineImageUrl getCombinedImageUrl() {
        return this.combinedImageUrl;
    }

    public void setCombineImageUrl(CombineImageUrl ciu) {
        this.combinedImageUrl = ciu;
    }
}

