/*
 * Decompiled with CFR 0.152.
 */
package nl.viewer.image;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import nl.viewer.image.Bbox;
import nl.viewer.image.CombineImageSettings;
import nl.viewer.image.CombineImageWkt;
import nl.viewer.image.FeatureStyle;
import nl.viewer.image.ImageBbox;
import nl.viewer.image.ReferencedImage;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.geometry.jts.LiteShape;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

/*
 * Exception performing whole class analysis ignored.
 */
public class ImageTool {
    private static final Log log = LogFactory.getLog(ImageTool.class);
    private BufferedImage bi;
    public static final String TIFF = "image/tiff";
    public static final String GIF = "image/gif";
    public static final String JPEG = "image/jpeg";
    public static final String PNG = "image/png";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readImage(HttpMethod method, String mime) throws Exception {
        ImageReader ir = null;
        BufferedImage i = null;
        try {
            String mimeType;
            if (mime.indexOf(";") != -1) {
                mime = mime.substring(0, mime.indexOf(";"));
            }
            if ((mimeType = ImageTool.getMimeType((String)mime)) == null) {
                mimeType = "image/png";
            }
            if (mimeType == null) {
                log.error((Object)("Response from server not understood (mime = " + mime + "): " + method.getResponseBodyAsString()));
                throw new Exception("Response from server not understood (mime = " + mime + "): " + method.getResponseBodyAsString());
            }
            ir = ImageTool.getReader((String)mimeType);
            if (ir == null) {
                log.error((Object)("no reader available for imageformat: " + mimeType.substring(mimeType.lastIndexOf("/") + 1)));
                throw new Exception("no reader available for imageformat: " + mimeType.substring(mimeType.lastIndexOf("/") + 1));
            }
            InputStream is = method.getResponseBodyAsStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int bytesRead = 0;
            byte[] buffer = new byte[2048];
            while (bytesRead != -1) {
                bytesRead = is.read(buffer, 0, buffer.length);
                if (bytesRead <= 0) continue;
                baos.write(buffer, 0, bytesRead);
            }
            ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(baos.toByteArray()));
            ir.setInput(stream, true);
            i = ir.read(0);
            if (!i.getColorModel().hasAlpha() && mimeType.toLowerCase().contains("png")) {
                log.debug((Object)"If the print shows up with a white (or other non-transparent) background, this must be fixed here: the original image has no alpha, but a background color. Here some code could filter that out. Look at the commit history for guidance.");
            }
        }
        finally {
            if (ir != null) {
                ir.dispose();
            }
        }
        return i;
    }

    public static void writeImage(BufferedImage image, String mime, OutputStream os) throws Exception {
        String mimeType = ImageTool.getMimeType((String)mime);
        if (mimeType == null) {
            log.error((Object)("unsupported mime type: " + mime));
            throw new Exception("unsupported mime type: " + mime);
        }
        if (mime.equals("image/tiff")) {
            ImageTool.writeTIFFImage((BufferedImage)image, (OutputStream)os);
        } else {
            ImageTool.writeOtherImage((BufferedImage)image, (OutputStream)os, (String)mimeType.substring(mimeType.lastIndexOf("/") + 1));
        }
    }

    public static BufferedImage drawGeometries(BufferedImage bi, CombineImageSettings settings) throws Exception {
        int srid = 28992;
        if (settings.getSrid() != null) {
            srid = settings.getSrid();
        }
        int width = 500;
        int height = 500;
        ImageBbox imbbox = settings.getRequestBbox();
        if (imbbox.getWidth() != null && imbbox.getHeight() != null) {
            width = imbbox.getWidth();
            height = imbbox.getHeight();
        } else {
            Integer[] hw = settings.getWidthAndHeightFromUrls();
            if (hw != null && hw.length == 2) {
                width = hw[0];
                height = hw[1];
            }
        }
        Bbox bbox = imbbox.getBbox();
        if (bbox == null) {
            bbox = settings.getBbox();
        }
        if (bbox == null) {
            bbox = settings.getBboxFromUrls();
        }
        if (bbox == null) {
            log.error((Object)"No BBOX found");
            throw new Exception("Can't find bbox in settings or URL");
        }
        return ImageTool.drawGeometries((BufferedImage)bi, (CombineImageSettings)settings, (int)srid, (Bbox)bbox, (int)width, (int)height);
    }

    public static BufferedImage drawGeometries(BufferedImage bi, CombineImageSettings settings, int srid, Bbox bbox, int width, int height) throws Exception {
        List wktGeoms = settings.getWktGeoms();
        if (wktGeoms == null || wktGeoms.size() <= 0) {
            return bi;
        }
        BufferedImage newBufIm = new BufferedImage(width, height, 3);
        Graphics2D gbi = newBufIm.createGraphics();
        HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
        hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        RenderingHints rh = new RenderingHints(hints);
        gbi.setRenderingHints(rh);
        gbi.drawImage((Image)bi, 0, 0, null);
        Font font = gbi.getFont().deriveFont(1, gbi.getFont().getSize());
        int yoffset = gbi.getFontMetrics().getHeight() / 2;
        for (int i = 0; i < wktGeoms.size(); ++i) {
            gbi.setComposite(AlphaComposite.getInstance(3, 0.5f));
            CombineImageWkt ciw = (CombineImageWkt)wktGeoms.get(i);
            FeatureStyle fs = ciw.getStyle();
            log.debug((Object)("draw geomentry: " + ciw + " using style: " + fs));
            font = font.deriveFont(fs.getFontSize().floatValue());
            gbi.setFont(font);
            float strokeWidth = fs.getStrokeWidth().floatValue();
            double pointRadius = fs.getPointRadius();
            gbi.setStroke(new BasicStroke(strokeWidth));
            gbi.setComposite(AlphaComposite.getInstance(3, fs.getFillOpacity().floatValue()));
            gbi.setColor(fs.getFillColor());
            String wktGeom = ciw.getWktGeom();
            Geometry geom = ImageTool.geometrieFromText((String)wktGeom, (int)srid);
            Shape shape = ImageTool.createImage((Geometry)geom, (int)srid, (Bbox)bbox, (int)width, (int)height);
            java.awt.Point centerPoint = null;
            if (geom instanceof Polygon || geom instanceof MultiPolygon) {
                gbi.setComposite(AlphaComposite.getInstance(3, fs.getFillOpacity().floatValue()));
                gbi.fill(shape);
                gbi.setColor(fs.getStrokeColor());
                gbi.setComposite(AlphaComposite.getInstance(3, fs.getStrokeOpacity().floatValue()));
                gbi.draw(shape);
            } else if (geom instanceof Point) {
                int pointwidth = (int)pointRadius * 2;
                int pointheight = (int)pointRadius * 2;
                int xpointoffset = -pointwidth / 2;
                int ypointoffset = -pointheight / 2;
                centerPoint = ImageTool.calculateCenter((Shape)shape, (int)srid, (Bbox)bbox, (int)width, (int)height, (int)xpointoffset, (int)ypointoffset);
                AffineTransform at = gbi.getTransform();
                Shape s = fs.getGraphicName() != null && !fs.getGraphicName().isEmpty() ? ImageTool.drawPointGraphic((java.awt.Point)centerPoint, (FeatureStyle)fs, (int)xpointoffset, (int)ypointoffset, (Graphics2D)gbi) : new Ellipse2D.Double(centerPoint.getX(), centerPoint.getY(), pointwidth, pointheight);
                gbi.setComposite(AlphaComposite.getInstance(3, fs.getFillOpacity().floatValue()));
                gbi.fill(s);
                gbi.draw(s);
                gbi.setTransform(at);
            } else if (geom instanceof LineString) {
                BasicStroke stroke;
                String dash = fs.getStrokeDashstyle();
                Color strokecolor = fs.getStrokeColor();
                gbi.setColor(strokecolor);
                switch (dash) {
                    case "dot": {
                        stroke = new BasicStroke(strokeWidth, 0, 2, 0.0f, new float[]{3.0f, 10.0f}, 0.0f);
                        break;
                    }
                    case "dash": {
                        stroke = new BasicStroke(strokeWidth, 0, 2, 0.0f, new float[]{13.0f, 7.0f}, 0.0f);
                        break;
                    }
                    default: {
                        stroke = new BasicStroke(strokeWidth);
                    }
                }
                gbi.setStroke(stroke);
                gbi.setComposite(AlphaComposite.getInstance(3, fs.getStrokeOpacity().floatValue()));
                gbi.draw(shape);
            }
            if (ciw.getLabel() == null || ciw.getLabel().isEmpty()) continue;
            gbi.setComposite(AlphaComposite.getInstance(3, 1.0f));
            int xoffset = -1 * (gbi.getFontMetrics().stringWidth(ciw.getLabel()) / 2);
            if (centerPoint == null) {
                centerPoint = ImageTool.calculateCenter((Shape)shape, (int)srid, (Bbox)bbox, (int)width, (int)height, (int)0, (int)0);
            }
            AffineTransform t = gbi.getTransform();
            double rotation = fs.getRotation();
            AffineTransform rot = new AffineTransform(t);
            rot.rotate(Math.toRadians(rotation), centerPoint.getX(), centerPoint.getY());
            double labelXOffset = fs.getLabelXOffset();
            double labelYOffset = fs.getLabelYOffset();
            centerPoint.translate(xoffset + (int)labelXOffset, yoffset - (int)labelYOffset);
            gbi.setColor(fs.getFontColor());
            BufferedImage b = ImageTool.createStringImage((Graphics2D)gbi, (String)ciw.getLabel(), (FeatureStyle)fs);
            rot.translate(centerPoint.getX(), centerPoint.getY());
            gbi.drawImage(b, rot, null);
            gbi.setTransform(t);
        }
        gbi.dispose();
        return newBufIm;
    }

    private static BufferedImage createStringImage(Graphics2D g, String s, FeatureStyle fs) {
        int w = g.getFontMetrics().stringWidth(s) + 8;
        int h = g.getFontMetrics().getHeight();
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D gbi = image.createGraphics();
        gbi.setFont(g.getFont().deriveFont(fs.getFontSize().floatValue()));
        gbi.setColor(fs.getLabelOutlineColor());
        int halosize = fs.getLabelOutlineWidth();
        gbi.drawString(s, 0, h - g.getFontMetrics().getDescent() - halosize);
        gbi.drawString(s, 0, h - g.getFontMetrics().getDescent() + halosize);
        gbi.drawString(s, -halosize, h - g.getFontMetrics().getDescent());
        gbi.drawString(s, halosize, h - g.getFontMetrics().getDescent());
        gbi.setColor(fs.getFontColor());
        gbi.drawString(s, 0, h - g.getFontMetrics().getDescent());
        gbi.dispose();
        return image;
    }

    private static Shape drawPointGraphic(java.awt.Point origin, FeatureStyle fs, int xoffset, int yoffset, Graphics2D gbi) {
        Shape s = null;
        switch (fs.getGraphicName()) {
            case "square": {
                s = ImageTool.createSquare((java.awt.Point)origin, (FeatureStyle)fs, (int)xoffset, (int)yoffset, (Graphics2D)gbi);
                break;
            }
            case "circle": {
                int length = fs.getPointRadius().intValue() * 2;
                s = new Ellipse2D.Double(origin.getX(), origin.getY(), length, length);
                break;
            }
            case "triangle": {
                s = ImageTool.createTriangle((java.awt.Point)origin, (FeatureStyle)fs, (int)xoffset, (int)yoffset, (Graphics2D)gbi);
                break;
            }
            case "cross": {
                s = ImageTool.createCross((java.awt.Point)origin, (FeatureStyle)fs, (int)xoffset, (int)yoffset, (Graphics2D)gbi);
                break;
            }
            case "x": {
                s = ImageTool.createX((java.awt.Point)origin, (FeatureStyle)fs, (int)xoffset, (int)yoffset, (Graphics2D)gbi);
                break;
            }
            case "star": {
                s = ImageTool.createStar((java.awt.Point)origin, (FeatureStyle)fs, (int)xoffset, (int)yoffset, (Graphics2D)gbi);
                break;
            }
            default: {
                log.error((Object)("Cannot create type: " + fs.getGraphicName() + ". Creating default circle."));
                s = new Ellipse2D.Double(origin.getX(), origin.getY(), fs.getPointRadius().intValue(), fs.getPointRadius().intValue());
            }
        }
        return s;
    }

    private static Shape createStar(java.awt.Point origin, FeatureStyle fs, int xoffset, int yoffset, Graphics2D gbi) {
        int originX = (int)origin.getX();
        int originY = (int)origin.getY();
        int sideLength = fs.getPointRadius().intValue() / 2;
        int[] x = new int[]{originX + 1 * sideLength, originX + 2 * sideLength, originX + 0 * sideLength, originX + 3 * sideLength, originX + 4 * sideLength, originX + 5 * sideLength, originX + 8 * sideLength, originX + 6 * sideLength, originX + 7 * sideLength, originX + 4 * sideLength, originX + 1 * sideLength};
        int[] y = new int[]{originY + 8 * sideLength, originY + 5 * sideLength, originY + 3 * sideLength, originY + 3 * sideLength, originY + 0 * sideLength, originY + 3 * sideLength, originY + 3 * sideLength, originY + 5 * sideLength, originY + 8 * sideLength, originY + 6 * sideLength, originY + 8 * sideLength};
        java.awt.Polygon s = new java.awt.Polygon(x, y, x.length);
        return s;
    }

    private static Shape createCross(java.awt.Point origin, FeatureStyle fs, int xoffset, int yoffset, Graphics2D gbi) {
        int originX = (int)origin.getX();
        int originY = (int)origin.getY();
        int sideLength = fs.getPointRadius().intValue();
        int[] x = new int[]{originX + 1 * sideLength, originX + 2 * sideLength, originX + 2 * sideLength, originX + 3 * sideLength, originX + 3 * sideLength, originX + 2 * sideLength, originX + 2 * sideLength, originX + 1 * sideLength, originX + 1 * sideLength, originX + 0 * sideLength, originX + 0 * sideLength, originX + 1 * sideLength, originX + 1 * sideLength};
        int[] y = new int[]{originY + 3 * sideLength, originY + 3 * sideLength, originY + 2 * sideLength, originY + 2 * sideLength, originY + 1 * sideLength, originY + 1 * sideLength, originY + 0 * sideLength, originY + 0 * sideLength, originY + 1 * sideLength, originY + 1 * sideLength, originY + 2 * sideLength, originY + 2 * sideLength, originY + 3 * sideLength};
        java.awt.Polygon s = new java.awt.Polygon(x, y, x.length);
        return s;
    }

    private static Shape createX(java.awt.Point origin, FeatureStyle fs, int xoffset, int yoffset, Graphics2D gbi) {
        int originX = (int)origin.getX();
        int originY = (int)origin.getY();
        int sideLength = fs.getPointRadius().intValue();
        int[] x = new int[]{originX + 1 * sideLength, originX + 2 * sideLength, originX + 3 * sideLength, originX + 4 * sideLength, originX + 3 * sideLength, originX + 4 * sideLength, originX + 3 * sideLength, originX + 2 * sideLength, originX + 1 * sideLength, originX + 0 * sideLength, originX + 1 * sideLength, originX + 0 * sideLength, originX + 1 * sideLength};
        int[] y = new int[]{originY + 0 * sideLength, originY + 1 * sideLength, originY + 0 * sideLength, originY + 1 * sideLength, originY + 2 * sideLength, originY + 3 * sideLength, originY + 4 * sideLength, originY + 3 * sideLength, originY + 4 * sideLength, originY + 3 * sideLength, originY + 2 * sideLength, originY + 1 * sideLength, originY + 0 * sideLength};
        java.awt.Polygon s = new java.awt.Polygon(x, y, x.length);
        return s;
    }

    private static Shape createSquare(java.awt.Point origin, FeatureStyle fs, int xoffset, int yoffset, Graphics2D gbi) {
        int originX = (int)origin.getX();
        int originY = (int)origin.getY();
        int length = fs.getPointRadius().intValue() * 2;
        Rectangle s = new Rectangle(originX, originY, length, length);
        return s;
    }

    private static Shape createTriangle(java.awt.Point origin, FeatureStyle fs, int xoffset, int yoffset, Graphics2D gbi) {
        double rotation = fs.getRotation();
        int length = fs.getPointRadius().intValue() * 2;
        int halfLength = length / 2;
        int originX = (int)origin.getX();
        int originY = (int)origin.getY();
        int ycorrected = rotation % 360.0 < 180.0 ? yoffset * 2 : yoffset;
        AffineTransform rot = gbi.getTransform();
        rot.rotate(Math.toRadians(rotation), originX - xoffset, originY + length + yoffset);
        gbi.setTransform(rot);
        int[] x = new int[]{originX - halfLength - xoffset, originX - xoffset, originX + halfLength - xoffset};
        int[] y = new int[]{originY + length - ycorrected, originY - ycorrected, originY + length - ycorrected};
        java.awt.Polygon s = new java.awt.Polygon(x, y, 3);
        return s;
    }

    private static java.awt.Point calculateCenter(Shape shape, int srid, Bbox bbox, int width, int height, int xoffset, int yoffset) throws Exception {
        java.awt.Point centerPoint = new java.awt.Point();
        double x = shape.getBounds2D().getCenterX();
        double y = shape.getBounds2D().getCenterY();
        centerPoint.setLocation(x, y);
        centerPoint = ImageTool.transformToScreen((java.awt.Point)centerPoint, (int)srid, (Bbox)bbox, (int)width, (int)height);
        centerPoint.translate(xoffset, yoffset);
        return centerPoint;
    }

    public static Shape createImage(Geometry geometrie, int bboxSrid, Bbox bbox, int width, int height) throws Exception {
        ReferencedEnvelope re = new ReferencedEnvelope(bbox.getMinx(), bbox.getMaxx(), bbox.getMiny(), bbox.getMaxy(), CRS.decode((String)("EPSG:" + bboxSrid)));
        AffineTransform transform = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)re, (Rectangle)new Rectangle(width, height));
        LiteShape ls = new LiteShape(geometrie, transform, false);
        return ls;
    }

    public static java.awt.Point transformToScreen(java.awt.Point source, int bboxSrid, Bbox bbox, int width, int height) throws Exception {
        ReferencedEnvelope re = new ReferencedEnvelope(bbox.getMinx(), bbox.getMaxx(), bbox.getMiny(), bbox.getMaxy(), CRS.decode((String)("EPSG:" + bboxSrid)));
        AffineTransform transform = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)re, (Rectangle)new Rectangle(width, height));
        java.awt.Point result = new java.awt.Point();
        transform.transform(source, result);
        return result;
    }

    public static Geometry geometrieFromText(String wktgeom, int srid) {
        WKTReader wktreader = new WKTReader(new GeometryFactory(new PrecisionModel(), srid));
        try {
            Geometry geom = wktreader.read(wktgeom);
            return geom;
        }
        catch (ParseException p) {
            log.error((Object)("Can't create geomtry from wkt: " + wktgeom), (Throwable)p);
            return null;
        }
    }

    private static void writeTIFFImage(BufferedImage bufferedImage, OutputStream os) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "tif", baos);
        os.write(baos.toByteArray());
    }

    private static void writeOtherImage(BufferedImage bufferedImage, OutputStream os, String extension) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageOutputStream ios = ImageIO.createImageOutputStream(baos);
        ImageIO.write((RenderedImage)bufferedImage, extension, ios);
        os.write(baos.toByteArray());
        ios.flush();
        ios.close();
    }

    public static BufferedImage combineImages(List<ReferencedImage> images, String mime, Integer width, Integer height) {
        if (mime.equals("image/jpeg")) {
            return ImageTool.combineJPGImages(images, (Integer)width, (Integer)height);
        }
        return ImageTool.combineOtherImages(images, (Integer)width, (Integer)height);
    }

    private static BufferedImage combineJPGImages(List<ReferencedImage> images, Integer width, Integer height) {
        if (images.get(0) != null) {
            BufferedImage bi = images.get(0).getImage();
            if (width == null) {
                width = bi.getWidth();
            }
            if (height == null) {
                height = bi.getHeight();
            }
        }
        BufferedImage newBufIm = new BufferedImage(width, height, 1);
        Graphics2D gbi = newBufIm.createGraphics();
        for (ReferencedImage image : images) {
            ImageTool.drawImage((Graphics2D)gbi, (ReferencedImage)image);
        }
        return newBufIm;
    }

    private static BufferedImage combineOtherImages(List<ReferencedImage> images, Integer width, Integer height) {
        if (images.get(0) != null) {
            BufferedImage bi = images.get(0).getImage();
            if (height == null) {
                height = bi.getHeight();
            }
            if (width == null) {
                width = bi.getWidth();
            }
        }
        BufferedImage newBufIm = new BufferedImage(width, height, 3);
        Graphics2D gbi = newBufIm.createGraphics();
        gbi.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        for (int i = 0; i < images.size(); ++i) {
            ReferencedImage image = images.get(i);
            ImageTool.drawImage((Graphics2D)gbi, (ReferencedImage)image);
        }
        return newBufIm;
    }

    private static void drawImage(Graphics2D gbi, ReferencedImage image) {
        if (image.getAlpha() != null) {
            gbi.setComposite(AlphaComposite.getInstance(3, image.getAlpha().floatValue()));
        } else {
            gbi.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
        Integer x = image.getX();
        Integer y = image.getY();
        if (x == null) {
            x = 0;
        }
        if (y == null) {
            y = 0;
        }
        if (image.getHeight() != null && image.getWidth() != null) {
            gbi.drawImage(image.getImage(), x, y, image.getWidth(), image.getHeight(), null);
        } else {
            gbi.drawImage((Image)image.getImage(), x, (int)y, null);
        }
    }

    public static String getMimeType(String mime) {
        if ("image/jpg".equalsIgnoreCase(mime)) {
            mime = "image/jpeg";
        }
        String[] mimeTypes = ImageIO.getReaderMIMETypes();
        for (int i = 0; i < mimeTypes.length; ++i) {
            if (!mimeTypes[i].equalsIgnoreCase(mime)) continue;
            return mimeTypes[i];
        }
        return null;
    }

    private static ImageReader getReader(String mime) {
        if (mime.equals("image/jpeg") || mime.equals("image/png")) {
            return ImageTool.getJPGOrPNGReader((String)mime);
        }
        return ImageTool.getGIFOrTIFFReader((String)mime);
    }

    private static ImageReader getJPGOrPNGReader(String mime) {
        Iterator<ImageReader> it = ImageIO.getImageReadersByMIMEType(mime);
        ImageReader imTest = null;
        String name = null;
        while (it.hasNext()) {
            imTest = it.next();
            name = imTest.getClass().getPackage().getName();
            String generalPackage = name.substring(0, name.lastIndexOf("."));
            if (!generalPackage.equalsIgnoreCase("com.sun.media.imageioimpl.plugins")) continue;
        }
        return imTest;
    }

    private static ImageReader getGIFOrTIFFReader(String mime) {
        Iterator<ImageReader> it = ImageIO.getImageReadersByMIMEType(mime);
        ImageReader imTest = null;
        String name = null;
        while (it.hasNext()) {
            imTest = it.next();
            name = imTest.getClass().getPackage().getName();
        }
        return imTest;
    }

    private ImageWriter getWriter(String mime) {
        if (mime.equals("image/jpeg") || mime.equals("image/png")) {
            return this.getJPGOrPNGWriter(mime);
        }
        return this.getGIFOrTIFFWriter(mime);
    }

    private ImageWriter getJPGOrPNGWriter(String mime) {
        Iterator<ImageReader> it = ImageIO.getImageReadersByMIMEType(mime);
        ImageWriter imTest = null;
        while (it.hasNext()) {
            imTest = (ImageWriter)((Object)it.next());
            String name = imTest.getClass().getPackage().getName();
            String generalPackage = name.substring(0, name.lastIndexOf("."));
            if (!generalPackage.equalsIgnoreCase("com.sun.media.imageioimpl.plugins")) continue;
        }
        return imTest;
    }

    private ImageWriter getGIFOrTIFFWriter(String mime) {
        Iterator<ImageReader> it = ImageIO.getImageReadersByMIMEType(mime);
        ImageWriter imTest = null;
        while (it.hasNext()) {
            imTest = (ImageWriter)((Object)it.next());
        }
        return imTest;
    }

    public static BufferedImage changeColor(BufferedImage im, Color color, Color newColor) {
        for (int x = 0; x < im.getWidth(); ++x) {
            for (int y = 0; y < im.getHeight(); ++y) {
                if (im.getRGB(x, y) != color.getRGB()) continue;
                im.setRGB(x, y, newColor.getRGB());
            }
        }
        return im;
    }
}

