/*
 * Decompiled with CFR 0.152.
 */
package nl.viewer.image;

import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.xpath.XPathExpressionException;
import nl.viewer.image.CombineImageUrl;
import nl.viewer.image.ImageCollector;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom2.JDOMException;

public abstract class PrePostImageCollector
extends ImageCollector {
    private static final Log log = LogFactory.getLog(PrePostImageCollector.class);
    private String body;

    public PrePostImageCollector(CombineImageUrl ciu, int maxResponseTime, HttpClient client, HttpServletRequest req) {
        super(ciu, maxResponseTime, client, req);
        this.body = ciu.getBody();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage loadImage(String url, String user, String pass) throws IOException, Exception {
        String theUrl = url;
        if (this.getBody() != null) {
            PostMethod method = null;
            try {
                method = new PostMethod(url);
                method.setRequestEntity((RequestEntity)new StringRequestEntity(this.getBody()));
                int statusCode = this.client.executeMethod((HttpMethod)method);
                if (statusCode != 200) {
                    throw new Exception("Error connecting to server. HTTP status code: " + statusCode);
                }
                String returnXML = method.getResponseBodyAsString();
                theUrl = this.getUrlFromXML(returnXML);
                if (theUrl == null && returnXML != null) {
                    throw new Exception("Error getting the correct url. Server returned: \n" + returnXML);
                }
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
        return super.loadImage(theUrl, user, pass);
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    protected abstract String getUrlFromXML(String var1) throws XPathExpressionException, JDOMException, IOException;
}

