/*
 * Decompiled with CFR 0.152.
 */
package nl.viewer.stripes;

import java.io.Reader;
import java.io.StringReader;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.i18n.LocalizableActionBean;
import nl.viewer.config.services.GeoService;
import nl.viewer.config.services.Layer;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/service/feature")
@StrictBinding
public class FeatureActionBean
extends LocalizableActionBean
implements ActionBean {
    private ActionBeanContext context;
    @Validate
    private GeoService service;
    @Validate
    private String layer;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getLayer() {
        return this.layer;
    }

    public void setLayer(String layer) {
        this.layer = layer;
    }

    public GeoService getService() {
        return this.service;
    }

    public void setService(GeoService service) {
        this.service = service;
    }

    public Resolution getLayerFeatureType() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        Object error = null;
        if (this.service == null || this.layer == null) {
            error = this.getBundle().getString("viewer.featureactionbean.1");
        } else {
            EntityManager em = Stripersist.getEntityManager();
            this.service.loadLayerTree(em);
            Layer l = this.service.getLayer(this.layer, em);
            if (l == null) {
                error = "Can't find layer " + this.layer;
            } else {
                json.put("featureType", l.getFeatureType() == null ? null : l.getFeatureType().toJSONObject());
                json.put("success", (Object)Boolean.TRUE);
            }
        }
        if (error != null) {
            json.put("error", error);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }
}

