/*
 * Decompiled with CFR 0.152.
 */
package nl.viewer.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.i18n.LocalizableActionBean;
import nl.viewer.config.services.WMSService;
import nl.viewer.helpers.services.ArcGISServiceHelper;
import nl.viewer.helpers.services.WMSServiceHelper;
import nl.web.WaitPageStatus;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/service/info")
@StrictBinding
public class ServiceActionBean
extends LocalizableActionBean
implements ActionBean {
    private ActionBeanContext context;
    @Validate
    private String protocol;
    @Validate
    private String url;
    @Validate
    private String serviceName;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Resolution info() throws JSONException {
        EntityManager em;
        WMSService service;
        Object error;
        JSONObject json;
        block10: {
            json = new JSONObject();
            json.put("success", (Object)Boolean.FALSE);
            error = null;
            service = null;
            em = Stripersist.getEntityManager();
            if (this.protocol == null || this.url == null) {
                error = this.getBundle().getString("viewer.serviceactionbean.1");
            } else {
                HashMap params = new HashMap();
                try {
                    if (this.protocol.equals("wms")) {
                        service = WMSServiceHelper.loadFromUrl((String)this.url, params, (WaitPageStatus)new WaitPageStatus(), (EntityManager)em);
                    } else if (this.protocol.equals("arcgis")) {
                        service = ArcGISServiceHelper.loadFromUrl((String)this.url, params, (WaitPageStatus)new WaitPageStatus(), (EntityManager)em);
                    } else {
                        error = this.getBundle().getString("viewer.serviceactionbean.2");
                    }
                }
                catch (Exception e) {
                    error = "Error loading service " + e.toString();
                    if (e.getCause() == null) break block10;
                    error = (String)error + "; cause: " + e.getCause().toString();
                }
            }
        }
        if (service != null) {
            json.put("success", (Object)Boolean.TRUE);
            json.put("service", (Object)service.toJSONObject(true, em));
        } else {
            json.put("success", (Object)Boolean.FALSE);
            json.put("error", error);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }
}

