/*
 * Decompiled with CFR 0.152.
 */
package nl.viewer.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.viewer.audit.AuditMessageObject;
import nl.viewer.audit.Auditable;
import nl.viewer.config.app.Application;
import nl.viewer.config.app.ApplicationLayer;
import nl.viewer.config.app.ConfiguredComponent;
import nl.viewer.config.security.Authorizations;
import nl.viewer.config.services.Layer;
import nl.viewer.config.services.SimpleFeatureType;
import nl.viewer.config.services.SolrConf;
import nl.viewer.helpers.featuresources.FeatureSourceFactoryHelper;
import nl.viewer.stripes.LocalizableApplicationActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.FeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.identity.FeatureIdImpl;
import org.json.JSONArray;
import org.json.JSONObject;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.precision.GeometryPrecisionReducer;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/simplify")
@StrictBinding
public class SimplifyFeatureActionBean
extends LocalizableApplicationActionBean
implements Auditable {
    private static final Log LOG = LogFactory.getLog(SimplifyFeatureActionBean.class);
    private ActionBeanContext context;
    @Validate
    private SimpleFeatureType sft;
    @Validate
    private SolrConf solrconfig;
    @Validate
    private ApplicationLayer appLayer;
    @Validate
    private Application application;
    @Validate
    private String featureId;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public ApplicationLayer getAppLayer() {
        return this.appLayer;
    }

    public void setAppLayer(ApplicationLayer appLayer) {
        this.appLayer = appLayer;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public void setFeatureId(String featureId) {
        this.featureId = featureId;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public SimpleFeatureType getSft() {
        return this.sft;
    }

    public void setSft(SimpleFeatureType sft) {
        this.sft = sft;
    }

    public SolrConf getSolrconfig() {
        return this.solrconfig;
    }

    public void setSolrconfig(SolrConf solrconfig) {
        this.solrconfig = solrconfig;
    }

    public AuditMessageObject getAuditMessageObject() {
        AuditMessageObject aum = new AuditMessageObject();
        if (this.solrconfig != null) {
            aum.addMessage((Object)("SolrConfig: " + this.solrconfig.getId()));
        }
        if (this.appLayer != null) {
            aum.addMessage((Object)("appLayer: " + this.appLayer.getId()));
        }
        aum.addMessage((Object)("application: " + this.application.getId()));
        aum.addMessage((Object)("featureId: " + this.featureId));
        if (this.sft != null) {
            aum.addMessage((Object)("sft: " + this.sft.getId()));
        }
        return aum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DefaultHandler
    public Resolution simplify() {
        JSONObject result = new JSONObject();
        result.put("success", false);
        FeatureSource fs = null;
        if (this.checkAuthorizations(result)) {
            try {
                JSONObject json = new JSONObject();
                json.put("success", (Object)Boolean.FALSE);
                EntityManager em = Stripersist.getEntityManager();
                if (this.appLayer != null) {
                    Layer layer = this.appLayer.getService().getLayer(this.appLayer.getLayerName(), em);
                    if (layer == null) {
                        throw new Exception(this.getBundle().getString("viewer.simplifyfeatureactionbean.4"));
                    }
                    if (layer.getFeatureType() == null) {
                        throw new Exception(this.getBundle().getString("viewer.simplifyfeatureactionbean.5"));
                    }
                    this.sft = layer.getFeatureType();
                }
                fs = FeatureSourceFactoryHelper.openGeoToolsFeatureSource((SimpleFeatureType)this.sft);
                FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
                Id filter = ff.id(new FeatureId[]{new FeatureIdImpl(this.featureId)});
                FeatureIterator it = fs.getFeatures((Filter)filter).features();
                SimpleFeature sf = null;
                while (it.hasNext()) {
                    sf = (SimpleFeature)it.next();
                }
                if (sf != null) {
                    Geometry geom = (Geometry)sf.getDefaultGeometry();
                    result.put("geom", (Object)this.simplify(geom));
                    result.put("success", true);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Cannot simplify feature: ", (Throwable)ex);
                result.put("message", (Object)ex.getLocalizedMessage());
            }
            finally {
                if (fs != null) {
                    fs.getDataStore().dispose();
                }
            }
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(result.toString()));
    }

    private String simplify(Geometry geom) throws UnsupportedEncodingException {
        double simplify;
        PrecisionModel pm = new PrecisionModel(100.0);
        GeometryPrecisionReducer gpr = new GeometryPrecisionReducer(pm);
        geom = gpr.reduce(geom);
        Geometry bbox = geom.getEnvelope();
        int megabytes = 1994752;
        String geomTxt = geom.toText();
        for (simplify = 1.0; (geomTxt.getBytes("UTF-8").length > megabytes || geom.getCoordinates().length > 600) && simplify < 9999.0; simplify = 10.0 * simplify) {
            LOG.debug((Object)("Simplify selected feature geometry with distance of: " + simplify));
            geom = TopologyPreservingSimplifier.simplify((Geometry)geom, (double)simplify);
            geom = gpr.reduce(geom);
            geomTxt = geom.toText();
        }
        if (simplify > 9999.0) {
            return bbox.toText();
        }
        return geomTxt;
    }

    private boolean checkAuthorizations(JSONObject result) {
        if (this.appLayer == null && this.sft == null) {
            result.put("message", (Object)this.getBundle().getString("viewer.simplifyfeatureactionbean.1"));
            return false;
        }
        EntityManager em = Stripersist.getEntityManager();
        if (this.appLayer != null) {
            if (!Authorizations.isAppLayerWriteAuthorized((Application)this.application, (ApplicationLayer)this.appLayer, (HttpServletRequest)this.context.getRequest(), (EntityManager)em)) {
                result.put("message", (Object)this.getBundle().getString("viewer.simplifyfeatureactionbean.2"));
                return false;
            }
            return true;
        }
        if (this.sft != null) {
            Set comps = this.application.getComponents();
            for (ConfiguredComponent comp : comps) {
                if (!comp.getClassName().equals("viewer.components.Search") && !comp.getClassName().equals("viewer.components.DirectSearch")) continue;
                JSONObject config = new JSONObject(comp.getConfig());
                JSONArray searchConfigs = config.getJSONArray("searchconfigs");
                for (JSONObject searchConfig : searchConfigs) {
                    String type = searchConfig.getString("type");
                    if (!type.equals("solr") && !type.equals("attributesource")) continue;
                    JSONObject solrConfigs = searchConfig.optJSONObject("solrConfig");
                    if (solrConfigs == null) {
                        solrConfigs = searchConfig.optJSONObject("asConfig");
                    }
                    Set configs = solrConfigs.keySet();
                    for (String c : configs) {
                        JSONObject sc = solrConfigs.getJSONObject(c);
                        if ((long)sc.getInt("solrConfigid") != this.solrconfig.getId()) continue;
                        return true;
                    }
                }
            }
            result.put("message", (Object)this.getBundle().getString("viewer.simplifyfeatureactionbean.3"));
        }
        return false;
    }
}

