/*
 * Decompiled with CFR 0.152.
 */
package nl.viewer.userlayer;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public interface DataBase {
    public static final Log LOG = LogFactory.getLog(DataBase.class);
    public static final String PREFIX = "ul_";
    public static final String INVALID_MSG = "Validatiefout voor selectiefilter (%s)";

    public String preValidateView(String var1, String var2);

    public String getGtPkMetadataDDL();

    public boolean createView(String var1, String var2, String var3, String var4);

    public boolean dropView(String var1);

    public boolean addToGtPKMetadata(String var1, String var2);

    public boolean removeFromGtPKMetadata(String var1);

    public void close();

    default public String createViewName(String tableName) {
        return (PREFIX + tableName + '_' + UUID.randomUUID()).replace('-', '_');
    }

    default public List<String> getPrimaryKey(String tableName, String schema, Connection connection) throws SQLException {
        ArrayList<String> keys = new ArrayList<String>();
        DatabaseMetaData meta = connection.getMetaData();
        try (ResultSet primaryKeys = meta.getPrimaryKeys(null, schema, tableName);){
            while (primaryKeys.next()) {
                keys.add(primaryKeys.getString("COLUMN_NAME"));
            }
        }
        return keys;
    }

    default public List<String> getSchema(String tableName, Connection connection) throws SQLException {
        ArrayList<String> keys = new ArrayList<String>();
        DatabaseMetaData meta = connection.getMetaData();
        try (ResultSet tables = meta.getTables(null, null, tableName, new String[]{"TABLE", "VIEW"});){
            while (tables.next()) {
                keys.add(tables.getString("TABLE_SCHEM"));
            }
        }
        return keys;
    }

    default public boolean doesGtPkMetadataExists(Connection connection) throws SQLException {
        DatabaseMetaData dbm = connection.getMetaData();
        try (ResultSet tables = dbm.getTables(null, null, "gt_pk_metadata", null);){
            boolean bl = tables.next();
            return bl;
        }
    }

    default public boolean createGtPkMetadata(Connection connection) {
        boolean result;
        String query = this.getGtPkMetadataDDL();
        LOG.debug((Object)("try to create gt_pk_metadata table and query " + query));
        try (PreparedStatement ps = connection.prepareStatement(String.format(query, new Object[0]));){
            result = 0 == ps.executeUpdate();
        }
        catch (SQLException throwables) {
            LOG.error((Object)("Probleem tijdens maken van view: " + throwables.getLocalizedMessage()));
            result = false;
        }
        return result;
    }
}

