/*
 * Decompiled with CFR 0.152.
 */
package nl.viewer.userlayer;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import nl.viewer.userlayer.DataBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PostgreSQL
implements DataBase {
    private static final Log LOG = LogFactory.getLog(PostgreSQL.class);
    private static final String SELECT_SQL = " SELECT * FROM %s %s ";
    private static final String CREATE_SQL = "CREATE OR REPLACE VIEW %s AS  SELECT * FROM %s %s ";
    private static final String DROP_SQL = "DROP VIEW IF EXISTS %s";
    private static final String COMMENTS_SQL = "COMMENT ON VIEW %s IS '%s'";
    private static final String INSERT_GT_PK_METADATA = "INSERT INTO gt_pk_metadata (table_schema, table_name, pk_column, pk_column_idx, pk_policy) values ('%s','%s', '%s', %d, 'autogenerated')";
    private static final String REMOVE_GT_PK_METADATA = "DELETE FROM gt_pk_metadata where table_schema = '%s' and table_name = '%s'";
    private final Connection connection;
    private final String GT_PK_METADATA_DDL = "CREATE TABLE gt_pk_metadata (  table_schema VARCHAR(32) NOT NULL,  table_name VARCHAR(120) NOT NULL,  pk_column VARCHAR(32) NOT NULL,  pk_column_idx INTEGER,  pk_policy VARCHAR(32),  pk_sequence VARCHAR(64),  unique (table_schema, table_name, pk_column),  check (pk_policy in ('sequence', 'assigned', 'autogenerated')))";

    public PostgreSQL(Connection connection) {
        this.connection = connection;
    }

    public String preValidateView(String tableName, String filterSQL) {
        String result = null;
        try (PreparedStatement ps = this.connection.prepareStatement(String.format(SELECT_SQL, tableName, filterSQL));){
            ps.setFetchSize(1);
            ps.setMaxRows(1);
            ps.execute();
        }
        catch (SQLException throwables) {
            LOG.error((Object)throwables.getLocalizedMessage());
            result = String.format("Validatiefout voor selectiefilter (%s)", throwables.getLocalizedMessage()).replaceAll("\n", " ");
        }
        return result;
    }

    public String getGtPkMetadataDDL() {
        return "CREATE TABLE gt_pk_metadata (  table_schema VARCHAR(32) NOT NULL,  table_name VARCHAR(120) NOT NULL,  pk_column VARCHAR(32) NOT NULL,  pk_column_idx INTEGER,  pk_policy VARCHAR(32),  pk_sequence VARCHAR(64),  unique (table_schema, table_name, pk_column),  check (pk_policy in ('sequence', 'assigned', 'autogenerated')))";
    }

    public boolean createView(String viewName, String tableName, String filterSQL, String comments) {
        boolean result;
        LOG.debug((Object)("try to create view " + viewName + " using table " + tableName + " and query " + filterSQL));
        try (PreparedStatement ps = this.connection.prepareStatement(String.format(CREATE_SQL, viewName, tableName, filterSQL));
             PreparedStatement psComment = this.connection.prepareStatement(String.format(COMMENTS_SQL, viewName, comments.replaceAll("'", "''")));){
            result = 0 == ps.executeUpdate();
            psComment.executeUpdate();
            if (result) {
                this.addToGtPKMetadata(viewName, tableName);
            }
        }
        catch (SQLException throwables) {
            LOG.error((Object)("Probleem tijdens maken van view: " + throwables.getLocalizedMessage()));
            result = false;
        }
        return result;
    }

    public boolean dropView(String viewName) {
        boolean result;
        this.removeFromGtPKMetadata(viewName);
        LOG.debug((Object)("try to drop view " + viewName));
        try (PreparedStatement ps = this.connection.prepareStatement(String.format(DROP_SQL, viewName));){
            result = 0 == ps.executeUpdate();
        }
        catch (SQLException throwables) {
            LOG.error((Object)("Probleem tijdens droppen van view: " + throwables.getLocalizedMessage()));
            result = false;
        }
        return result;
    }

    public boolean addToGtPKMetadata(String viewName, String table) {
        try {
            if (!this.doesGtPkMetadataExists(this.connection)) {
                this.createGtPkMetadata(this.connection);
            }
        }
        catch (SQLException throwables) {
            LOG.error((Object)("Cannot check if gt_pk_metadata exists or create it: " + throwables.getLocalizedMessage()));
        }
        boolean result = false;
        LOG.debug((Object)("try to insert view " + viewName + " into gt_pk_metadata"));
        try {
            List schemas = this.getSchema(table, this.connection);
            if (schemas.isEmpty()) {
                LOG.error((Object)("Cannot add view to gt_pk_metadatatable. Cannot retrieve schema for " + table));
                return false;
            }
            String schema = (String)schemas.get(0);
            List pks = this.getPrimaryKey(table, schema, this.connection);
            for (int i = 0; i < pks.size(); ++i) {
                String pkColumn = (String)pks.get(i);
                try (PreparedStatement ps = this.connection.prepareStatement(String.format(INSERT_GT_PK_METADATA, schema, viewName, pkColumn, i));){
                    result = 1 == ps.executeUpdate();
                    continue;
                }
                catch (SQLException throwables) {
                    LOG.error((Object)("Probleem tijdens uitvoeren insert: " + String.format(INSERT_GT_PK_METADATA, schema, viewName, pkColumn, i) + ", with error:" + throwables.getLocalizedMessage()));
                }
            }
        }
        catch (Exception throwables) {
            LOG.error((Object)("Probleem tijdens ophalen PK kolom of schemanaam: " + throwables.getLocalizedMessage()));
            result = false;
        }
        return result;
    }

    public boolean removeFromGtPKMetadata(String viewName) {
        boolean result = false;
        LOG.debug((Object)("try to remove view " + viewName + " from gt_pk_metadata"));
        try {
            List schemas = this.getSchema(viewName, this.connection);
            if (schemas.isEmpty()) {
                LOG.error((Object)("Cannot remove view from gt_pk_metadatatable. Cannot retrieve schema for " + viewName));
                return false;
            }
            String schema = (String)schemas.get(0);
            try (PreparedStatement ps = this.connection.prepareStatement(String.format(REMOVE_GT_PK_METADATA, schema, viewName));){
                result = 1 == ps.executeUpdate();
            }
            catch (SQLException throwables) {
                LOG.error((Object)("Probleem tijdens uitvoeren delete: " + String.format(REMOVE_GT_PK_METADATA, schema, viewName) + ", with error:" + throwables.getLocalizedMessage()));
            }
        }
        catch (Exception throwables) {
            LOG.error((Object)("Probleem tijdens ophalen schemanaam: " + throwables.getLocalizedMessage()));
            result = false;
        }
        return result;
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (SQLException throwables) {
            LOG.error((Object)("Probleem tijdens sluiten van connectie: " + throwables.getLocalizedMessage()));
        }
    }
}

