/*
 * Decompiled with CFR 0.152.
 */
package nl.viewer.userlayer;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import nl.viewer.audit.AuditMessageObject;
import nl.viewer.config.ClobElement;
import nl.viewer.config.app.Application;
import nl.viewer.config.app.ApplicationLayer;
import nl.viewer.config.app.Level;
import nl.viewer.config.app.StartLayer;
import nl.viewer.config.services.Category;
import nl.viewer.config.services.FeatureSource;
import nl.viewer.config.services.FeatureTypeRelation;
import nl.viewer.config.services.FeatureTypeRelationKey;
import nl.viewer.config.services.GeoService;
import nl.viewer.config.services.JDBCFeatureSource;
import nl.viewer.config.services.Layer;
import nl.viewer.config.services.SimpleFeatureType;
import nl.viewer.config.services.UpdateResult;
import nl.viewer.config.services.WMSExceptionType;
import nl.viewer.config.services.WMSService;
import nl.viewer.helpers.featuresources.FeatureSourceFactoryHelper;
import nl.viewer.helpers.featuresources.SimpleFeatureTypeHelper;
import nl.viewer.helpers.services.GeoserviceFactoryHelper;
import nl.viewer.helpers.services.WMSServiceHelper;
import nl.viewer.util.SelectedContentCache;
import nl.web.WaitPageStatus;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TailormapDBManager {
    private ApplicationLayer appLayer;
    private ApplicationLayer createdAppLayer;
    private EntityManager entityManager;
    private Application application;
    private String geoserverWorkspace;
    private String baseUrl;
    private Layer layer;
    private String filter;
    private AuditMessageObject auditMessageObject;
    private GeoService service;
    private final DateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
    private static final Log LOG = LogFactory.getLog(TailormapDBManager.class);
    private static final String USERLAYER_NAME = "B3P - Gebruikerslagen (niet aanpassen)";

    public TailormapDBManager(EntityManager entityManager, Application application, ApplicationLayer appLayer, GeoService service, Layer layer, String filter, String geoserverWorkspace, String baseUrl, AuditMessageObject auditMessageObject) {
        this.entityManager = entityManager;
        this.application = application;
        this.appLayer = appLayer;
        this.geoserverWorkspace = geoserverWorkspace;
        this.baseUrl = baseUrl;
        this.service = service;
        this.layer = layer;
        this.filter = filter;
        this.auditMessageObject = auditMessageObject;
    }

    public boolean addLayer(String viewName, String title) {
        GeoService gs = this.retrieveUserLayerService();
        if (gs == null) {
            gs = this.createUserLayerService();
        }
        if (gs == null) {
            return false;
        }
        Layer newLayer = this.createLayer(viewName, gs, title);
        ApplicationLayer appLayer = null;
        if (newLayer != null) {
            appLayer = this.createAppLayer(newLayer, gs, viewName);
        }
        return appLayer != null;
    }

    public boolean removeLayer(ApplicationLayer appLayer) {
        Level level = this.application.getRoot().getParentInSubtree(appLayer);
        level.getLayers().remove(appLayer);
        StartLayer sl = (StartLayer)appLayer.getStartLayers().get(this.application);
        this.application.getStartLayers().remove(sl);
        this.entityManager.remove((Object)sl);
        this.entityManager.remove((Object)appLayer);
        this.entityManager.getTransaction().commit();
        this.entityManager.getTransaction().begin();
        SelectedContentCache.setApplicationCacheDirty((Application)this.application, (Boolean)Boolean.TRUE, (Boolean)true, (EntityManager)this.entityManager);
        this.entityManager.getTransaction().commit();
        return true;
    }

    private Layer createLayer(String viewName, GeoService gs, String title) {
        MutablePair pair = null;
        try {
            UpdateResult result = GeoserviceFactoryHelper.update((EntityManager)this.entityManager, (GeoService)gs);
            gs.setName(USERLAYER_NAME);
            this.entityManager.persist((Object)gs);
            if (result.getStatus() == UpdateResult.Status.FAILED) {
                LOG.error((Object)("Updating service failed: " + result.getMessage()), result.getException());
                return null;
            }
            pair = (MutablePair)result.getLayerStatus().get(viewName);
        }
        catch (Exception e) {
            LOG.error((Object)"Error updating service failed: ", (Throwable)e);
        }
        if (pair.right == UpdateResult.Status.NEW) {
            Layer l = (Layer)pair.left;
            l.setUserlayer(true);
            l.getDetails().put("userlayer_date_added", new ClobElement(this.dateFormat.format(new Date())));
            l.getDetails().put("userlayer_filter", new ClobElement(this.filter));
            l.getDetails().put("userlayer_original_layerid", new ClobElement(this.layer.getId().toString()));
            l.getDetails().put("userlayer_original_layername", new ClobElement(this.layer.getName()));
            l.getDetails().put("userlayer_user", new ClobElement(this.auditMessageObject.getUsername()));
            l.getReaders().addAll(this.layer.getReaders());
            this.processFeatureType(l, viewName);
            return l;
        }
        return null;
    }

    private void processFeatureType(Layer l, String viewName) {
        if (this.layer.getFeatureType() != null && this.layer.getFeatureType().getFeatureSource() instanceof JDBCFeatureSource) {
            JDBCFeatureSource fs = (JDBCFeatureSource)this.layer.getFeatureType().getFeatureSource();
            try {
                Date start = new Date();
                FeatureSourceFactoryHelper.update((EntityManager)this.entityManager, (FeatureSource)fs);
                Date end = new Date();
                LOG.error((Object)("time: " + (end.getTime() - start.getTime())));
                SimpleFeatureType newFt = fs.getFeatureType(viewName);
                l.setFeatureType(newFt);
                this.copyRelations(newFt);
            }
            catch (Exception e) {
                LOG.error((Object)"Error processing featuretype/featuresource", (Throwable)e);
            }
        }
    }

    private void copyRelations(SimpleFeatureType sft) {
        List rels = this.layer.getFeatureType().getRelations();
        for (FeatureTypeRelation rel : rels) {
            FeatureTypeRelation copy = new FeatureTypeRelation();
            copy.setFeatureType(sft);
            copy.setForeignFeatureType(rel.getForeignFeatureType());
            copy.setType(rel.getType());
            List keys = rel.getRelationKeys();
            for (FeatureTypeRelationKey key : keys) {
                FeatureTypeRelationKey keyCopy = new FeatureTypeRelationKey();
                keyCopy.setRightSide(key.getRightSide());
                keyCopy.setLeftSide(key.getLeftSide());
                keyCopy.setRelation(copy);
                copy.getRelationKeys().add(keyCopy);
            }
            sft.getRelations().add(copy);
        }
    }

    private ApplicationLayer createAppLayer(Layer l, GeoService gs, String viewName) {
        try {
            ApplicationLayer newAppLayer = new ApplicationLayer();
            newAppLayer.setService(gs);
            newAppLayer.setLayerName(viewName);
            newAppLayer.getReaders().addAll(this.appLayer.getReaders());
            StartLayer sl = new StartLayer();
            sl.setApplication(this.application);
            sl.setApplicationLayer(newAppLayer);
            newAppLayer.getStartLayers().put(this.application, sl);
            this.application.getStartLayers().add(sl);
            Level currentLevel = this.application.getRoot().getParentInSubtree(this.appLayer);
            currentLevel.getLayers().add(0, newAppLayer);
            this.entityManager.persist((Object)this.application);
            this.entityManager.getTransaction().commit();
            this.createdAppLayer = newAppLayer;
            this.layer = l;
            this.entityManager.getTransaction().begin();
            SelectedContentCache.setApplicationCacheDirty((Application)this.application, (Boolean)Boolean.TRUE, (Boolean)true, (EntityManager)this.entityManager);
            this.entityManager.getTransaction().commit();
            this.entityManager.getTransaction().begin();
            SimpleFeatureTypeHelper.synchronizeFeaturetype((ApplicationLayer)newAppLayer, (EntityManager)this.entityManager, null, null, null, (boolean)true);
            newAppLayer.getAttributes().forEach(configuredAttribute -> configuredAttribute.setVisible(true));
            this.entityManager.persist((Object)newAppLayer);
            this.entityManager.getTransaction().commit();
            return newAppLayer;
        }
        catch (Exception e) {
            LOG.error((Object)"Error while inserting new layer into tailormap database: ", (Throwable)e);
            return null;
        }
    }

    private GeoService retrieveUserLayerService() {
        List services = this.entityManager.createQuery("select distinct gs from GeoService gs where gs.url like :q ").setParameter("q", (Object)("%" + this.geoserverWorkspace + "%")).setMaxResults(1).getResultList();
        return services.isEmpty() ? null : (GeoService)services.get(0);
    }

    private GeoService createUserLayerService() {
        WMSService userlayerService = null;
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("username", this.service.getUsername());
            params.put("password", this.service.getPassword());
            params.put("skipDiscoverWFS", true);
            String url = this.baseUrl + this.geoserverWorkspace + "/wms";
            WaitPageStatus status = new WaitPageStatus();
            userlayerService = WMSServiceHelper.loadFromUrl((String)url, params, (WaitPageStatus)status, (EntityManager)this.entityManager);
            userlayerService.setException_type(WMSExceptionType.Inimage);
            userlayerService.setName(USERLAYER_NAME);
            userlayerService.setUsername(this.service.getUsername());
            userlayerService.setPassword(this.service.getPassword());
            userlayerService.getReaders().addAll(this.service.getReaders());
            Category category = (Category)this.entityManager.find(Category.class, (Object)this.service.getCategory().getId());
            userlayerService.setCategory(category);
            category.getServices().add(userlayerService);
            status.setCurrentAction("Service opslaan.");
            this.entityManager.persist((Object)userlayerService);
            this.entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            LOG.error((Object)"Error creating GeoService: ", (Throwable)e);
        }
        return userlayerService;
    }

    public ApplicationLayer getCreatedAppLayer() {
        return this.createdAppLayer;
    }

    public Layer getLayer() {
        return this.layer;
    }
}

