/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.util;

import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsNotEqualTo;

public class ChangeMatchCase
extends DuplicatingFilterVisitor {
    private FilterFactory2 factory = CommonFactoryFinder.getFilterFactory2();
    private boolean matchCase = true;

    public ChangeMatchCase() {
    }

    public ChangeMatchCase(boolean newMatchCase) {
        this();
        this.matchCase = newMatchCase;
    }

    public Object visit(PropertyIsEqualTo filter, Object data) {
        return this.factory.equal(filter.getExpression1(), filter.getExpression2(), this.matchCase);
    }

    public Object visit(PropertyIsGreaterThan filter, Object data) {
        return this.factory.greater(filter.getExpression1(), filter.getExpression2(), this.matchCase);
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object data) {
        return this.factory.greaterOrEqual(filter.getExpression1(), filter.getExpression2(), this.matchCase);
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object data) {
        return this.factory.lessOrEqual(filter.getExpression1(), filter.getExpression2(), this.matchCase);
    }

    public Object visit(PropertyIsNotEqualTo filter, Object data) {
        return this.factory.notEqual(filter.getExpression1(), filter.getExpression2(), this.matchCase);
    }
}

