/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.stripes;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.tailormap.viewer.stripes.LayerListActionBean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

@UrlBinding(value="/action/Drawing")
@StrictBinding
public class DrawingActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(LayerListActionBean.class);
    private ActionBeanContext context;
    @Validate
    private FileBean featureFile;
    @Validate
    private String saveObject;
    @Validate
    private String title;
    @Validate
    private String description;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public FileBean getFeatureFile() {
        return this.featureFile;
    }

    public void setFeatureFile(FileBean featureFile) {
        this.featureFile = featureFile;
    }

    public String getSaveObject() {
        return this.saveObject;
    }

    public void setSaveObject(String saveObject) {
        this.saveObject = saveObject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DefaultHandler
    public Resolution upload() {
        JSONObject json = new JSONObject();
        File features = null;
        InputStream in = null;
        FileOutputStream out = null;
        try {
            json.put("success", (Object)Boolean.FALSE);
            features = File.createTempFile("Import", ".txt");
            in = this.featureFile.getInputStream();
            out = new FileOutputStream(features);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            try {
                in.close();
                ((OutputStream)out).close();
            }
            catch (IOException ex) {
                log.error((Object)"Error closing streams:", (Throwable)ex);
            }
            String contents = FileUtils.readFileToString((File)features);
            Map<String, Double> extent = this.getBBOX(contents);
            json.put("extent", extent);
            json.put("success", (Object)Boolean.TRUE);
            json.put("content", (Object)contents);
        }
        catch (JSONException ex) {
            log.error((Object)"Error on json", (Throwable)ex);
        }
        catch (IOException e) {
            log.error((Object)"Error reading gml file:", (Throwable)e);
        }
        finally {
            features.delete();
        }
        return new StreamingResolution("text/html", (Reader)new StringReader(json.toString()));
    }

    private Map<String, Double> getBBOX(String contents) throws JSONException {
        JSONObject json = new JSONObject(contents);
        String featureString = json.getString("features");
        JSONArray features = new JSONArray(featureString);
        ArrayList<Geometry> polys = new ArrayList<Geometry>();
        HashMap<String, Double> extent = new HashMap<String, Double>();
        for (int i = 0; i < features.length(); ++i) {
            JSONObject feature = features.getJSONObject(i);
            String wkt = feature.getString("wktgeom");
            if (wkt == null) continue;
            try {
                Geometry geom = new WKTReader().read(wkt);
                polys.add(geom);
                continue;
            }
            catch (ParseException e) {
                log.error((Object)("Failed to parse geometry >" + wkt + "<. Message: " + e.getMessage()));
                continue;
            }
            catch (Exception e) {
                log.info((Object)"Error parsing feature, skipped.", (Throwable)e);
            }
        }
        if (polys != null) {
            GeometryFactory gf = new GeometryFactory(new PrecisionModel(), 28992);
            GeometryCollection mg = new GeometryCollection(polys.toArray(new Geometry[polys.size()]), gf);
            Envelope envelope = mg.getEnvelopeInternal();
            envelope.expandBy(500.0);
            extent.put("minx", envelope.getMinX());
            extent.put("miny", envelope.getMinY());
            extent.put("maxx", envelope.getMaxX());
            extent.put("maxy", envelope.getMaxY());
        } else {
            extent = null;
        }
        return extent;
    }

    public Resolution save() {
        Date nowDate = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
        sdf.applyPattern("HH-mm_dd-MM-yyyy");
        String now = sdf.format(nowDate);
        String fileName = this.title + now;
        return new StreamingResolution("text/plain"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stream(HttpServletResponse response) throws Exception {
                try (ServletOutputStream out = response.getOutputStream();){
                    File features = File.createTempFile("Features", ".txt");
                    JSONObject file = new JSONObject();
                    file.put("title", (Object)DrawingActionBean.this.title);
                    file.put("description", (Object)DrawingActionBean.this.description);
                    file.put("features", (Object)DrawingActionBean.this.saveObject);
                    FileUtils.writeStringToFile((File)features, (String)file.toString());
                    FileInputStream in = null;
                    try {
                        in = new FileInputStream(features);
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                    }
                    catch (IOException ex) {
                        log.error((Object)"Could not write zip to output: ", (Throwable)ex);
                    }
                    finally {
                        out.close();
                        ((InputStream)in).close();
                        features.delete();
                    }
                }
            }
        }.setAttachment(true).setFilename(fileName + ".txt");
    }
}

