/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.stripes;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.tailormap.commons.HttpClientConfigured;
import nl.tailormap.viewer.audit.AuditMessageObject;
import nl.tailormap.viewer.audit.Auditable;
import nl.tailormap.viewer.config.security.Group;
import nl.tailormap.viewer.config.security.User;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.helpers.AuthorizationsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/proxy/{mode}")
@StrictBinding
public class ProxyActionBean
implements ActionBean,
Auditable {
    private static final Log log = LogFactory.getLog(ProxyActionBean.class);
    private ActionBeanContext context;
    private AuditMessageObject auditMessageObject;
    @Validate
    private String url;
    @Validate
    private String mode;
    @Validate
    private boolean mustLogin;
    @Validate
    private Long serviceId;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public boolean isMustLogin() {
        return this.mustLogin;
    }

    public void setMustLogin(boolean mustLogin) {
        this.mustLogin = mustLogin;
    }

    public Long getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(Long serviceId) {
        this.serviceId = serviceId;
    }

    @DefaultHandler
    public Resolution proxy() throws Exception {
        HttpServletRequest request = this.getContext().getRequest();
        HttpSession sess = request.getSession(false);
        if (sess == null || this.url == null || this.serviceId == null) {
            return new ErrorResolution(403, "Proxy requests forbidden");
        }
        if ("wms".equals(this.mode)) {
            return this.proxyWMS();
        }
        return new ErrorResolution(403, "Proxy mode unacceptable");
    }

    private Resolution proxyWMS() throws IOException, URISyntaxException {
        URL theUrl;
        HttpServletRequest request = this.getContext().getRequest();
        if (!"GET".equals(request.getMethod())) {
            return new ErrorResolution(403);
        }
        EntityManager em = Stripersist.getEntityManager();
        try {
            theUrl = this.getRequestRL(em);
        }
        catch (IllegalAccessException ex) {
            return new ErrorResolution(403);
        }
        final HttpClientConfigured client = this.getHttpClient(theUrl, em);
        HttpUriRequest req = this.getHttpRequest(theUrl);
        GeoService gs = (GeoService)em.find(GeoService.class, (Object)this.serviceId);
        if (gs.getGeofenceHeader() != null) {
            User user = (User)em.find(User.class, (Object)this.context.getRequest().getUserPrincipal().getName());
            String headerValue = "";
            for (Group g : user.getGroups()) {
                if (g.getDescription() == null || !g.getDescription().equals("geofence")) continue;
                headerValue = g.getName();
                break;
            }
            req.addHeader(gs.getGeofenceHeader(), headerValue);
        }
        try {
            HttpResponse response = client.execute(req);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode >= 200 && statusCode < 300) {
                final HttpResponse finalResponse = response;
                final HttpEntity entity = response.getEntity();
                return new StreamingResolution(entity.getContentType().getValue()){

                    protected void stream(HttpServletResponse resp) throws IOException {
                        try {
                            entity.writeTo((OutputStream)resp.getOutputStream());
                        }
                        finally {
                            if (finalResponse != null) {
                                client.close(finalResponse);
                            }
                            client.close();
                        }
                    }
                };
            }
            return new ErrorResolution(statusCode, "Service returned: " + response.getStatusLine().getReasonPhrase());
        }
        catch (IOException e) {
            log.error((Object)"Failed to write output:", (Throwable)e);
            return null;
        }
    }

    protected URL getRequestRL(EntityManager em) throws MalformedURLException, UnsupportedEncodingException, IllegalAccessException {
        URL theUrl = new URL(this.url);
        ArrayList<String> allowedParams = new ArrayList<String>();
        allowedParams.add("VERSION");
        allowedParams.add("SERVICE");
        allowedParams.add("REQUEST");
        allowedParams.add("UPDATESEQUENCE");
        allowedParams.add("LAYERS");
        allowedParams.add("LAYER");
        allowedParams.add("STYLES");
        allowedParams.add("SRS");
        allowedParams.add("CRS");
        allowedParams.add("BBOX");
        allowedParams.add("FORMAT");
        allowedParams.add("WIDTH");
        allowedParams.add("HEIGHT");
        allowedParams.add("TRANSPARENT");
        allowedParams.add("BGCOLOR");
        allowedParams.add("EXCEPTIONS");
        allowedParams.add("TIME");
        allowedParams.add("ELEVATION");
        allowedParams.add("QUERY_LAYERS");
        allowedParams.add("X");
        allowedParams.add("Y");
        allowedParams.add("I");
        allowedParams.add("J");
        allowedParams.add("INFO_FORMAT");
        allowedParams.add("FEATURE_COUNT");
        allowedParams.add("SLD");
        allowedParams.add("SLD_BODY");
        allowedParams.add("MAP");
        allowedParams.add("VIEWPARAMS");
        allowedParams.add("ENV");
        allowedParams.add("TILEMATRIXSET");
        allowedParams.add("TILEMATRIX");
        allowedParams.add("TILEROW");
        allowedParams.add("TILECOL");
        allowedParams.add("STYLE");
        allowedParams.add("SCALE");
        String query = theUrl.getQuery();
        HashMap<String, String[]> paramsMap = new HashMap<String, String[]>(this.getContext().getRequest().getParameterMap());
        StringBuilder paramsFromRequest = this.validateParams(paramsMap, allowedParams);
        if ((query == null || query.length() == 0) && paramsFromRequest.length() == 0) {
            throw new IllegalAccessException();
        }
        String[] params = query != null ? query.split("&") : new String[]{};
        StringBuilder paramsFromUrl = this.validateParams(params, allowedParams);
        if (paramsFromUrl.length() > 0 && paramsFromUrl.charAt(paramsFromUrl.length() - 1) != '&') {
            paramsFromUrl.append('&');
        }
        paramsFromUrl.append((CharSequence)paramsFromRequest);
        int index = paramsFromUrl.charAt(0) == '&' ? 1 : 0;
        String paramString = paramsFromUrl.substring(index);
        GeoService gs = (GeoService)em.find(GeoService.class, (Object)this.serviceId);
        StringBuilder sbTheUrl = new StringBuilder(gs.getUrl());
        if (sbTheUrl.indexOf("?") < 0) {
            sbTheUrl.append('?');
        } else if (sbTheUrl.charAt(sbTheUrl.length() - 1) != '&') {
            sbTheUrl.append('&');
        }
        sbTheUrl.append(paramString);
        theUrl = new URL(sbTheUrl.toString());
        return theUrl;
    }

    public HttpClientConfigured getHttpClient(URL theUrl, EntityManager em) {
        String username = null;
        String password = null;
        if (this.mustLogin && this.serviceId != null) {
            GeoService gs = (GeoService)em.find(GeoService.class, (Object)this.serviceId);
            Set readers = gs.getReaders();
            Set userroles = AuthorizationsHelper.getRoles((HttpServletRequest)this.context.getRequest(), (EntityManager)em);
            boolean allowed = false;
            block0: for (String userrole : userroles) {
                for (String reader : readers) {
                    if (!userrole.equals(reader)) continue;
                    allowed = true;
                    continue block0;
                }
            }
            if (allowed) {
                username = gs.getUsername();
                password = gs.getPassword();
                this.auditMessageObject.addMessage((Object)String.format("Authenticated request for service '%s'", gs.getName()));
            }
        }
        HttpClientConfigured client = new HttpClientConfigured(username, password, theUrl.toString());
        return client;
    }

    public HttpUriRequest getHttpRequest(URL url) throws URISyntaxException {
        return new HttpGet(url.toURI());
    }

    private StringBuilder validateParams(String[] params, List<String> allowedParams) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        for (String param : params) {
            String[] splitted = param.split("=");
            if (allowedParams.contains(splitted[0].toUpperCase())) {
                if (splitted.length > 1) {
                    sb.append(param.split("=")[0]);
                    sb.append("=");
                    sb.append(param.split("=")[1]);
                } else {
                    sb.append(splitted[0]);
                }
                sb.append("&");
                continue;
            }
            log.warn((Object)("Ignored unknown param " + param));
        }
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '&') {
            sb.setLength(sb.length() - 1);
        }
        return sb;
    }

    private StringBuilder validateParams(Map<String, String[]> params, List<String> allowedParams) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        for (String param : params.keySet()) {
            if (!allowedParams.contains(param.toUpperCase())) continue;
            sb.append(URLEncoder.encode(param, "UTF-8"));
            sb.append("=");
            String[] paramValue = params.get(param);
            for (int i = 0; i < paramValue.length; ++i) {
                String val = paramValue[i];
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(URLEncoder.encode(val, "UTF-8"));
            }
            sb.append("&");
        }
        return sb;
    }

    public AuditMessageObject getAuditMessageObject() {
        return this.auditMessageObject;
    }

    @Before(stages={LifecycleStage.EventHandling})
    public void initAudit() {
        this.auditMessageObject = new AuditMessageObject();
    }
}

