/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.Validate;
import nl.tailormap.geotools.filter.visitor.RemoveDistanceUnit;
import nl.tailormap.viewer.audit.AuditMessageObject;
import nl.tailormap.viewer.audit.Auditable;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.config.services.SimpleFeatureType;
import nl.tailormap.viewer.helpers.featuresources.FeatureSourceFactoryHelper;
import nl.tailormap.viewer.stripes.LocalizableApplicationActionBean;
import nl.tailormap.viewer.stripes.SldActionBean;
import nl.tailormap.viewer.util.ChangeMatchCase;
import nl.tailormap.viewer.util.FilterHelper;
import nl.tailormap.viewer.util.TailormapCQL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.json.JSONObject;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/statisticanalysis")
@StrictBinding
public class StatisticAnalysisActionBean
extends LocalizableApplicationActionBean
implements Auditable {
    private static final Log log = LogFactory.getLog(SldActionBean.class);
    private AuditMessageObject auditMessageObject;
    private ActionBeanContext context;
    @Validate
    private Application application;
    @Validate
    private ApplicationLayer appLayer;
    @Validate
    private SimpleFeatureType featureType;
    private Layer layer = null;
    @Validate
    private String type;
    @Validate
    private String column;
    @Validate
    private String filter;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public ApplicationLayer getAppLayer() {
        return this.appLayer;
    }

    public void setAppLayer(ApplicationLayer appLayer) {
        this.appLayer = appLayer;
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(SimpleFeatureType featureType) {
        this.featureType = featureType;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public AuditMessageObject getAuditMessageObject() {
        return this.auditMessageObject;
    }

    public void setAuditMessageObject(AuditMessageObject auditMessageObject) {
        this.auditMessageObject = auditMessageObject;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    @Before(stages={LifecycleStage.EventHandling})
    public void initAudit() {
        this.auditMessageObject = new AuditMessageObject();
    }

    @After(stages={LifecycleStage.BindingAndValidation})
    public void loadLayer() {
        this.layer = this.appLayer.getService().getSingleLayer(this.appLayer.getLayerName(), Stripersist.getEntityManager());
    }

    @DefaultHandler
    public Resolution analyse() {
        JSONObject json = new JSONObject();
        json.put("success", false);
        try {
            AnalysisType analysis = this.getAnalysisType();
            if (analysis == null) {
                json.put("message", (Object)("Wrong type of analysis :" + this.type));
            }
            if (analysis != null && (this.featureType != null || this.layer != null && this.layer.getFeatureType() != null)) {
                SimpleFeatureType ft = this.featureType;
                if (ft == null) {
                    ft = this.layer.getFeatureType();
                }
                FeatureSource fs = FeatureSourceFactoryHelper.openGeoToolsFeatureSource((SimpleFeatureType)ft);
                Query q = new Query(fs.getName().toString());
                this.setFilter(this.filter, q, ft, Stripersist.getEntityManager());
                SimpleFeatureCollection fc = (SimpleFeatureCollection)fs.getFeatures(q);
                FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
                Function unique = ff.function(analysis.geotoolsFunction, new Expression[]{ff.property(this.column)});
                Object value = unique.evaluate((Object)fc);
                json.put("result", value);
                json.put("success", true);
                this.auditMessageObject.addMessage((Object)ft);
                this.auditMessageObject.addMessage((Object)q);
                this.auditMessageObject.addMessage((Object)fs);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error loading features", (Throwable)e);
            Object message = MessageFormat.format(this.getBundle().getString("viewer.downloadfeaturesactionbean.1"), e.toString());
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                message = (String)message + "; " + cause.toString();
            }
            json.put("message", message);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    private AnalysisType getAnalysisType() {
        AnalysisType[] types;
        for (AnalysisType analysisType : types = AnalysisType.values()) {
            if (!analysisType.name().equals(this.type)) continue;
            return analysisType;
        }
        return null;
    }

    private void setFilter(String filter, Query q, SimpleFeatureType ft, EntityManager em) throws Exception {
        if (filter != null && filter.trim().length() > 0) {
            Filter f = TailormapCQL.toFilter(filter, em);
            f = (Filter)f.accept((FilterVisitor)new RemoveDistanceUnit(), null);
            f = (Filter)f.accept((FilterVisitor)new ChangeMatchCase(false), null);
            f = FilterHelper.reformatFilter(f, ft);
            q.setFilter(f);
        }
    }

    public static enum AnalysisType {
        SUM("Collection_Sum"),
        MIN("Collection_Min"),
        MAX("Collection_Max"),
        COUNT("Collection_Count"),
        AVERAGE("Collection_Average");

        private final String geotoolsFunction;

        private AnalysisType(String geotoolsFunction) {
            this.geotoolsFunction = geotoolsFunction;
        }
    }
}

