/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.tailormap.i18n.LocalizableActionBean;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.config.services.SimpleFeatureType;
import nl.tailormap.viewer.helpers.featuresources.FeatureSourceFactoryHelper;
import nl.tailormap.viewer.util.TailormapCQL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.filter.Filter;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/uniquevalues")
public class UniqueValuesActionBean
extends LocalizableActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(UniqueValuesActionBean.class);
    private ActionBeanContext context;
    @Validate
    private ApplicationLayer applicationLayer;
    @Validate
    private SimpleFeatureType featureType;
    @Validate
    private String[] attributes;
    @Validate
    private String attribute;
    @Validate
    private String operator;
    @Validate
    private int maxFeatures = 250;
    @Validate
    private String filter;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public ApplicationLayer getApplicationLayer() {
        return this.applicationLayer;
    }

    public void setApplicationLayer(ApplicationLayer applicationLayer) {
        this.applicationLayer = applicationLayer;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String[] attributes) {
        this.attributes = attributes;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    public void setMaxFeatures(int maxFeatures) {
        this.maxFeatures = maxFeatures;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @DefaultHandler
    public Resolution getUniqueValues() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        try {
            Layer layer;
            if (this.featureType == null && (layer = this.applicationLayer.getService().getSingleLayer(this.applicationLayer.getLayerName(), Stripersist.getEntityManager())) != null && layer.getFeatureType() != null) {
                this.featureType = layer.getFeatureType();
            }
            JSONObject uniqueValues = new JSONObject();
            for (int i = 0; i < this.attributes.length; ++i) {
                String attribute = this.attributes[i];
                Filter f = this.filter != null ? TailormapCQL.toFilter(this.filter, Stripersist.getEntityManager()) : null;
                List beh = FeatureSourceFactoryHelper.calculateUniqueValues((SimpleFeatureType)this.featureType, (String)attribute, (int)this.maxFeatures, (Filter)f);
                uniqueValues.put(attribute, (Object)new JSONArray((Collection)beh));
                json.put("success", (Object)Boolean.TRUE);
            }
            json.put("uniqueValues", (Object)uniqueValues);
        }
        catch (Exception e) {
            log.error((Object)"getUniqueValues() failed", (Throwable)e);
            json.put("msg", (Object)MessageFormat.format(this.getBundle().getString("viewer.uniquevaluesactionbean.1"), this.applicationLayer.getLayerName(), e.toString()));
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    public Resolution getKeyValuePairs() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        try {
            Layer layer;
            if (this.attributes.length != 2) {
                throw new IllegalArgumentException(this.getBundle().getString("viewer.uniquevaluesactionbean.2"));
            }
            if (this.featureType == null && (layer = this.applicationLayer.getService().getSingleLayer(this.applicationLayer.getLayerName(), Stripersist.getEntityManager())) != null && layer.getFeatureType() != null) {
                this.featureType = layer.getFeatureType();
            }
            Map pairs = FeatureSourceFactoryHelper.getKeyValuePairs((SimpleFeatureType)this.featureType, (String)this.attributes[0], (String)this.attributes[1], (int)this.maxFeatures);
            json.put("valuePairs", pairs);
            json.put("success", (Object)Boolean.TRUE);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"getKeyValuePairs() failed", (Throwable)e);
            json.put("msg", (Object)e.toString());
        }
        catch (Exception e) {
            log.error((Object)"getKeyValuePairs() failed", (Throwable)e);
            json.put("msg", (Object)MessageFormat.format(this.getBundle().getString("viewer.uniquevaluesactionbean.3"), this.applicationLayer.getLayerName(), e.toString()));
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    public Resolution getMinMaxValue() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        try {
            Layer layer = this.applicationLayer.getService().getSingleLayer(this.applicationLayer.getLayerName(), Stripersist.getEntityManager());
            if (layer != null && layer.getFeatureType() != null) {
                SimpleFeatureType sft = layer.getFeatureType();
                Filter f = this.filter != null ? TailormapCQL.toFilter(this.filter, Stripersist.getEntityManager()) : null;
                Object value = this.operator.equals("#MAX#") ? FeatureSourceFactoryHelper.getMaxValue((SimpleFeatureType)sft, (String)this.attribute, (int)this.maxFeatures, (Filter)f) : FeatureSourceFactoryHelper.getMinValue((SimpleFeatureType)sft, (String)this.attribute, (int)this.maxFeatures, (Filter)f);
                json.put("value", (Object)value.toString());
                json.put("success", (Object)Boolean.TRUE);
            }
        }
        catch (Exception e) {
            log.error((Object)"getMinMaxValue() failed", (Throwable)e);
            json.put("msg", (Object)MessageFormat.format(this.getBundle().getString("viewer.uniquevaluesactionbean.4"), this.attribute, e.toString()));
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(SimpleFeatureType featureType) {
        this.featureType = featureType;
    }
}

