/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.stripes;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ConfiguredComponent;
import nl.tailormap.viewer.stripes.LocalizableApplicationActionBean;
import nl.tailormap.viewer.stripes.SplitFeatureActionBean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/wkt")
@StrictBinding
public class WriteWKTActionBean
extends LocalizableApplicationActionBean
implements ActionBean {
    private static final Log log = LogFactory.getLog(SplitFeatureActionBean.class);
    private static final String COMPONENT_NAME = "viewer.components.DownloadWKT";
    private static final String BASE_PATH = "basePath";
    private ActionBeanContext context;
    @Validate
    private Application application;
    @Validate
    private String wkt;
    @Validate
    private String type;
    @Validate
    private String mailaddress;
    @Validate
    private String filename;

    @DefaultHandler
    public Resolution write() {
        JSONObject obj = new JSONObject();
        obj.put("success", false);
        EntityManager em = Stripersist.getEntityManager();
        Set components = this.application.getComponents();
        for (ConfiguredComponent comp : components) {
            if (!comp.getClassName().equals(COMPONENT_NAME)) continue;
            JSONObject config = new JSONObject(comp.getConfig());
            String basepath = config.optString(BASE_PATH);
            if (basepath != null && !basepath.isEmpty()) {
                File base = new File(basepath, this.type + File.separator);
                if (!base.exists() && !base.mkdir()) {
                    log.error((Object)("Can not create folder " + base.getAbsolutePath() + "."));
                }
                if (base.exists() && base.canWrite()) {
                    Date nowDate = new Date(System.currentTimeMillis());
                    SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
                    sdf.applyPattern("HH-mm_dd-MM-yyyy");
                    String now = sdf.format(nowDate);
                    File f = new File(base, this.filename + now + ".txt");
                    try {
                        JSONObject file = new JSONObject();
                        file.put("title", (Object)this.filename);
                        file.put("description", (Object)this.mailaddress);
                        file.put("features", (Object)this.wkt);
                        FileUtils.writeStringToFile((File)f, (String)file.toString(), (String)"UTF-8");
                        obj.put("success", true);
                    }
                    catch (IOException ex) {
                        obj.put("message", (Object)this.getBundle().getString("viewer.writewktactionbean.1"));
                        log.error((Object)"Error writing wkt file: ", (Throwable)ex);
                    }
                    break;
                }
                obj.put("message", (Object)this.getBundle().getString("viewer.writewktactionbean.2"));
                break;
            }
            obj.put("message", (Object)this.getBundle().getString("viewer.writewktactionbean.3"));
            log.error((Object)"Error writing wkt file: Base path not configured. Contact your administrator.");
            break;
        }
        return new StreamingResolution("application/json", obj.toString());
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public String getWkt() {
        return this.wkt;
    }

    public void setWkt(String wkt) {
        this.wkt = wkt;
    }

    public String getMailaddress() {
        return this.mailaddress;
    }

    public void setMailaddress(String mailaddress) {
        this.mailaddress = mailaddress;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

