/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.userlayer;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.json.JSONArray;
import org.json.JSONObject;

public class GeoServerManager {
    public static final String GEOSERVER_PATTERN = "/geoserver/";
    private static final Log LOG = LogFactory.getLog(GeoServerManager.class);
    private final String baseUrl;
    private final String userName;
    private final String passWord;
    private final String workSpace;
    private final String storeName;

    public GeoServerManager(String userName, String passWord, String targetWorkSpace, String storeName, String baseUrl) {
        this.userName = userName;
        this.passWord = passWord;
        this.workSpace = targetWorkSpace;
        this.storeName = storeName;
        this.baseUrl = baseUrl;
    }

    public boolean createLayer(String layerName, String layerTitle, String resourceName) {
        boolean success = false;
        JSONObject content = new JSONObject();
        content.put("name", (Object)layerName);
        content.put("nativeName", (Object)resourceName);
        content.put("title", (Object)layerTitle);
        content.put("abstract", (Object)("UserLayer gemaakt met Tailormap GeoServerManager van tabel " + resourceName));
        JSONObject keywords = new JSONObject();
        JSONArray keyword = new JSONArray();
        keyword.put((Object)"userlayer");
        keyword.put((Object)"layerName");
        keyword.put((Object)"layerTitle");
        keyword.put((Object)"resourceName");
        keyword.put((Object)"Tailormap");
        keyword.put((Object)"GBI");
        keyword.put((Object)"GBIworld");
        keywords.put("string", (Object)keyword);
        content.put("keywords", (Object)keywords);
        content.put("nativeCRS", (Object)"EPSG:28992");
        content.put("srs", (Object)"EPSG:28992");
        JSONObject featureType = new JSONObject();
        featureType.put("featureType", (Object)content);
        LOG.trace((Object)("New featuretype JSON document:\n" + featureType.toString(4)));
        HttpPost post = new HttpPost(this.baseUrl + "rest/workspaces/" + this.workSpace + "/datastores/" + this.storeName + "/featuretypes");
        post.setEntity((HttpEntity)new StringEntity(featureType.toString(), StandardCharsets.UTF_8));
        post.addHeader((Header)new BasicHeader("Content-Type", "application/json"));
        try (CloseableHttpClient httpClient = this.getClient();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
            LOG.debug((Object)String.format("Result of creating WMS layer %s is %s: %s", layerName, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
            success = response.getStatusLine().getStatusCode() == 201;
        }
        catch (IOException e) {
            LOG.error((Object)("Creating WMS layer failed. " + e.getLocalizedMessage()));
        }
        return success;
    }

    public boolean deleteLayer(String layerName) {
        boolean success = false;
        HttpDelete delete = new HttpDelete(this.baseUrl + "rest/workspaces/" + this.workSpace + "/layers/" + layerName + "?recurse=true");
        try (CloseableHttpClient httpClient = this.getClient();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)delete);){
            LOG.debug((Object)String.format("Result of deleting WMS layer %s is %s: %s", layerName, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
            success = response.getStatusLine().getStatusCode() == 200;
        }
        catch (IOException e) {
            LOG.error((Object)("Deleting WMS layer failed. " + e.getLocalizedMessage()));
        }
        return success;
    }

    public boolean deleteStyle(String layerName) {
        boolean success = false;
        HttpDelete delete = new HttpDelete(this.baseUrl + "rest/workspaces/" + this.workSpace + "/styles/" + layerName + "?purge=true");
        try (CloseableHttpClient httpClient = this.getClient();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)delete);){
            LOG.debug((Object)String.format("Result of deleting CSS style %s is %s: %s", layerName, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
            success = response.getStatusLine().getStatusCode() == 200;
        }
        catch (IOException e) {
            LOG.error((Object)("Deleting style failed. " + e.getLocalizedMessage()));
        }
        return success;
    }

    public boolean addStyleToLayer(String layerName, String cssStyle) {
        boolean success = false;
        JSONObject styleInfo = new JSONObject();
        JSONObject content = new JSONObject();
        content.put("name", (Object)layerName).put("filename", (Object)(layerName + ".css"));
        styleInfo.put("style", (Object)content);
        HttpPost post = new HttpPost(this.baseUrl + "rest/workspaces/" + this.workSpace + "/styles");
        post.setEntity((HttpEntity)new StringEntity(styleInfo.toString(), ContentType.APPLICATION_JSON));
        post.addHeader("Content-Type", "application/json");
        LOG.debug((Object)("posting style " + post.toString()));
        HttpPut put = new HttpPut(this.baseUrl + "rest/workspaces/" + this.workSpace + "/styles/" + layerName + ".css");
        put.setEntity((HttpEntity)new StringEntity(cssStyle, StandardCharsets.UTF_8));
        put.addHeader("Content-Type", "application/vnd.geoserver.geocss+css");
        LOG.debug((Object)("putting CSS " + put.toString()));
        HttpPut putLayer = new HttpPut(this.baseUrl + "rest/workspaces/" + this.workSpace + "/layers/" + layerName);
        putLayer.setEntity((HttpEntity)new StringEntity("<layer><defaultStyle><name>" + layerName + "</name></defaultStyle><enabled>true</enabled></layer>", StandardCharsets.UTF_8));
        putLayer.addHeader("Content-Type", "application/xml");
        LOG.debug((Object)("putting layer config " + putLayer.toString()));
        try (CloseableHttpClient httpClient = this.getClient();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
             CloseableHttpResponse response2 = httpClient.execute((HttpUriRequest)put);
             CloseableHttpResponse response3 = httpClient.execute((HttpUriRequest)putLayer);){
            if (response.getStatusLine().getStatusCode() != 201) {
                LOG.error((Object)String.format("Result of creating CSS style %s is %s: %s", layerName, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
            }
            if (response2.getStatusLine().getStatusCode() != 200) {
                LOG.error((Object)String.format("Result of putting CSS style %s is %s: %s", layerName, response2.getStatusLine().getStatusCode(), response2.getStatusLine().getReasonPhrase()));
            }
            if (response3.getStatusLine().getStatusCode() != 200) {
                LOG.error((Object)String.format("Result of changing default style on %s is %s: %s", layerName, response3.getStatusLine().getStatusCode(), response3.getStatusLine().getReasonPhrase()));
            }
            success = response.getStatusLine().getStatusCode() == 201 && response2.getStatusLine().getStatusCode() == 200 && response3.getStatusLine().getStatusCode() == 200;
        }
        catch (IOException e) {
            LOG.error((Object)"Adding CSS style to layer failed. ", (Throwable)e);
        }
        return success;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    private CloseableHttpClient getClient() {
        List<Header> defaultHeaders = Arrays.asList(new Header[0]);
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.userName, this.passWord));
        return HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)provider).setDefaultHeaders(defaultHeaders).setUserAgent("Tailormap").build();
    }
}

