/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.web;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SharedSessionData
implements HttpSessionListener {
    private static final Log log = LogFactory.getLog(SharedSessionData.class);
    private static final Map<String, Map<String, String>> sessions = new ConcurrentHashMap<String, Map<String, String>>();

    public void sessionCreated(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        log.debug((Object)("adding a map for session: " + session.getId()));
        sessions.put(session.getId(), new ConcurrentHashMap(8));
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        log.debug((Object)("removing data for session: " + event.getSession().getId()));
        sessions.remove(event.getSession().getId());
    }

    public static Map<String, String> find(String sessionId) {
        log.debug((Object)("Looking for data associated with session: " + sessionId));
        if (sessions.containsKey(sessionId)) {
            return sessions.get(sessionId);
        }
        ConcurrentHashMap<String, String> m = new ConcurrentHashMap<String, String>(8);
        sessions.put(sessionId, m);
        return m;
    }
}

