/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.web.geotools;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.DataStoreFinder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.util.WeakCollectionCleaner;
import org.geotools.util.logging.Logging;

public class GeoToolsFilter
implements Filter {
    private static final Log log = LogFactory.getLog(GeoToolsFilter.class);

    public void init(FilterConfig fc) throws ServletException {
        try {
            Logging.ALL.setLoggerFactory("org.geotools.util.logging.Log4JLoggerFactory");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        finally {
            CRS.cleanupThreadLocals();
            Formattable.cleanupThreadLocals();
        }
    }

    public void destroy() {
        log.info((Object)"Calling WeakCollectionCleaner.exit()...");
        WeakCollectionCleaner.DEFAULT.exit();
        log.info((Object)"Resetting GeoTools...");
        DataAccessFinder.reset();
        DataStoreFinder.reset();
        CommonFactoryFinder.reset();
        ReferencingFactoryFinder.reset();
        DeferredAuthorityFactory.exit();
    }
}

